/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.hxi_extension.rest.api.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.alfresco.hxi_connector.hxi_extension.service.model.AnswerResponse;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AnswerModel {
    private static final String RESPONSE_STATUS_COMPLETE = "complete";
    private String answer;
    private String question;
    private boolean isComplete;
    private Set<ObjectReferenceModel> objectReferences;

    public static AnswerModel fromServiceModel(AnswerResponse response) {
        Set<ObjectReferenceModel> objectReferences = Optional.ofNullable(response.getObjectReferences()).map(refs -> refs.stream().map(ObjectReferenceModel::fromServiceModel).collect(Collectors.toSet())).orElse(Collections.emptySet());
        return AnswerModel.builder().question(response.getQuestion()).answer(response.getAnswer()).isComplete(RESPONSE_STATUS_COMPLETE.equalsIgnoreCase(response.getResponseCompleteness())).objectReferences(objectReferences).build();
    }

    @Generated
    public static AnswerModelBuilder builder() {
        return new AnswerModelBuilder();
    }

    @Generated
    public String toString() {
        return "AnswerModel(answer=" + this.getAnswer() + ", question=" + this.getQuestion() + ", isComplete=" + this.isComplete() + ", objectReferences=" + String.valueOf(this.getObjectReferences()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerModel)) {
            return false;
        }
        AnswerModel other = (AnswerModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isComplete() != other.isComplete()) {
            return false;
        }
        String this$answer = this.getAnswer();
        String other$answer = other.getAnswer();
        if (this$answer == null ? other$answer != null : !this$answer.equals(other$answer)) {
            return false;
        }
        String this$question = this.getQuestion();
        String other$question = other.getQuestion();
        if (this$question == null ? other$question != null : !this$question.equals(other$question)) {
            return false;
        }
        Set<ObjectReferenceModel> this$objectReferences = this.getObjectReferences();
        Set<ObjectReferenceModel> other$objectReferences = other.getObjectReferences();
        return !(this$objectReferences == null ? other$objectReferences != null : !((Object)this$objectReferences).equals(other$objectReferences));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnswerModel;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isComplete() ? 79 : 97);
        String $answer = this.getAnswer();
        result = result * 59 + ($answer == null ? 43 : $answer.hashCode());
        String $question = this.getQuestion();
        result = result * 59 + ($question == null ? 43 : $question.hashCode());
        Set<ObjectReferenceModel> $objectReferences = this.getObjectReferences();
        result = result * 59 + ($objectReferences == null ? 43 : ((Object)$objectReferences).hashCode());
        return result;
    }

    @Generated
    public String getAnswer() {
        return this.answer;
    }

    @Generated
    public String getQuestion() {
        return this.question;
    }

    @Generated
    public boolean isComplete() {
        return this.isComplete;
    }

    @Generated
    public Set<ObjectReferenceModel> getObjectReferences() {
        return this.objectReferences;
    }

    @Generated
    public AnswerModel(String answer, String question, boolean isComplete, Set<ObjectReferenceModel> objectReferences) {
        this.answer = answer;
        this.question = question;
        this.isComplete = isComplete;
        this.objectReferences = objectReferences;
    }

    @Generated
    public AnswerModel() {
    }

    @Generated
    public static class AnswerModelBuilder {
        @Generated
        private String answer;
        @Generated
        private String question;
        @Generated
        private boolean isComplete;
        @Generated
        private Set<ObjectReferenceModel> objectReferences;

        @Generated
        AnswerModelBuilder() {
        }

        @Generated
        public AnswerModelBuilder answer(String answer) {
            this.answer = answer;
            return this;
        }

        @Generated
        public AnswerModelBuilder question(String question) {
            this.question = question;
            return this;
        }

        @Generated
        public AnswerModelBuilder isComplete(boolean isComplete) {
            this.isComplete = isComplete;
            return this;
        }

        @Generated
        public AnswerModelBuilder objectReferences(Set<ObjectReferenceModel> objectReferences) {
            this.objectReferences = objectReferences;
            return this;
        }

        @Generated
        public AnswerModel build() {
            return new AnswerModel(this.answer, this.question, this.isComplete, this.objectReferences);
        }

        @Generated
        public String toString() {
            return "AnswerModel.AnswerModelBuilder(answer=" + this.answer + ", question=" + this.question + ", isComplete=" + this.isComplete + ", objectReferences=" + String.valueOf(this.objectReferences) + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ReferenceModel {
        private String referenceId;
        private double rankScore;
        private int rank;

        public static ReferenceModel fromServiceModel(AnswerResponse.Reference reference) {
            return ReferenceModel.builder().referenceId(reference.getReferenceId()).rankScore(reference.getRankScore()).rank(reference.getRank()).build();
        }

        @Generated
        public static ReferenceModelBuilder builder() {
            return new ReferenceModelBuilder();
        }

        @Generated
        public String toString() {
            return "AnswerModel.ReferenceModel(referenceId=" + this.getReferenceId() + ", rankScore=" + this.getRankScore() + ", rank=" + this.getRank() + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReferenceModel)) {
                return false;
            }
            ReferenceModel other = (ReferenceModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getRankScore(), other.getRankScore()) != 0) {
                return false;
            }
            if (this.getRank() != other.getRank()) {
                return false;
            }
            String this$referenceId = this.getReferenceId();
            String other$referenceId = other.getReferenceId();
            return !(this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ReferenceModel;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $rankScore = Double.doubleToLongBits(this.getRankScore());
            result = result * 59 + (int)($rankScore >>> 32 ^ $rankScore);
            result = result * 59 + this.getRank();
            String $referenceId = this.getReferenceId();
            result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
            return result;
        }

        @Generated
        public String getReferenceId() {
            return this.referenceId;
        }

        @Generated
        public double getRankScore() {
            return this.rankScore;
        }

        @Generated
        public int getRank() {
            return this.rank;
        }

        @Generated
        public ReferenceModel(String referenceId, double rankScore, int rank) {
            this.referenceId = referenceId;
            this.rankScore = rankScore;
            this.rank = rank;
        }

        @Generated
        public ReferenceModel() {
        }

        @Generated
        public static class ReferenceModelBuilder {
            @Generated
            private String referenceId;
            @Generated
            private double rankScore;
            @Generated
            private int rank;

            @Generated
            ReferenceModelBuilder() {
            }

            @Generated
            public ReferenceModelBuilder referenceId(String referenceId) {
                this.referenceId = referenceId;
                return this;
            }

            @Generated
            public ReferenceModelBuilder rankScore(double rankScore) {
                this.rankScore = rankScore;
                return this;
            }

            @Generated
            public ReferenceModelBuilder rank(int rank) {
                this.rank = rank;
                return this;
            }

            @Generated
            public ReferenceModel build() {
                return new ReferenceModel(this.referenceId, this.rankScore, this.rank);
            }

            @Generated
            public String toString() {
                return "AnswerModel.ReferenceModel.ReferenceModelBuilder(referenceId=" + this.referenceId + ", rankScore=" + this.rankScore + ", rank=" + this.rank + ")";
            }
        }
    }

    public static class ObjectReferenceModel {
        private String objectId;
        private Set<ReferenceModel> references;

        public static ObjectReferenceModel fromServiceModel(AnswerResponse.ObjectReference reference) {
            Set<ReferenceModel> references = Optional.ofNullable(reference.getReferences()).map(refs -> refs.stream().map(ReferenceModel::fromServiceModel).collect(Collectors.toSet())).orElse(Collections.emptySet());
            return ObjectReferenceModel.builder().objectId(reference.getObjectId()).references(references).build();
        }

        @Generated
        public static ObjectReferenceModelBuilder builder() {
            return new ObjectReferenceModelBuilder();
        }

        @Generated
        public String getObjectId() {
            return this.objectId;
        }

        @Generated
        public Set<ReferenceModel> getReferences() {
            return this.references;
        }

        @Generated
        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        @Generated
        public void setReferences(Set<ReferenceModel> references) {
            this.references = references;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObjectReferenceModel)) {
                return false;
            }
            ObjectReferenceModel other = (ObjectReferenceModel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$objectId = this.getObjectId();
            String other$objectId = other.getObjectId();
            if (this$objectId == null ? other$objectId != null : !this$objectId.equals(other$objectId)) {
                return false;
            }
            Set<ReferenceModel> this$references = this.getReferences();
            Set<ReferenceModel> other$references = other.getReferences();
            return !(this$references == null ? other$references != null : !((Object)this$references).equals(other$references));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ObjectReferenceModel;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $objectId = this.getObjectId();
            result = result * 59 + ($objectId == null ? 43 : $objectId.hashCode());
            Set<ReferenceModel> $references = this.getReferences();
            result = result * 59 + ($references == null ? 43 : ((Object)$references).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AnswerModel.ObjectReferenceModel(objectId=" + this.getObjectId() + ", references=" + String.valueOf(this.getReferences()) + ")";
        }

        @Generated
        public ObjectReferenceModel(String objectId, Set<ReferenceModel> references) {
            this.objectId = objectId;
            this.references = references;
        }

        @Generated
        public ObjectReferenceModel() {
        }

        @Generated
        public static class ObjectReferenceModelBuilder {
            @Generated
            private String objectId;
            @Generated
            private Set<ReferenceModel> references;

            @Generated
            ObjectReferenceModelBuilder() {
            }

            @Generated
            public ObjectReferenceModelBuilder objectId(String objectId) {
                this.objectId = objectId;
                return this;
            }

            @Generated
            public ObjectReferenceModelBuilder references(Set<ReferenceModel> references) {
                this.references = references;
                return this;
            }

            @Generated
            public ObjectReferenceModel build() {
                return new ObjectReferenceModel(this.objectId, this.references);
            }

            @Generated
            public String toString() {
                return "AnswerModel.ObjectReferenceModel.ObjectReferenceModelBuilder(objectId=" + this.objectId + ", references=" + String.valueOf(this.references) + ")";
            }
        }
    }
}

