/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model;

import java.util.Optional;
import lombok.Generated;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.alfresco.hxi_connector.live_ingester.domain.ports.ingestion_engine.UpdateNodeEvent;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.property.ContentPropertyUpdated;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.property.PropertyUpdated;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.property.PropertyResolver;

public abstract class PropertyDelta<T> {
    private final String propertyName;

    public static <T> PropertyUpdated<T> updated(String key, T propertyValue) {
        return new PropertyUpdated(key, propertyValue);
    }

    public static ContentPropertyUpdated contentPropertyUpdated(String key, String id, String mimeType) {
        return ContentPropertyUpdated.builder((String)key).id(id).mimeType(mimeType).build();
    }

    public static ContentPropertyUpdated contentMetadataUpdated(String key, String sourceMimeType, Long sourceSizeInBytes, String sourceFileName) {
        return ContentPropertyUpdated.builder((String)key).sourceMimeType(sourceMimeType).sourceSizeInBytes(sourceSizeInBytes).sourceFileName(sourceFileName).build();
    }

    protected PropertyDelta(String propertyName) {
        EnsureUtils.ensureNonNull((Object)propertyName, (String)"Property key cannot be null", (Object[])new Object[0]);
        this.propertyName = propertyName;
    }

    public boolean canBeResolvedWith(PropertyResolver<?> resolver) {
        return resolver.canResolve(this);
    }

    public abstract void applyOn(UpdateNodeEvent var1);

    public abstract <R> Optional<PropertyDelta<R>> resolveWith(PropertyResolver<R> var1);

    @Generated
    public String getPropertyName() {
        return this.propertyName;
    }

    @Generated
    public String toString() {
        return "PropertyDelta(propertyName=" + this.getPropertyName() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PropertyDelta)) {
            return false;
        }
        PropertyDelta other = (PropertyDelta)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$propertyName = this.getPropertyName();
        String other$propertyName = other.getPropertyName();
        return !(this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PropertyDelta;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $propertyName = this.getPropertyName();
        result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
        return result;
    }
}

