/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.live_ingester.adapters.messaging.repository.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.alfresco.hxi_connector.live_ingester.domain.exception.LiveIngesterRuntimeException;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.EventType;
import org.alfresco.hxi_connector.live_ingester.domain.usecase.metadata.model.PropertyDelta;
import org.alfresco.repo.event.v1.model.ContentInfo;
import org.alfresco.repo.event.v1.model.DataAttributes;
import org.alfresco.repo.event.v1.model.NodeResource;
import org.alfresco.repo.event.v1.model.RepoEvent;

/*
 * Exception performing whole class analysis ignored.
 */
public final class EventUtils {
    public static final String PREDICTION_NODE_TYPE = "hxi:prediction";
    public static final String PREDICTION_APPLIED_ASPECT = "hxi:predictionApplied";
    public static final String PREDICTION_TIME_PROPERTY = "hxi:latestPredictionDateTime";
    public static final String PREDICTION_VALUE_PROPERTY = "hxi:predictionValue";
    public static final String PREDICTION_REVIEW_STATUS_PROPERTY = "hxi:reviewStatus";
    public static final String PREDICTION_UNREVIEWED = "UNREVIEWED";
    public static final String PREDICTION_CONFIRMED = "CONFIRMED";

    public static boolean isEventTypeCreated(RepoEvent<DataAttributes<NodeResource>> event) {
        return org.alfresco.repo.event.v1.model.EventType.NODE_CREATED.getType().equals(event.getType());
    }

    public static boolean isEventTypeUpdated(RepoEvent<DataAttributes<NodeResource>> event) {
        return org.alfresco.repo.event.v1.model.EventType.NODE_UPDATED.getType().equals(event.getType());
    }

    public static boolean isEventTypeDeleted(RepoEvent<DataAttributes<NodeResource>> event) {
        return org.alfresco.repo.event.v1.model.EventType.NODE_DELETED.getType().equals(event.getType());
    }

    public static boolean isEventTypePermissionsUpdated(RepoEvent<DataAttributes<NodeResource>> event) {
        return org.alfresco.repo.event.v1.model.EventType.PERMISSION_UPDATED.getType().equals(event.getType());
    }

    public static EventType getEventType(RepoEvent<DataAttributes<NodeResource>> event) {
        if (EventUtils.isEventTypeCreated(event)) {
            return EventType.CREATE_OR_UPDATE;
        }
        if (EventUtils.isEventTypeUpdated(event) || EventUtils.isEventTypePermissionsUpdated(event)) {
            return EventType.CREATE_OR_UPDATE;
        }
        if (EventUtils.isEventTypeDeleted(event)) {
            return EventType.DELETE;
        }
        throw new LiveIngesterRuntimeException("Unsupported Repo event type " + event.getType());
    }

    public static boolean isPredictionNodeEvent(RepoEvent<DataAttributes<NodeResource>> event) {
        return "hxi:prediction".equals(((NodeResource)event.getData().getResource()).getNodeType());
    }

    public static boolean isPredictionApplyEvent(RepoEvent<DataAttributes<NodeResource>> event) {
        Set aspects = Optional.ofNullable(((NodeResource)event.getData().getResource()).getAspectNames()).orElse(Collections.emptySet());
        if (aspects.contains("hxi:predictionApplied")) {
            String actualPredictionTime = (String)((NodeResource)event.getData().getResource()).getProperties().get("hxi:latestPredictionDateTime");
            Map beforeProperties = Optional.ofNullable((NodeResource)event.getData().getResourceBefore()).map(NodeResource::getProperties).orElse(null);
            if (beforeProperties != null && beforeProperties.containsKey("hxi:latestPredictionDateTime")) {
                String beforePredictionTime = (String)beforeProperties.get("hxi:latestPredictionDateTime");
                return !Objects.equals(actualPredictionTime, beforePredictionTime);
            }
        }
        return false;
    }

    public static boolean wasContentChanged(RepoEvent<DataAttributes<NodeResource>> event) {
        boolean latestContentPresent;
        Optional<ContentInfo> latestContentInfo = Optional.ofNullable((NodeResource)event.getData().getResource()).map(NodeResource::getContent);
        if (latestContentInfo.isEmpty()) {
            return false;
        }
        boolean bl = latestContentPresent = !latestContentInfo.get().getSizeInBytes().equals(0L);
        if (EventUtils.isEventTypeCreated(event)) {
            return latestContentPresent;
        }
        if (EventUtils.isEventTypeUpdated(event)) {
            Optional<ContentInfo> oldContentInfo = Optional.ofNullable((NodeResource)event.getData().getResourceBefore()).map(NodeResource::getContent);
            return oldContentInfo.isPresent() && latestContentPresent;
        }
        return false;
    }

    public static boolean wasPredictionConfirmed(RepoEvent<DataAttributes<NodeResource>> event) {
        Map oldProperties = Optional.ofNullable((NodeResource)event.getData().getResourceBefore()).map(NodeResource::getProperties).orElse(null);
        Map newProperties = ((NodeResource)event.getData().getResource()).getProperties();
        if (oldProperties == null || newProperties == null) {
            return false;
        }
        Serializable previousStatus = (Serializable)oldProperties.get("hxi:reviewStatus");
        Serializable actualStatus = (Serializable)newProperties.get("hxi:reviewStatus");
        return Objects.equals(previousStatus, "UNREVIEWED") && Objects.equals(actualStatus, "CONFIRMED");
    }

    public static String getNodeParent(RepoEvent<DataAttributes<NodeResource>> event) {
        return (String)((NodeResource)event.getData().getResource()).getPrimaryHierarchy().stream().findFirst().orElseThrow(() -> new LiveIngesterRuntimeException("Node %s has no parent".formatted(event.getData().getResource())));
    }

    public static Set<PropertyDelta<?>> getPredictionNodeProperties(RepoEvent<DataAttributes<NodeResource>> event) {
        String predictedPropertyName = ((NodeResource)event.getData().getResource()).getPrimaryAssocQName();
        Serializable predictionValue = (Serializable)((NodeResource)event.getData().getResource()).getProperties().get("hxi:predictionValue");
        return Set.of(PropertyDelta.updated((String)predictedPropertyName, (Object)predictionValue));
    }

    public static long getEventTimestamp(RepoEvent<DataAttributes<NodeResource>> event) {
        return event.getTime().toInstant().toEpochMilli();
    }

    @Generated
    private EventUtils() {
    }
}

