/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.util;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import lombok.Generated;
import org.alfresco.hxi_connector.common.exception.EndpointClientErrorException;
import org.alfresco.hxi_connector.common.exception.EndpointServerErrorException;
import org.alfresco.hxi_connector.common.exception.HxInsightConnectorRuntimeException;
import org.alfresco.hxi_connector.common.exception.ResourceNotFoundException;

public class ErrorUtils {
    public static final String UNEXPECTED_STATUS_CODE_MESSAGE = "Unexpected response status code - expecting: %d, received: %d";

    public static void throwExceptionOnUnexpectedStatusCode(int actualStatusCode, int expectedStatusCode) {
        if (actualStatusCode == 404) {
            throw new ResourceNotFoundException(String.format(UNEXPECTED_STATUS_CODE_MESSAGE, expectedStatusCode, actualStatusCode));
        }
        if (actualStatusCode >= 400 && actualStatusCode <= 499) {
            throw new EndpointClientErrorException(String.format(UNEXPECTED_STATUS_CODE_MESSAGE, expectedStatusCode, actualStatusCode));
        }
        if (actualStatusCode >= 500 && actualStatusCode <= 599) {
            throw new EndpointServerErrorException(String.format(UNEXPECTED_STATUS_CODE_MESSAGE, expectedStatusCode, actualStatusCode));
        }
    }

    public static RuntimeException wrapErrorIfNecessary(Exception cause, Set<Class<? extends Throwable>> retryReasons) {
        return ErrorUtils.wrapError(cause, retryReasons, HxInsightConnectorRuntimeException.class);
    }

    public static void wrapErrorAndThrowIfNecessary(Exception cause, Set<Class<? extends Throwable>> retryReasons, Class<? extends RuntimeException> runtimeExceptionType) {
        throw ErrorUtils.wrapError(cause, retryReasons, runtimeExceptionType);
    }

    private static RuntimeException wrapError(Exception cause, Set<Class<? extends Throwable>> retryReasons, Class<? extends RuntimeException> runtimeExceptionType) {
        if (cause instanceof EndpointServerErrorException) {
            return (EndpointServerErrorException)cause;
        }
        if (retryReasons.contains(cause.getClass())) {
            return new EndpointServerErrorException(cause);
        }
        if (cause instanceof EndpointClientErrorException) {
            return (EndpointClientErrorException)cause;
        }
        if (runtimeExceptionType.isAssignableFrom(cause.getClass())) {
            return runtimeExceptionType.cast(cause);
        }
        try {
            throw runtimeExceptionType.getDeclaredConstructor(Throwable.class).newInstance(cause);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return new HxInsightConnectorRuntimeException(String.format("Cannot create new instance of exception: %s due to: %s while processing another exception:", runtimeExceptionType.getSimpleName(), e.getMessage()), cause);
        }
        catch (RuntimeException e) {
            return e;
        }
    }

    @Generated
    private ErrorUtils() {
    }
}

