/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.test.docker.repository;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.model.PullResponseItem;
import java.util.concurrent.Future;
import lombok.NonNull;
import org.alfresco.hxi_connector.common.test.docker.repository.AlfrescoRepositoryExtension;
import org.alfresco.hxi_connector.common.test.docker.repository.RepositoryType;
import org.alfresco.hxi_connector.common.test.docker.util.DockerTags;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

public class AlfrescoRepositoryContainer
extends GenericContainer<AlfrescoRepositoryContainer> {
    static final String REPOSITORY_TAG = DockerTags.getRepositoryTag();
    private static final int REPO_PORT_DEFAULT = 8080;
    private static final int REPO_DEBUG_PORT_DEFAULT = 8000;

    public AlfrescoRepositoryContainer() {
        this(RepositoryType.COMMUNITY);
    }

    public static void pullRepositoryImage(RepositoryType repositoryType) {
        DockerClient dockerClient = DockerClientFactory.instance().client();
        PullImageResultCallback callback = new PullImageResultCallback(){

            public void onNext(PullResponseItem item) {
                super.onNext(item);
            }
        };
        dockerClient.pullImageCmd(String.valueOf(DockerImageName.parse((String)repositoryType.getImageName()).withTag(REPOSITORY_TAG))).exec((ResultCallback)callback);
    }

    public AlfrescoRepositoryContainer(RepositoryType repositoryType) {
        this(DockerImageName.parse((String)repositoryType.getImageName()).withTag(REPOSITORY_TAG));
    }

    public AlfrescoRepositoryContainer(@NonNull DockerImageName dockerImageName) {
        super(dockerImageName);
        if (dockerImageName == null) {
            throw new NullPointerException("dockerImageName is marked non-null but is null");
        }
    }

    public AlfrescoRepositoryContainer(@NonNull AlfrescoRepositoryExtension repositoryExtension) {
        super((Future)((Object)repositoryExtension));
        if (repositoryExtension == null) {
            throw new NullPointerException("repositoryExtension is marked non-null but is null");
        }
    }

    public int getPort() {
        return this.getMappedPort(8080);
    }

    public String getBaseUrl() {
        return "http://%s:%s".formatted(this.getHost(), this.getPort());
    }

    public AlfrescoRepositoryContainer withCatalinaOpts(String opts) {
        this.withEnv("CATALINA_OPTS", opts);
        return this;
    }

    public AlfrescoRepositoryContainer withJavaToolOpts(String opts) {
        this.withEnv("JAVA_TOOL_OPTIONS", opts);
        return this;
    }

    public AlfrescoRepositoryContainer withJavaOpts(String opts) {
        this.withEnv("JAVA_OPTS", opts);
        return this;
    }

    protected void configure() {
        super.configure();
        this.withCatalinaOpts("-agentlib:jdwp=transport=dt_socket,address=*:%s,server=y,suspend=n".formatted(8000)).withJavaToolOpts("-Dencryption.keystore.type=JCEKS\n-Dencryption.cipherAlgorithm=DESede/CBC/PKCS5Padding\n-Dencryption.keyAlgorithm=DESede\n-Dencryption.keystore.location=/usr/local/tomcat/shared/classes/alfresco/extension/keystore/keystore\n-Dmetadata-keystore.password=mp6yc0UD9e\n-Dmetadata-keystore.aliases=metadata\n-Dmetadata-keystore.metadata.password=oKIWzVdEdA\n-Dmetadata-keystore.metadata.algorithm=DESede\n".replace("\n", " ")).withExposedPorts(new Integer[]{8080, 8000});
    }
}

