/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.auth;

import java.util.Set;
import org.alfresco.hxi_connector.common.adapters.auth.TokenRequest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TokenRequestTest {
    TokenRequestTest() {
    }

    @Test
    void testGetTokenRequestBody_withAllFields() {
        TokenRequest request = TokenRequest.builder().grantType("password").clientId("test-client").clientSecret("test-secret").scope(Set.of("read", "write")).username("testuser").password("testpass").build();
        String body = request.getTokenRequestBody();
        Assertions.assertThat((String)body).contains(new CharSequence[]{"grant_type=password"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"client_id=test-client"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"client_secret=test-secret"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"username=testuser"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"password=testpass"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"scope="});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"read", "write"});
    }

    @Test
    void testGetTokenRequestBody_withRequiredFieldsOnly() {
        TokenRequest request = TokenRequest.builder().grantType("client_credentials").clientId("test-client").build();
        String body = request.getTokenRequestBody();
        Assertions.assertThat((String)body).isEqualTo("grant_type=client_credentials&client_id=test-client");
    }

    @Test
    void testGetTokenRequestBody_urlEncodesSpecialCharacters() {
        TokenRequest request = TokenRequest.builder().grantType("password").clientId("client@test").clientSecret("secret&key=value").username("user name").password("p@ss w0rd!").build();
        String body = request.getTokenRequestBody();
        Assertions.assertThat((String)body).contains(new CharSequence[]{"client_id=client%40test"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"client_secret=secret%26key%3Dvalue"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"username=user+name"});
        Assertions.assertThat((String)body).contains(new CharSequence[]{"password=p%40ss+w0rd%21"});
    }

    @Test
    void testGetTokenRequestBody_withBlankClientSecret() {
        TokenRequest request = TokenRequest.builder().grantType("client_credentials").clientId("test-client").clientSecret("   ").build();
        String body = request.getTokenRequestBody();
        Assertions.assertThat((String)body).doesNotContain(new CharSequence[]{"client_secret"});
    }

    @Test
    void testGetTokenRequestBody_withEmptyScope() {
        TokenRequest request = TokenRequest.builder().grantType("client_credentials").clientId("test-client").scope(Set.of()).build();
        String body = request.getTokenRequestBody();
        Assertions.assertThat((String)body).doesNotContain(new CharSequence[]{"scope"});
    }

    @Test
    void testGetTokenRequestBody_scopesAreSeparatedBySpace() {
        TokenRequest request = TokenRequest.builder().grantType("client_credentials").clientId("test-client").scope(Set.of("openid", "evolution")).build();
        String body = request.getTokenRequestBody();
        Assertions.assertThat((String)body).containsPattern((CharSequence)"scope=(openid\\+evolution|evolution\\+openid)");
    }
}

