/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Set;
import lombok.Generated;
import org.alfresco.hxi_connector.common.adapters.auth.AuthenticationClient;
import org.alfresco.hxi_connector.common.adapters.auth.AuthenticationResult;
import org.alfresco.hxi_connector.common.adapters.auth.TokenRequest;
import org.alfresco.hxi_connector.common.adapters.auth.config.properties.AuthProperties;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.alfresco.hxi_connector.common.util.ErrorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthenticationClient
implements AuthenticationClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAuthenticationClient.class);
    public static final String AUTH_ERROR_LOG_MESSAGE = "Authentication :: failed to authenticate with authorization provider: {}. Response body: {}";
    public static final int EXPECTED_STATUS_CODE = 200;
    protected final AuthProperties authProperties;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final HttpClient client = HttpClient.newHttpClient();

    @Override
    public AuthenticationResult authenticate(String providerId) {
        AuthProperties.AuthProvider authProvider = this.authProperties.getProviders().get(providerId);
        EnsureUtils.ensureNonNull((Object)authProvider, (String)("Auth Provider not found for authorization provider id: " + providerId), (Object[])new Object[0]);
        log.atDebug().log("Authentication :: sending token request for {} authorization provider", (Object)providerId);
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(authProvider.getTokenUri())).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(this.createEncodedBody(authProvider))).build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            if (DefaultAuthenticationClient.isErrorCode(response.statusCode())) {
                log.error(AUTH_ERROR_LOG_MESSAGE, (Object)providerId, (Object)response.body());
            }
            ErrorUtils.throwExceptionOnUnexpectedStatusCode((int)response.statusCode(), (int)200);
            return (AuthenticationResult)this.objectMapper.readValue(response.body(), AuthenticationResult.class);
        }
        catch (Exception e) {
            Set retryReasons = this.authProperties.getRetry().reasons();
            throw ErrorUtils.wrapErrorIfNecessary((Exception)e, (Set)retryReasons);
        }
    }

    private String createEncodedBody(AuthProperties.AuthProvider authProvider) {
        return TokenRequest.builder().clientId(authProvider.getClientId()).grantType(authProvider.getGrantType()).clientSecret(authProvider.getClientSecret()).scope(authProvider.getScope()).username(authProvider.getUsername()).password(authProvider.getPassword()).build().getTokenRequestBody();
    }

    private static boolean isErrorCode(int statusCode) {
        return statusCode >= 400 && statusCode <= 599;
    }

    @Generated
    public DefaultAuthenticationClient(AuthProperties authProperties) {
        this.authProperties = authProperties;
    }
}

