/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hxi_connector.common.adapters.auth;

import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.alfresco.hxi_connector.common.adapters.auth.AccessTokenProvider;
import org.alfresco.hxi_connector.common.adapters.auth.AuthenticationClient;
import org.alfresco.hxi_connector.common.adapters.auth.AuthenticationResult;
import org.alfresco.hxi_connector.common.util.EnsureUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAccessTokenProvider
implements AccessTokenProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultAccessTokenProvider.class);
    static final int REFRESH_OFFSET_SECS = 60;
    private final AuthenticationClient authenticationClient;
    private final Map<String, Token> accessTokens = new HashMap<String, Token>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken(String providerId) {
        Token token = this.accessTokens.get(providerId);
        DefaultAccessTokenProvider defaultAccessTokenProvider = this;
        synchronized (defaultAccessTokenProvider) {
            if (DefaultAccessTokenProvider.shouldRefreshToken(token)) {
                this.refreshAuthenticationResult(providerId);
                token = this.accessTokens.get(providerId);
            }
        }
        EnsureUtils.ensureNonNull((Object)token, (String)"Authentication result is null", (Object[])new Object[0]);
        return token.getAccessToken();
    }

    private void refreshAuthenticationResult(String providerId) {
        log.atDebug().log("Refreshing authentication result for provider {}", (Object)providerId);
        AuthenticationResult authenticationResult = this.authenticationClient.authenticate(providerId);
        this.accessTokens.put(providerId, new Token(authenticationResult.getAccessToken(), OffsetDateTime.now().plus(authenticationResult.getExpiresIn(), authenticationResult.getTemporalUnit()).minusSeconds(60L)));
    }

    private static boolean shouldRefreshToken(Token token) {
        return token == null || OffsetDateTime.now().isAfter(token.getRefreshAt());
    }

    @Generated
    public DefaultAccessTokenProvider(AuthenticationClient authenticationClient) {
        this.authenticationClient = authenticationClient;
    }

    public static final class Token {
        private final String accessToken;
        private final OffsetDateTime refreshAt;

        @Generated
        public Token(String accessToken, OffsetDateTime refreshAt) {
            this.accessToken = accessToken;
            this.refreshAt = refreshAt;
        }

        @Generated
        public String getAccessToken() {
            return this.accessToken;
        }

        @Generated
        public OffsetDateTime getRefreshAt() {
            return this.refreshAt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Token)) {
                return false;
            }
            Token other = (Token)o;
            String this$accessToken = this.getAccessToken();
            String other$accessToken = other.getAccessToken();
            if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
                return false;
            }
            OffsetDateTime this$refreshAt = this.getRefreshAt();
            OffsetDateTime other$refreshAt = other.getRefreshAt();
            return !(this$refreshAt == null ? other$refreshAt != null : !((Object)this$refreshAt).equals(other$refreshAt));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $accessToken = this.getAccessToken();
            result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
            OffsetDateTime $refreshAt = this.getRefreshAt();
            result = result * 59 + ($refreshAt == null ? 43 : ((Object)$refreshAt).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "DefaultAccessTokenProvider.Token(accessToken=" + this.getAccessToken() + ", refreshAt=" + String.valueOf(this.getRefreshAt()) + ")";
        }
    }
}

