/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm_share.forms;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.web.config.forms.ServiceBasedEvaluator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.surf.exception.ConnectorServiceException;
import org.springframework.extensions.surf.util.URLEncoder;

public class KindEvaluator
extends ServiceBasedEvaluator {
    private static final String JSON_KIND = "kind";
    private static Log logger = LogFactory.getLog(KindEvaluator.class);
    protected static final Pattern NODE_REF_PATTERN = Pattern.compile(".+://.+/.+");

    public boolean applies(Object obj, String condition) {
        boolean result;
        block13: {
            String objAsString;
            result = false;
            if (obj instanceof String && ((objAsString = (String)obj).indexOf(58) != -1 || objAsString.startsWith("{"))) {
                Matcher m = NODE_REF_PATTERN.matcher(objAsString);
                if (m.matches()) {
                    try {
                        String jsonResponseString = this.callService("/api/rmmetadata?noderef=" + objAsString);
                        if (jsonResponseString != null) {
                            result = this.checkJsonAgainstCondition(condition, jsonResponseString);
                        } else if (this.getLogger().isWarnEnabled()) {
                            this.getLogger().warn((Object)"RM metadata service response appears to be null!");
                        }
                        break block13;
                    }
                    catch (ConnectorServiceException e) {
                        if (this.getLogger().isWarnEnabled()) {
                            this.getLogger().warn((Object)"Failed to connect to RM metadata service.", (Throwable)e);
                        }
                        break block13;
                    }
                }
                try {
                    String jsonResponseString = this.callService("/api/rmmetadata?type=" + URLEncoder.encodeUriComponent((String)objAsString));
                    if (jsonResponseString != null) {
                        result = this.checkJsonAgainstCondition(condition, jsonResponseString);
                    } else if (this.getLogger().isWarnEnabled()) {
                        this.getLogger().warn((Object)"RM metadata service response appears to be null!");
                    }
                }
                catch (ConnectorServiceException e) {
                    if (!this.getLogger().isWarnEnabled()) break block13;
                    this.getLogger().warn((Object)"Failed to connect to RM metadata service.", (Throwable)e);
                }
            }
        }
        return result;
    }

    protected boolean checkJsonAgainstCondition(String condition, String jsonResponseString) {
        boolean result;
        block2: {
            result = false;
            try {
                JSONObject json = new JSONObject(new JSONTokener(jsonResponseString));
                String kind = json.getString(JSON_KIND);
                result = condition.equals(kind);
            }
            catch (JSONException e) {
                if (!this.getLogger().isWarnEnabled()) break block2;
                this.getLogger().warn((Object)("Failed to find RM kind in JSON response from metadata service: " + e.getMessage()));
            }
        }
        return result;
    }

    protected Log getLogger() {
        return logger;
    }
}

