/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm_share.evaluator;

import java.util.HashMap;
import org.alfresco.module.org_alfresco_module_rm_share.evaluator.IncompleteEventEvaluator;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class IncompleteEventEvaluatorUnitTest {
    @Mock
    private JSONObject jsonObject;
    @Mock
    private JSONObject node;
    @Mock
    private HashMap rmNode;
    @Mock
    private HashMap properties;
    private IncompleteEventEvaluator incompleteEventEvaluator;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.incompleteEventEvaluator = new IncompleteEventEvaluator();
        Mockito.when((Object)this.jsonObject.get((Object)"node")).thenReturn((Object)this.node);
        Mockito.when((Object)this.node.get((Object)"rmNode")).thenReturn((Object)this.rmNode);
        Mockito.when(this.rmNode.get("properties")).thenReturn((Object)this.properties);
    }

    @Test
    public void testEvaluateReturnsTrueWhenCombineOptionNotSelected() {
        Assert.assertTrue((boolean)this.incompleteEventEvaluator.evaluate(this.jsonObject));
    }

    @Test
    public void testEvaluateReturnsTrueWhenCombineOptionSetToFalse() {
        Mockito.when(this.properties.get("combineDispositionStepConditions")).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.incompleteEventEvaluator.evaluate(this.jsonObject));
    }

    @Test
    public void testEvaluateReturnsTrueWhenCombineSelectedAndNoIncompleteEvents() {
        Mockito.when(this.properties.get("combineDispositionStepConditions")).thenReturn((Object)true);
        Mockito.when((Object)this.properties.containsKey("incompleteDispositionEvent")).thenReturn((Object)false);
        Assert.assertTrue((boolean)this.incompleteEventEvaluator.evaluate(this.jsonObject));
    }

    @Test
    public void testEvaluateReturnsFalseWhenCombineSelectedAndIncompleteEventPresent() {
        Mockito.when(this.properties.get("combineDispositionStepConditions")).thenReturn((Object)true);
        Mockito.when((Object)this.properties.containsKey("incompleteDispositionEvent")).thenReturn((Object)true);
        Mockito.when(this.properties.get("dispositionEventCombination")).thenReturn((Object)"and");
        Assert.assertFalse((boolean)this.incompleteEventEvaluator.evaluate(this.jsonObject));
    }

    @Test
    public void testEvaluateReturnsTrueWhenCombineSelectedIsNull() {
        Mockito.when(this.properties.get("combineDispositionStepConditions")).thenReturn(null);
        Assert.assertTrue((boolean)this.incompleteEventEvaluator.evaluate(this.jsonObject));
    }
}

