/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.bulk.hold;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.bulk.BulkCancellationRequest;
import org.alfresco.module.org_alfresco_module_rm.bulk.BulkOperation;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkMonitor;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkServiceImpl;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkStatus;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.rest.api.search.model.Query;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.awaitility.Awaitility;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.extensions.webscripts.GUID;

public class HoldBulkServiceTest
extends BaseRMTestCase {
    private static final int RECORD_COUNT = 10;
    private final SearchService searchServiceMock = (SearchService)Mockito.mock(SearchService.class);
    private final ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
    private HoldBulkServiceImpl holdBulkService;
    private HoldBulkMonitor holdBulkMonitor;

    @Override
    protected void initServices() {
        super.initServices();
        this.holdBulkMonitor = (HoldBulkMonitor)this.applicationContext.getBean("holdBulkMonitor");
        this.holdBulkService = (HoldBulkServiceImpl)this.applicationContext.getBean("holdBulkService");
        this.holdBulkService.setSearchService(this.searchServiceMock);
        Mockito.when((Object)this.searchServiceMock.query((SearchParameters)ArgumentMatchers.any(SearchParameters.class))).thenReturn((Object)this.resultSet);
    }

    public void testCancelBulkOperation() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef hold;
            private HoldBulkStatus holdBulkStatus;
            private final ResultSet resultSet;
            {
                this.resultSet = (ResultSet)Mockito.mock(ResultSet.class);
            }

            @Override
            public void given() {
                Mockito.when((Object)this.resultSet.getNumberFound()).thenReturn((Object)4L);
                Mockito.when((Object)this.resultSet.hasMore()).thenReturn((Object)false).thenReturn((Object)true).thenReturn((Object)false);
                Mockito.when((Object)this.resultSet.getNodeRefs()).thenAnswer(invocationOnMock -> {
                    Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).until(() -> true);
                    return List.of(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate()), new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, GUID.generate()));
                });
                this.hold = HoldBulkServiceTest.this.holdService.createHold(HoldBulkServiceTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
            }

            @Override
            public void when() {
                BulkOperation bulkOperation = new BulkOperation(new Query("afts", "*", ""), "ADD");
                this.holdBulkStatus = (HoldBulkStatus)HoldBulkServiceTest.this.holdBulkService.execute(this.hold, bulkOperation);
                HoldBulkServiceTest.this.holdBulkMonitor.cancelBulkOperation(this.holdBulkStatus.bulkStatusId(), new BulkCancellationRequest("No reason"));
                Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> Objects.equals(((HoldBulkStatus)HoldBulkServiceTest.this.holdBulkMonitor.getBulkStatus(this.holdBulkStatus.bulkStatusId())).getStatus(), HoldBulkStatus.Status.CANCELLED.getValue()));
            }

            @Override
            public void then() {
                this.holdBulkStatus = (HoldBulkStatus)HoldBulkServiceTest.this.holdBulkMonitor.getBulkStatus(this.holdBulkStatus.bulkStatusId());
                TestCase.assertNotNull((Object)this.holdBulkStatus.startTime());
                TestCase.assertNotNull((Object)this.holdBulkStatus.endTime());
                TestCase.assertEquals((String)((HoldBulkStatus)HoldBulkServiceTest.this.holdBulkMonitor.getBulkStatus(this.holdBulkStatus.bulkStatusId())).getStatus(), (String)HoldBulkStatus.Status.CANCELLED.getValue());
                TestCase.assertEquals((String)((HoldBulkStatus)HoldBulkServiceTest.this.holdBulkMonitor.getBulkStatus(this.holdBulkStatus.bulkStatusId())).cancellationReason(), (String)"No reason");
            }
        });
    }

    public void testAddRecordsToHoldViaBulk() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef hold;
            private NodeRef recordFolder;
            private HoldBulkStatus holdBulkStatus;
            private final List<NodeRef> records;
            {
                this.records = new ArrayList<NodeRef>(10);
            }

            @Override
            public void given() {
                Mockito.when((Object)HoldBulkServiceTest.this.resultSet.getNumberFound()).thenReturn((Object)10L);
                Mockito.when((Object)HoldBulkServiceTest.this.resultSet.hasMore()).thenReturn((Object)false).thenReturn((Object)false);
                this.hold = HoldBulkServiceTest.this.holdService.createHold(HoldBulkServiceTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                NodeRef recordCategory = HoldBulkServiceTest.this.filePlanService.createRecordCategory(HoldBulkServiceTest.this.filePlan, GUID.generate());
                this.recordFolder = HoldBulkServiceTest.this.recordFolderService.createRecordFolder(recordCategory, GUID.generate());
                for (int i = 0; i < 10; ++i) {
                    this.records.add(HoldBulkServiceTest.this.recordService.createRecordFromContent(this.recordFolder, GUID.generate(), ContentModel.TYPE_CONTENT, null, null));
                }
                Mockito.when((Object)HoldBulkServiceTest.this.resultSet.getNodeRefs()).thenReturn(this.records).thenReturn(this.records).thenReturn(Collections.emptyList());
                TestCase.assertFalse((boolean)HoldBulkServiceTest.this.freezeService.isFrozen(this.recordFolder));
                TestCase.assertFalse((boolean)HoldBulkServiceTest.this.freezeService.hasFrozenChildren(this.recordFolder));
                for (NodeRef record : this.records) {
                    TestCase.assertFalse((boolean)HoldBulkServiceTest.this.freezeService.isFrozen(record));
                }
                TestCase.assertTrue((boolean)HoldBulkServiceTest.this.nodeService.hasAspect(this.recordFolder, RecordsManagementModel.ASPECT_HELD_CHILDREN));
                TestCase.assertEquals((Object)0, (Object)HoldBulkServiceTest.this.nodeService.getProperty(this.recordFolder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT));
            }

            @Override
            public void when() {
                BulkOperation bulkOperation = new BulkOperation(new Query("afts", "*", ""), "ADD");
                this.holdBulkStatus = (HoldBulkStatus)HoldBulkServiceTest.this.holdBulkService.execute(this.hold, bulkOperation);
                Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> Objects.equals(((HoldBulkStatus)HoldBulkServiceTest.this.holdBulkMonitor.getBulkStatus(this.holdBulkStatus.bulkStatusId())).getStatus(), HoldBulkStatus.Status.DONE.getValue()));
            }

            @Override
            public void then() {
                this.holdBulkStatus = (HoldBulkStatus)HoldBulkServiceTest.this.holdBulkMonitor.getBulkStatus(this.holdBulkStatus.bulkStatusId());
                TestCase.assertNotNull((Object)this.holdBulkStatus.startTime());
                TestCase.assertNotNull((Object)this.holdBulkStatus.endTime());
                TestCase.assertEquals((long)10L, (long)this.holdBulkStatus.totalItems());
                TestCase.assertEquals((long)10L, (long)this.holdBulkStatus.processedItems());
                TestCase.assertEquals((long)0L, (long)this.holdBulkStatus.errorsCount());
                TestCase.assertEquals((String)((HoldBulkStatus)HoldBulkServiceTest.this.holdBulkMonitor.getBulkStatus(this.holdBulkStatus.bulkStatusId())).getStatus(), (String)HoldBulkStatus.Status.DONE.getValue());
                for (NodeRef record : this.records) {
                    TestCase.assertTrue((boolean)HoldBulkServiceTest.this.freezeService.isFrozen(record));
                }
                TestCase.assertFalse((boolean)HoldBulkServiceTest.this.freezeService.isFrozen(this.recordFolder));
                TestCase.assertTrue((boolean)HoldBulkServiceTest.this.freezeService.hasFrozenChildren(this.recordFolder));
                TestCase.assertFalse((boolean)HoldBulkServiceTest.this.holdService.getHeld(this.hold).contains(this.recordFolder));
                TestCase.assertFalse((boolean)HoldBulkServiceTest.this.holdService.heldBy(this.recordFolder, true).contains(this.hold));
                for (NodeRef record : this.records) {
                    TestCase.assertTrue((boolean)HoldBulkServiceTest.this.holdService.getHeld(this.hold).contains(record));
                    TestCase.assertTrue((boolean)HoldBulkServiceTest.this.holdService.heldBy(record, true).contains(this.hold));
                }
                TestCase.assertTrue((boolean)HoldBulkServiceTest.this.nodeService.hasAspect(this.recordFolder, RecordsManagementModel.ASPECT_HELD_CHILDREN));
                TestCase.assertEquals((Object)10, (Object)HoldBulkServiceTest.this.nodeService.getProperty(this.recordFolder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT));
            }
        });
    }

    public void testAddRecordFolderToHoldViaBulk() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private NodeRef hold;
            private NodeRef recordFolder;
            private final List<NodeRef> records;
            private HoldBulkStatus holdBulkStatus;
            {
                this.records = new ArrayList<NodeRef>(10);
            }

            @Override
            public void given() {
                Mockito.when((Object)HoldBulkServiceTest.this.resultSet.getNumberFound()).thenReturn((Object)1L);
                Mockito.when((Object)HoldBulkServiceTest.this.resultSet.hasMore()).thenReturn((Object)false).thenReturn((Object)false);
                this.hold = HoldBulkServiceTest.this.holdService.createHold(HoldBulkServiceTest.this.filePlan, GUID.generate(), GUID.generate(), GUID.generate());
                NodeRef recordCategory = HoldBulkServiceTest.this.filePlanService.createRecordCategory(HoldBulkServiceTest.this.filePlan, GUID.generate());
                this.recordFolder = HoldBulkServiceTest.this.recordFolderService.createRecordFolder(recordCategory, GUID.generate());
                for (int i = 0; i < 10; ++i) {
                    this.records.add(HoldBulkServiceTest.this.recordService.createRecordFromContent(this.recordFolder, GUID.generate(), ContentModel.TYPE_CONTENT, null, null));
                }
                Mockito.when((Object)HoldBulkServiceTest.this.resultSet.getNodeRefs()).thenReturn(Collections.singletonList(this.recordFolder)).thenReturn(Collections.singletonList(this.recordFolder)).thenReturn(Collections.emptyList());
                TestCase.assertFalse((boolean)HoldBulkServiceTest.this.freezeService.isFrozen(this.recordFolder));
                TestCase.assertFalse((boolean)HoldBulkServiceTest.this.freezeService.hasFrozenChildren(this.recordFolder));
                for (NodeRef record : this.records) {
                    TestCase.assertFalse((boolean)HoldBulkServiceTest.this.freezeService.isFrozen(record));
                }
                TestCase.assertTrue((boolean)HoldBulkServiceTest.this.nodeService.hasAspect(this.recordFolder, RecordsManagementModel.ASPECT_HELD_CHILDREN));
                TestCase.assertEquals((Object)0, (Object)HoldBulkServiceTest.this.nodeService.getProperty(this.recordFolder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT));
            }

            @Override
            public void when() {
                BulkOperation bulkOperation = new BulkOperation(new Query("afts", "*", ""), "ADD");
                this.holdBulkStatus = (HoldBulkStatus)HoldBulkServiceTest.this.holdBulkService.execute(this.hold, bulkOperation);
                Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> Objects.equals(((HoldBulkStatus)HoldBulkServiceTest.this.holdBulkMonitor.getBulkStatus(this.holdBulkStatus.bulkStatusId())).getStatus(), HoldBulkStatus.Status.DONE.getValue()));
            }

            @Override
            public void then() {
                this.holdBulkStatus = (HoldBulkStatus)HoldBulkServiceTest.this.holdBulkMonitor.getBulkStatus(this.holdBulkStatus.bulkStatusId());
                TestCase.assertNotNull((Object)this.holdBulkStatus.startTime());
                TestCase.assertNotNull((Object)this.holdBulkStatus.endTime());
                TestCase.assertEquals((long)1L, (long)this.holdBulkStatus.totalItems());
                TestCase.assertEquals((long)1L, (long)this.holdBulkStatus.processedItems());
                TestCase.assertEquals((long)0L, (long)this.holdBulkStatus.errorsCount());
                TestCase.assertEquals((String)((HoldBulkStatus)HoldBulkServiceTest.this.holdBulkMonitor.getBulkStatus(this.holdBulkStatus.bulkStatusId())).getStatus(), (String)HoldBulkStatus.Status.DONE.getValue());
                for (NodeRef record : this.records) {
                    TestCase.assertTrue((boolean)HoldBulkServiceTest.this.freezeService.isFrozen(record));
                    TestCase.assertFalse((boolean)HoldBulkServiceTest.this.holdService.getHeld(this.hold).contains(record));
                    TestCase.assertTrue((boolean)HoldBulkServiceTest.this.holdService.heldBy(record, true).contains(this.hold));
                }
                TestCase.assertTrue((boolean)HoldBulkServiceTest.this.freezeService.isFrozen(this.recordFolder));
                TestCase.assertTrue((boolean)HoldBulkServiceTest.this.freezeService.hasFrozenChildren(this.recordFolder));
                TestCase.assertTrue((boolean)HoldBulkServiceTest.this.holdService.getHeld(this.hold).contains(this.recordFolder));
                TestCase.assertTrue((boolean)HoldBulkServiceTest.this.holdService.heldBy(this.recordFolder, true).contains(this.hold));
                TestCase.assertTrue((boolean)HoldBulkServiceTest.this.nodeService.hasAspect(this.recordFolder, RecordsManagementModel.ASPECT_HELD_CHILDREN));
                TestCase.assertEquals((Object)10, (Object)HoldBulkServiceTest.this.nodeService.getProperty(this.recordFolder, RecordsManagementModel.PROP_HELD_CHILDREN_COUNT));
            }
        });
    }
}

