/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.util;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.AuthenticationUtil;
import org.alfresco.module.org_alfresco_module_rm.util.NodeTypeUtility;
import org.alfresco.module.org_alfresco_module_rm.util.TransactionalResourceHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyMap;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ServiceBaseImpl
implements RecordsManagementModel,
ApplicationContextAware {
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected RenditionService renditionService;
    protected ApplicationContext applicationContext;
    private NodeService internalNodeService;
    protected AuthenticationUtil authenticationUtil;
    protected TransactionalResourceHelper transactionalResourceHelper;
    protected ContentService contentService;
    protected NodeTypeUtility nodeTypeUtility;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRenditionService(RenditionService service) {
        this.renditionService = service;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setAuthenticationUtil(AuthenticationUtil authenticationUtil) {
        this.authenticationUtil = authenticationUtil;
    }

    public void setNodeTypeUtility(NodeTypeUtility nodeTypeUtility) {
        this.nodeTypeUtility = nodeTypeUtility;
    }

    public void setTransactionalResourceHelper(TransactionalResourceHelper transactionalResourceHelper) {
        this.transactionalResourceHelper = transactionalResourceHelper;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    protected NodeService getInternalNodeService() {
        if (this.internalNodeService == null) {
            this.internalNodeService = (NodeService)this.applicationContext.getBean("dbNodeService");
        }
        return this.internalNodeService;
    }

    public FilePlanComponentKind getFilePlanComponentKind(NodeRef nodeRef) {
        FilePlanComponentKind result = null;
        Map<NodeRef, FilePlanComponentKind> map = this.transactionalResourceHelper.getMap("rm.transaction.filePlanComponentByNodeRef");
        if (map.containsKey(nodeRef)) {
            result = (FilePlanComponentKind)((Object)map.get(nodeRef));
        } else {
            if (this.isFilePlanComponent(nodeRef)) {
                result = FilePlanComponentKind.FILE_PLAN_COMPONENT;
                if (this.isFilePlan(nodeRef)) {
                    result = FilePlanComponentKind.FILE_PLAN;
                } else if (this.isRecordCategory(nodeRef)) {
                    result = FilePlanComponentKind.RECORD_CATEGORY;
                } else if (this.isRecordFolder(nodeRef)) {
                    result = FilePlanComponentKind.RECORD_FOLDER;
                } else if (this.isRecord(nodeRef)) {
                    result = FilePlanComponentKind.RECORD;
                } else if (this.instanceOf(nodeRef, TYPE_HOLD_CONTAINER)) {
                    result = FilePlanComponentKind.HOLD_CONTAINER;
                } else if (this.isHold(nodeRef)) {
                    result = FilePlanComponentKind.HOLD;
                } else if (this.instanceOf(nodeRef, TYPE_TRANSFER_CONTAINER)) {
                    result = FilePlanComponentKind.TRANSFER_CONTAINER;
                } else if (this.isTransfer(nodeRef)) {
                    result = FilePlanComponentKind.TRANSFER;
                } else if (this.instanceOf(nodeRef, TYPE_DISPOSITION_SCHEDULE) || this.instanceOf(nodeRef, TYPE_DISPOSITION_ACTION_DEFINITION)) {
                    result = FilePlanComponentKind.DISPOSITION_SCHEDULE;
                } else if (this.instanceOf(nodeRef, TYPE_UNFILED_RECORD_CONTAINER)) {
                    result = FilePlanComponentKind.UNFILED_RECORD_CONTAINER;
                } else if (this.instanceOf(nodeRef, TYPE_UNFILED_RECORD_FOLDER)) {
                    result = FilePlanComponentKind.UNFILED_RECORD_FOLDER;
                }
            }
            if (result != null) {
                map.put(nodeRef, result);
            }
        }
        return result;
    }

    public FilePlanComponentKind getFilePlanComponentKindFromType(QName type) {
        FilePlanComponentKind result = null;
        if (ASPECT_FILE_PLAN_COMPONENT.equals((Object)type)) {
            result = FilePlanComponentKind.FILE_PLAN_COMPONENT;
        } else if (this.instanceOf(type, ASPECT_RECORD)) {
            result = FilePlanComponentKind.RECORD;
        } else if (this.instanceOf(type, TYPE_FILE_PLAN)) {
            result = FilePlanComponentKind.FILE_PLAN;
        } else if (this.instanceOf(type, TYPE_RECORD_CATEGORY)) {
            result = FilePlanComponentKind.RECORD_CATEGORY;
        } else if (this.instanceOf(type, TYPE_RECORD_FOLDER)) {
            result = FilePlanComponentKind.RECORD_FOLDER;
        } else if (this.instanceOf(type, TYPE_HOLD)) {
            result = FilePlanComponentKind.HOLD;
        } else if (this.instanceOf(type, TYPE_TRANSFER)) {
            result = FilePlanComponentKind.TRANSFER;
        } else if (this.instanceOf(type, TYPE_DISPOSITION_SCHEDULE) || this.instanceOf(type, TYPE_DISPOSITION_ACTION_DEFINITION)) {
            result = FilePlanComponentKind.DISPOSITION_SCHEDULE;
        }
        return result;
    }

    public boolean isFilePlanComponent(NodeRef nodeRef) {
        boolean result = false;
        if (this.getInternalNodeService().exists(nodeRef) && this.getInternalNodeService().hasAspect(nodeRef, ASPECT_FILE_PLAN_COMPONENT)) {
            result = true;
        }
        return result;
    }

    public boolean isFilePlan(NodeRef nodeRef) {
        return this.instanceOf(nodeRef, TYPE_FILE_PLAN);
    }

    public boolean isFilePlanContainer(NodeRef nodeRef) {
        return this.instanceOf(nodeRef, TYPE_RECORDS_MANAGEMENT_CONTAINER);
    }

    public boolean isRecordCategory(NodeRef nodeRef) {
        return this.instanceOf(nodeRef, TYPE_RECORD_CATEGORY);
    }

    public boolean isRecordFolder(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        return this.instanceOf(nodeRef, TYPE_RECORD_FOLDER);
    }

    public boolean isRecord(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        return this.getInternalNodeService().hasAspect(nodeRef, ASPECT_RECORD);
    }

    public boolean isHold(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        boolean isHold = false;
        if (this.getInternalNodeService().exists(nodeRef) && this.instanceOf(nodeRef, TYPE_HOLD)) {
            isHold = true;
        }
        return isHold;
    }

    public boolean isTransfer(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        return this.instanceOf(nodeRef, TYPE_TRANSFER);
    }

    public boolean isUnfiledRecordsContainer(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        return this.instanceOf(nodeRef, TYPE_UNFILED_RECORD_CONTAINER);
    }

    public boolean isDeclared(NodeRef record) {
        ParameterCheck.mandatory((String)"record", (Object)record);
        return this.getInternalNodeService().hasAspect(record, ASPECT_DECLARED_RECORD);
    }

    public NodeRef getFilePlan(NodeRef nodeRef) {
        NodeRef result = null;
        if (nodeRef != null) {
            Map<NodeRef, NodeRef> transactionCache = this.transactionalResourceHelper.getMap("rm.servicebase.getFilePlan");
            if (transactionCache.containsKey(nodeRef)) {
                result = (NodeRef)transactionCache.get(nodeRef);
            } else {
                result = (NodeRef)this.getInternalNodeService().getProperty(nodeRef, PROP_ROOT_NODEREF);
                if (result == null || !this.instanceOf(result, TYPE_FILE_PLAN)) {
                    if (this.instanceOf(nodeRef, TYPE_FILE_PLAN)) {
                        result = nodeRef;
                    } else {
                        ChildAssociationRef parentAssocRef = this.getInternalNodeService().getPrimaryParent(nodeRef);
                        if (parentAssocRef != null) {
                            result = this.getFilePlan(parentAssocRef.getParentRef());
                        }
                    }
                }
                if (result != null) {
                    transactionCache.put(nodeRef, result);
                }
            }
        }
        return result;
    }

    protected boolean instanceOf(NodeRef nodeRef, QName ofClassName) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"ofClassName", (Object)ofClassName);
        QName className = this.getInternalNodeService().getType(nodeRef);
        return this.instanceOf(className, ofClassName);
    }

    protected boolean instanceOf(QName className, QName ofClassName) {
        return this.nodeTypeUtility.instanceOf(className, ofClassName);
    }

    protected int getNextCount(NodeRef nodeRef) {
        int counter = 0;
        if (!this.nodeService.hasAspect(nodeRef, ASPECT_COUNTABLE)) {
            PropertyMap props = new PropertyMap(1);
            props.put((Object)PROP_COUNT, (Object)1);
            this.nodeService.addAspect(nodeRef, ASPECT_COUNTABLE, (Map)props);
            counter = 1;
        } else {
            Integer value = (Integer)this.nodeService.getProperty(nodeRef, PROP_COUNT);
            counter = value != null ? value + 1 : 1;
            this.nodeService.setProperty(nodeRef, PROP_COUNT, (Serializable)Integer.valueOf(counter));
        }
        return counter;
    }

    protected Set<QName> getTypeAndApsects(NodeRef nodeRef) {
        Set result = this.nodeService.getAspects(nodeRef);
        result.add(this.nodeService.getType(nodeRef));
        return result;
    }
}

