/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.type;

import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.extensions.surf.util.I18NUtil;

@BehaviourBean(defaultType="rma:transferContainer")
public class TransferContainerType
extends BaseBehaviourBean
implements NodeServicePolicies.OnCreateChildAssociationPolicy,
NodeServicePolicies.OnCreateNodePolicy,
NodeServicePolicies.OnDeleteNodePolicy {
    private static final String MSG_ERROR_ADD_CONTENT_CONTAINER = "rm.service.error-add-content-container";
    private static final String MSG_ERROR_ADD_CHILD_TO_TRANSFER_CONTAINER = "rm.action.create.transfer.container.child-error-message";
    private static final String BEHAVIOUR_NAME = "onCreateChildAssocsForTransferContainer";
    private static final String DELETE_BEHAVIOUR_NAME = "onDeleteTransferContainer";

    public void disable() {
        this.getBehaviour(BEHAVIOUR_NAME).disable();
        this.getBehaviour(DELETE_BEHAVIOUR_NAME).disable();
    }

    public void enable() {
        this.getBehaviour(BEHAVIOUR_NAME).enable();
        this.getBehaviour(DELETE_BEHAVIOUR_NAME).enable();
    }

    @Behaviour(kind=BehaviourKind.ASSOCIATION, name="onCreateChildAssocsForTransferContainer")
    public void onCreateChildAssociation(ChildAssociationRef childAssocRef, boolean bNew) {
        throw new IntegrityException(I18NUtil.getMessage((String)MSG_ERROR_ADD_CHILD_TO_TRANSFER_CONTAINER), null);
    }

    public void onCreateNode(ChildAssociationRef childAssocRef) {
        NodeRef nodeRef = childAssocRef.getChildRef();
        if (this.instanceOf(nodeRef, ContentModel.TYPE_CONTENT)) {
            throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_ERROR_ADD_CONTENT_CONTAINER));
        }
    }

    @Behaviour(kind=BehaviourKind.CLASS, name="onDeleteTransferContainer")
    public void onDeleteNode(ChildAssociationRef childAssocRef, boolean isNodeArchived) {
        throw new IntegrityException("Operation failed. Deletion of Transfer Container is not allowed.", null);
    }
}

