/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.permission;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.permission.RecordsManagementPermissionPostProcessor;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.model.PermissionModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class RecordsManagementPermissionPostProcessorUnitTest {
    @InjectMocks
    private RecordsManagementPermissionPostProcessor recordsManagementPermissionPostProcessor = new RecordsManagementPermissionPostProcessor();
    @Mock
    private NodeService mockNodeService;
    @Mock
    private PermissionService mockPermissionService;
    @Mock
    private PermissionModel mockPermissionModel;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void configurePermissionsAllowed() {
        AccessStatus accessStatus = AccessStatus.DENIED;
        NodeRef nodeRef = new NodeRef("node://ref/");
        String perm = AlfMock.generateText();
        List<String> configuredReadPermissions = Arrays.asList("ReadProperties", "ReadChildren", perm);
        List<String> configuredFilePermissions = Arrays.asList("WriteProperties", "AddChildren");
        Mockito.when((Object)this.mockNodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT)).thenReturn((Object)true);
        Mockito.when((Object)this.mockPermissionService.hasPermission(nodeRef, "ReadRecords")).thenReturn((Object)AccessStatus.ALLOWED);
        AccessStatus result = this.recordsManagementPermissionPostProcessor.process(accessStatus, nodeRef, perm, configuredReadPermissions, configuredFilePermissions);
        Assert.assertEquals((Object)AccessStatus.ALLOWED, (Object)result);
    }

    @Test
    public void configurePermissionsDenied() {
        AccessStatus accessStatus = AccessStatus.DENIED;
        NodeRef nodeRef = new NodeRef("node://ref/");
        String perm = AlfMock.generateText();
        List<String> configuredReadPermissions = Arrays.asList("ReadProperties", "ReadChildren");
        List<String> configuredFilePermissions = Arrays.asList("WriteProperties", "AddChildren");
        Mockito.when((Object)this.mockNodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT)).thenReturn((Object)true);
        Mockito.when((Object)this.mockPermissionService.hasPermission(nodeRef, "ReadRecords")).thenReturn((Object)AccessStatus.ALLOWED);
        AccessStatus result = this.recordsManagementPermissionPostProcessor.process(accessStatus, nodeRef, perm, configuredReadPermissions, configuredFilePermissions);
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)result);
    }

    @Test
    public void permissionInherittedFromConfiguredGroup() {
        NodeRef nodeRef = new NodeRef("node://ref/");
        List<String> configuredReadPermissions = Arrays.asList(new String[0]);
        List<String> configuredFilePermissions = Arrays.asList("WriteProperties");
        Mockito.when((Object)this.mockNodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT)).thenReturn((Object)true);
        Mockito.when((Object)this.mockPermissionService.hasPermission(nodeRef, "FileRecords")).thenReturn((Object)AccessStatus.ALLOWED);
        PermissionReference mockWritePropsPermRef = (PermissionReference)Mockito.mock(PermissionReference.class);
        Mockito.when((Object)this.mockPermissionModel.getPermissionReference(null, "WriteProperties")).thenReturn((Object)mockWritePropsPermRef);
        PermissionReference childOne = (PermissionReference)Mockito.mock(PermissionReference.class);
        Mockito.when((Object)childOne.getName()).thenReturn((Object)"Not this one");
        PermissionReference childTwo = (PermissionReference)Mockito.mock(PermissionReference.class);
        Mockito.when((Object)childTwo.getName()).thenReturn((Object)"This is the requested permission");
        PermissionReference childThree = (PermissionReference)Mockito.mock(PermissionReference.class);
        Mockito.when((Object)childThree.getName()).thenReturn((Object)"Not this one either");
        Mockito.when((Object)this.mockPermissionModel.getGranteePermissions(mockWritePropsPermRef)).thenReturn((Object)Sets.newHashSet((Object[])new PermissionReference[]{childOne, childTwo, childThree}));
        AccessStatus result = this.recordsManagementPermissionPostProcessor.process(AccessStatus.DENIED, nodeRef, "This is the requested permission", configuredReadPermissions, configuredFilePermissions);
        Assert.assertEquals((Object)AccessStatus.ALLOWED, (Object)result);
    }
}

