/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.alfresco.service.namespace.QName;

public class PropertyModificationAllowedCheck {
    private List<QName> whiteList;
    private List<String> editableURIs;

    private List<String> getEditableURIs() {
        return Collections.unmodifiableList(this.editableURIs);
    }

    public void setEditableURIs(List<String> editableURIs) {
        this.editableURIs = Collections.unmodifiableList(editableURIs);
    }

    public void setWhiteList(List<QName> whiteList) {
        this.whiteList = Collections.unmodifiableList(whiteList);
    }

    public boolean check(Map<QName, Serializable> before, Map<QName, Serializable> after) {
        QName key;
        boolean proceed = true;
        for (Map.Entry<QName, Serializable> entry : before.entrySet()) {
            boolean propertyRemovedEmptied;
            key = entry.getKey();
            Serializable beforeValue = entry.getValue();
            boolean modified = after.containsKey(key) && after.get(key) != null && !after.get(key).equals(beforeValue);
            boolean bl = propertyRemovedEmptied = after.get(key) == null && beforeValue != null || !after.containsKey(key);
            if (modified || propertyRemovedEmptied) {
                proceed = this.allowPropertyUpdate(key);
            }
            if (proceed) continue;
            return proceed;
        }
        HashSet<QName> newKeys = new HashSet<QName>(after.keySet());
        newKeys.removeAll(before.keySet());
        Iterator iterator = newKeys.iterator();
        while (iterator.hasNext() && (proceed = this.allowPropertyUpdate(key = (QName)iterator.next()))) {
        }
        return proceed;
    }

    private boolean allowPropertyUpdate(QName key) {
        return this.whiteList.contains(key) || this.getEditableURIs().contains(key.getNamespaceURI());
    }
}

