/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.relationship;

import java.util.HashSet;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.GUID;

public class CreateRelationshipTest
extends BaseRMTestCase {
    public void testReadOnlyPermissionOnSource() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AccessDeniedException.class){
            private String roleName;
            private String user;
            private NodeRef sourceRecordCategory;
            private NodeRef targetRecordCategory;
            private NodeRef sourceRecordFolder;
            private NodeRef targetRecordFolder;
            private NodeRef sourceRecord;
            private NodeRef targetRecord;
            {
                this.roleName = GUID.generate();
                this.user = GUID.generate();
            }

            @Override
            public void given() throws Exception {
                this.sourceRecordCategory = CreateRelationshipTest.this.filePlanService.createRecordCategory(CreateRelationshipTest.this.filePlan, GUID.generate());
                this.sourceRecordFolder = CreateRelationshipTest.this.recordFolderService.createRecordFolder(this.sourceRecordCategory, GUID.generate());
                this.sourceRecord = CreateRelationshipTest.this.utils.createRecord(this.sourceRecordFolder, GUID.generate());
                this.targetRecordCategory = CreateRelationshipTest.this.filePlanService.createRecordCategory(CreateRelationshipTest.this.filePlan, GUID.generate());
                this.targetRecordFolder = CreateRelationshipTest.this.recordFolderService.createRecordFolder(this.targetRecordCategory, GUID.generate());
                this.targetRecord = CreateRelationshipTest.this.utils.createRecord(this.targetRecordFolder, GUID.generate());
                HashSet<Capability> capabilities = new HashSet<Capability>(2);
                capabilities.add(CreateRelationshipTest.this.capabilityService.getCapability("ViewRecords"));
                capabilities.add(CreateRelationshipTest.this.capabilityService.getCapability("ChangeOrDeleteReferences"));
                CreateRelationshipTest.this.filePlanRoleService.createRole(CreateRelationshipTest.this.filePlan, this.roleName, this.roleName, capabilities);
                CreateRelationshipTest.this.createPerson(this.user, true);
                CreateRelationshipTest.this.filePlanRoleService.assignRoleToAuthority(CreateRelationshipTest.this.filePlan, this.roleName, this.user);
            }

            @Override
            public void when() {
                CreateRelationshipTest.this.filePlanPermissionService.setPermission(this.sourceRecord, this.user, "ReadRecords");
                CreateRelationshipTest.this.filePlanPermissionService.setPermission(this.targetRecord, this.user, "Filing");
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        CreateRelationshipTest.this.relationshipService.addRelationship("crossreference", sourceRecord, targetRecord);
                        return null;
                    }
                }, (String)this.user);
            }
        });
    }

    public void testReadOnlyPermissionOnTarget() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(AccessDeniedException.class){
            private String roleName;
            private String user;
            private NodeRef sourceRecordCategory;
            private NodeRef targetRecordCategory;
            private NodeRef sourceRecordFolder;
            private NodeRef targetRecordFolder;
            private NodeRef sourceRecord;
            private NodeRef targetRecord;
            {
                this.roleName = GUID.generate();
                this.user = GUID.generate();
            }

            @Override
            public void given() throws Exception {
                this.sourceRecordCategory = CreateRelationshipTest.this.filePlanService.createRecordCategory(CreateRelationshipTest.this.filePlan, GUID.generate());
                this.sourceRecordFolder = CreateRelationshipTest.this.recordFolderService.createRecordFolder(this.sourceRecordCategory, GUID.generate());
                this.sourceRecord = CreateRelationshipTest.this.utils.createRecord(this.sourceRecordFolder, GUID.generate());
                this.targetRecordCategory = CreateRelationshipTest.this.filePlanService.createRecordCategory(CreateRelationshipTest.this.filePlan, GUID.generate());
                this.targetRecordFolder = CreateRelationshipTest.this.recordFolderService.createRecordFolder(this.targetRecordCategory, GUID.generate());
                this.targetRecord = CreateRelationshipTest.this.utils.createRecord(this.targetRecordFolder, GUID.generate());
                HashSet<Capability> capabilities = new HashSet<Capability>(2);
                capabilities.add(CreateRelationshipTest.this.capabilityService.getCapability("ViewRecords"));
                capabilities.add(CreateRelationshipTest.this.capabilityService.getCapability("ChangeOrDeleteReferences"));
                CreateRelationshipTest.this.filePlanRoleService.createRole(CreateRelationshipTest.this.filePlan, this.roleName, this.roleName, capabilities);
                CreateRelationshipTest.this.createPerson(this.user, true);
                CreateRelationshipTest.this.filePlanRoleService.assignRoleToAuthority(CreateRelationshipTest.this.filePlan, this.roleName, this.user);
            }

            @Override
            public void when() {
                CreateRelationshipTest.this.filePlanPermissionService.setPermission(this.sourceRecord, this.user, "Filing");
                CreateRelationshipTest.this.filePlanPermissionService.setPermission(this.targetRecord, this.user, "ReadRecords");
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        CreateRelationshipTest.this.relationshipService.addRelationship("crossreference", sourceRecord, targetRecord);
                        return null;
                    }
                }, (String)this.user);
            }
        });
    }

    public void testFillingPermissionOnSourceAndTarget() throws Exception {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            private String roleName;
            private String user;
            private NodeRef sourceRecordCategory;
            private NodeRef targetRecordCategory;
            private NodeRef sourceRecordFolder;
            private NodeRef targetRecordFolder;
            private NodeRef sourceRecord;
            private NodeRef targetRecord;
            {
                this.roleName = GUID.generate();
                this.user = GUID.generate();
            }

            @Override
            public void given() throws Exception {
                this.sourceRecordCategory = CreateRelationshipTest.this.filePlanService.createRecordCategory(CreateRelationshipTest.this.filePlan, GUID.generate());
                this.sourceRecordFolder = CreateRelationshipTest.this.recordFolderService.createRecordFolder(this.sourceRecordCategory, GUID.generate());
                this.sourceRecord = CreateRelationshipTest.this.utils.createRecord(this.sourceRecordFolder, GUID.generate());
                this.targetRecordCategory = CreateRelationshipTest.this.filePlanService.createRecordCategory(CreateRelationshipTest.this.filePlan, GUID.generate());
                this.targetRecordFolder = CreateRelationshipTest.this.recordFolderService.createRecordFolder(this.targetRecordCategory, GUID.generate());
                this.targetRecord = CreateRelationshipTest.this.utils.createRecord(this.targetRecordFolder, GUID.generate());
                HashSet<Capability> capabilities = new HashSet<Capability>(2);
                capabilities.add(CreateRelationshipTest.this.capabilityService.getCapability("ViewRecords"));
                capabilities.add(CreateRelationshipTest.this.capabilityService.getCapability("ChangeOrDeleteReferences"));
                CreateRelationshipTest.this.filePlanRoleService.createRole(CreateRelationshipTest.this.filePlan, this.roleName, this.roleName, capabilities);
                CreateRelationshipTest.this.createPerson(this.user, true);
                CreateRelationshipTest.this.filePlanRoleService.assignRoleToAuthority(CreateRelationshipTest.this.filePlan, this.roleName, this.user);
            }

            @Override
            public void when() {
                CreateRelationshipTest.this.filePlanPermissionService.setPermission(this.sourceRecordCategory, this.user, "Filing");
                CreateRelationshipTest.this.filePlanPermissionService.setPermission(this.targetRecordCategory, this.user, "Filing");
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        CreateRelationshipTest.this.relationshipService.addRelationship("crossreference", sourceRecord, targetRecord);
                        return null;
                    }
                }, (String)this.user);
            }

            @Override
            public void then() throws Exception {
                TestCase.assertEquals((int)1, (int)CreateRelationshipTest.this.relationshipService.getRelationshipsFrom(this.sourceRecord).size());
                TestCase.assertEquals((int)0, (int)CreateRelationshipTest.this.relationshipService.getRelationshipsTo(this.sourceRecord).size());
                TestCase.assertEquals((int)0, (int)CreateRelationshipTest.this.relationshipService.getRelationshipsFrom(this.targetRecord).size());
                TestCase.assertEquals((int)1, (int)CreateRelationshipTest.this.relationshipService.getRelationshipsTo(this.targetRecord).size());
            }
        });
    }
}

