/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.parameter;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.action.parameter.ParameterProcessor;
import org.alfresco.repo.action.parameter.ParameterSubstitutionSuggester;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.commons.lang3.StringUtils;

public class DateParameterProcessor
extends ParameterProcessor
implements ParameterSubstitutionSuggester {
    private static final String DAY = "day";
    private static final String WEEK = "week";
    private static final String MONTH = "month";
    private static final String YEAR = "year";
    private static final String SHORT = "short";
    private static final String LONG = "long";
    private static final String NUMBER = "number";
    private static final String SEP = ".";
    private static final String[] ALL_FIELDS_FOR_SUBSTITUTION_QUERY = new String[]{"day.short", "day", "day.long", "day.number", "day.month", "day.year", "month.short", "month", "month.long", "month.number", "year.short", "year", "year.long", "year.week"};
    private int maximumNumberSuggestions = 10;

    @Override
    public String process(String value, NodeRef actionedUponNodeRef) {
        String result = value;
        if (!(value = this.stripName(value)).isEmpty()) {
            String[] values = value.split("\\.", 2);
            String field = values[0].trim();
            if (DAY.equalsIgnoreCase(field)) {
                result = this.handleDay(values);
            } else if (MONTH.equalsIgnoreCase(field)) {
                result = this.handleMonth(values);
            } else if (YEAR.equalsIgnoreCase(field)) {
                result = this.handleYear(values);
            } else {
                throw new AlfrescoRuntimeException("Cannot process the field '" + field + "'.");
            }
        }
        return result;
    }

    private String handleDay(String[] values) {
        String pattern;
        String style = this.getStyle(values);
        if (SHORT.equalsIgnoreCase(style)) {
            pattern = "EE";
        } else if (LONG.equalsIgnoreCase(style)) {
            pattern = "EEEE";
        } else if (NUMBER.equalsIgnoreCase(style)) {
            pattern = "uu";
        } else if (MONTH.equalsIgnoreCase(style)) {
            pattern = "dd";
        } else if (YEAR.equalsIgnoreCase(style)) {
            pattern = "DDD";
        } else {
            throw new AlfrescoRuntimeException("The pattern 'date.day." + style + "' is not supported!");
        }
        return new SimpleDateFormat(pattern).format(new Date());
    }

    private String handleMonth(String[] values) {
        String pattern;
        String style = this.getStyle(values);
        if (SHORT.equalsIgnoreCase(style)) {
            pattern = "MMM";
        } else if (LONG.equalsIgnoreCase(style)) {
            pattern = "MMMM";
        } else if (NUMBER.equalsIgnoreCase(style)) {
            pattern = "MM";
        } else {
            throw new AlfrescoRuntimeException("The pattern 'date.month." + style + "' is not supported!");
        }
        return new SimpleDateFormat(pattern).format(new Date());
    }

    private String handleYear(String[] values) {
        String pattern;
        String style = this.getStyle(values);
        if (SHORT.equalsIgnoreCase(style)) {
            pattern = "yy";
        } else if (LONG.equalsIgnoreCase(style)) {
            pattern = "yyyy";
        } else if (WEEK.equalsIgnoreCase(style)) {
            pattern = "ww";
        } else {
            throw new AlfrescoRuntimeException("The pattern 'date.year." + style + "' is not supported!");
        }
        return new SimpleDateFormat(pattern).format(new Date());
    }

    private String getStyle(String[] values) {
        String style = values.length == 1 ? SHORT : values[1].trim();
        return style;
    }

    public void setMaximumNumberSuggestions(int maximumNumberSuggestions) {
        this.maximumNumberSuggestions = maximumNumberSuggestions <= 0 ? 10 : maximumNumberSuggestions;
    }

    @Override
    public List<String> getSubstitutionSuggestions(String substitutionFragment) {
        ArrayList<String> suggestions = new ArrayList<String>();
        String namePrefix = this.getName() + SEP;
        if (StringUtils.isBlank((CharSequence)substitutionFragment) || this.getName().toLowerCase().contains(substitutionFragment.toLowerCase())) {
            for (String field : ALL_FIELDS_FOR_SUBSTITUTION_QUERY) {
                suggestions.add(namePrefix + field);
                if (suggestions.size() < this.maximumNumberSuggestions) {
                    continue;
                }
                break;
            }
        } else {
            for (String field : ALL_FIELDS_FOR_SUBSTITUTION_QUERY) {
                String prefixFieldName = namePrefix + field;
                if (!prefixFieldName.toLowerCase().contains(substitutionFragment.toLowerCase())) continue;
                suggestions.add(namePrefix + field);
                if (suggestions.size() < this.maximumNumberSuggestions) {
                    continue;
                }
                break;
            }
        }
        return suggestions;
    }
}

