/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.util;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.module.org_alfresco_module_rm.admin.RecordsManagementAdminService;
import org.alfresco.module.org_alfresco_module_rm.audit.RecordsManagementAuditService;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.capability.RMPermissionModel;
import org.alfresco.module.org_alfresco_module_rm.dataset.DataSetService;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.event.RecordsManagementEventService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.freeze.FreezeService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.identifier.IdentifierService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.InplaceRecordService;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.relationship.RelationshipService;
import org.alfresco.module.org_alfresco_module_rm.report.ReportService;
import org.alfresco.module.org_alfresco_module_rm.role.FilePlanRoleService;
import org.alfresco.module.org_alfresco_module_rm.search.RecordsManagementSearchService;
import org.alfresco.module.org_alfresco_module_rm.security.ExtendedSecurityService;
import org.alfresco.module.org_alfresco_module_rm.security.FilePlanPermissionService;
import org.alfresco.module.org_alfresco_module_rm.test.util.CommonRMTestUtils;
import org.alfresco.module.org_alfresco_module_rm.test.util.UserAndGroupsUtils;
import org.alfresco.module.org_alfresco_module_rm.util.RMContainerCacheManager;
import org.alfresco.module.org_alfresco_module_rm.vital.VitalRecordService;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteServiceImpl;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.DocumentLinkService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.springframework.context.ApplicationContext;

public abstract class BaseRMTestCase
extends RetryingTransactionHelperTestCase
implements RecordsManagementModel,
ContentModel,
RMPermissionModel {
    protected ApplicationContext applicationContext;
    protected String URI = "http://www.alfresco.org/model/rmtest/1.0";
    protected String PREFIX = "rmt";
    protected QName TYPE_CUSTOM_TYPE = QName.createQName((String)this.URI, (String)"customType");
    protected QName ASPECT_CUSTOM_ASPECT = QName.createQName((String)this.URI, (String)"customAspect");
    protected QName ASPECT_RECORD_META_DATA = QName.createQName((String)this.URI, (String)"recordMetaData");
    protected String NAME_DM_DOCUMENT = "collabDocument.txt";
    protected String NAME_DM_DOCUMENT1 = "collabDocument1.txt";
    protected static final String ADMIN_USER = "admin";
    protected CommonRMTestUtils utils;
    protected NodeService nodeService;
    protected ContentService contentService;
    protected DictionaryService dictionaryService;
    protected RetryingTransactionHelper retryingTransactionHelper;
    protected PolicyComponent policyComponent;
    protected NamespaceService namespaceService;
    protected SearchService searchService;
    protected SiteService siteService;
    protected MutableAuthenticationService authenticationService;
    protected AuthorityService authorityService;
    protected PersonService personService;
    protected TransactionService transactionService;
    protected FileFolderService fileFolderService;
    protected PermissionService permissionService;
    protected TaggingService taggingService;
    protected ActionService actionService;
    protected OwnableService ownableService;
    protected VersionService versionService;
    protected DocumentLinkService documentLinkService;
    protected Repository repositoryHelper;
    protected DispositionService dispositionService;
    protected RecordsManagementEventService rmEventService;
    protected RecordsManagementAdminService rmAdminService;
    protected RecordsManagementActionService rmActionService;
    protected RecordsManagementSearchService rmSearchService;
    protected FilePlanRoleService filePlanRoleService;
    protected FilePlanPermissionService filePlanPermissionService;
    protected CapabilityService capabilityService;
    protected VitalRecordService vitalRecordService;
    protected DataSetService dataSetService;
    protected FreezeService freezeService;
    protected RecordService recordService;
    protected FilePlanService filePlanService;
    protected RecordFolderService recordFolderService;
    protected ExtendedSecurityService extendedSecurityService;
    protected ReportService reportService;
    protected RecordsManagementAuditService rmAuditService;
    protected IdentifierService identifierService;
    protected HoldService holdService;
    protected InplaceRecordService inplaceRecordService;
    protected RelationshipService relationshipService;
    protected RMContainerCacheManager rmContainerCacheManager;
    protected UserAndGroupsUtils userAndGroupsUtils;
    protected String siteId;
    protected StoreRef storeRef;
    protected NodeRef rootNodeRef;
    protected SiteInfo siteInfo;
    protected NodeRef folder;
    protected NodeRef filePlan;
    protected NodeRef rmContainer;
    protected NodeRef rm_Container;
    protected DispositionSchedule dispositionSchedule;
    protected NodeRef rmFolder;
    protected NodeRef rm_Folder;
    protected NodeRef unfiledContainer;
    protected String collabSiteId;
    protected NodeRef holdsContainer;
    protected NodeRef transfersContainer;
    protected NodeRef mhContainer;
    protected NodeRef mhContainer11;
    protected DispositionSchedule mhDispositionSchedule11;
    protected NodeRef mhContainer12;
    protected DispositionSchedule mhDispositionSchedule12;
    protected NodeRef mhContainer21;
    protected NodeRef mhContainer22;
    protected NodeRef mhContainer23;
    protected DispositionSchedule mhDispositionSchedule23;
    protected NodeRef mhContainer31;
    protected NodeRef mhContainer32;
    protected NodeRef mhContainer33;
    protected DispositionSchedule mhDispositionSchedule33;
    protected NodeRef mhContainer34;
    protected NodeRef mhContainer35;
    protected DispositionSchedule mhDispositionSchedule35;
    protected NodeRef mhRecordFolder41;
    protected NodeRef mhRecordFolder42;
    protected NodeRef mhRecordFolder43;
    protected NodeRef mhRecordFolder44;
    protected NodeRef mhRecordFolder45;
    protected String[] testUsers;
    protected String userName;
    protected String rmUserName;
    protected String powerUserName;
    protected String securityOfficerName;
    protected String recordsManagerName;
    protected String rmAdminName;
    protected NodeRef userPerson;
    protected NodeRef rmUserPerson;
    protected NodeRef powerUserPerson;
    protected NodeRef securityOfficerPerson;
    protected NodeRef recordsManagerPerson;
    protected NodeRef rmAdminPerson;
    protected NodeRef recordOne;
    protected NodeRef recordTwo;
    protected NodeRef recordThree;
    protected NodeRef recordFour;
    protected NodeRef recordFive;
    protected NodeRef recordDeclaredOne;
    protected NodeRef recordDeclaredTwo;
    protected SiteInfo collaborationSite;
    protected NodeRef documentLibrary;
    protected NodeRef dmFolder;
    protected NodeRef dmFolder1;
    protected NodeRef dmDocument;
    protected NodeRef dmDocument1;
    protected String dmConsumer;
    protected NodeRef dmConsumerNodeRef;
    protected String dmContributor;
    protected NodeRef dmContributorNodeRef;
    protected String dmCollaborator;
    protected NodeRef dmCollaboratorNodeRef;

    protected String[] getConfigLocations() {
        return new String[]{"classpath:alfresco/application-context.xml", "classpath:alfresco/web-scripts-application-context.xml", "classpath:test-context.xml"};
    }

    protected boolean isRMSiteTest() {
        return true;
    }

    protected boolean isMultiHierarchyTest() {
        return false;
    }

    protected boolean isUserTest() {
        return false;
    }

    protected boolean isRecordTest() {
        return false;
    }

    protected boolean isFillingForAllUsers() {
        return false;
    }

    protected boolean isCollaborationSiteTest() {
        return false;
    }

    protected void setUp() throws Exception {
        this.applicationContext = ApplicationContextHelper.getApplicationContext((String[])this.getConfigLocations());
        this.utils = new CommonRMTestUtils(this.applicationContext);
        this.userAndGroupsUtils = new UserAndGroupsUtils(this.applicationContext);
        this.initServices();
        this.setupTestData();
        if (this.isMultiHierarchyTest()) {
            this.setupMultiHierarchyTestData();
        }
        if (this.isCollaborationSiteTest()) {
            this.setupCollaborationSiteTestData();
        }
        if (this.isUserTest()) {
            this.setupTestUsers(this.filePlan);
        }
    }

    protected void initServices() {
        this.nodeService = (NodeService)this.applicationContext.getBean("NodeService");
        this.contentService = (ContentService)this.applicationContext.getBean("ContentService");
        this.retryingTransactionHelper = (RetryingTransactionHelper)this.applicationContext.getBean("retryingTransactionHelper");
        this.namespaceService = (NamespaceService)this.applicationContext.getBean("NamespaceService");
        this.searchService = (SearchService)this.applicationContext.getBean("SearchService");
        this.policyComponent = (PolicyComponent)this.applicationContext.getBean("policyComponent");
        this.dictionaryService = (DictionaryService)this.applicationContext.getBean("DictionaryService");
        this.siteService = (SiteService)this.applicationContext.getBean("SiteService");
        this.authorityService = (AuthorityService)this.applicationContext.getBean("AuthorityService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("AuthenticationService");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.transactionService = (TransactionService)this.applicationContext.getBean("TransactionService");
        this.fileFolderService = (FileFolderService)this.applicationContext.getBean("FileFolderService");
        this.permissionService = (PermissionService)this.applicationContext.getBean("PermissionService");
        this.taggingService = (TaggingService)this.applicationContext.getBean("TaggingService");
        this.actionService = (ActionService)this.applicationContext.getBean("ActionService");
        this.ownableService = (OwnableService)this.applicationContext.getBean("OwnableService");
        this.versionService = (VersionService)this.applicationContext.getBean("VersionService");
        this.documentLinkService = (DocumentLinkService)this.applicationContext.getBean("DocumentLinkService");
        this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.dispositionService = (DispositionService)this.applicationContext.getBean("DispositionService");
        this.rmEventService = (RecordsManagementEventService)this.applicationContext.getBean("RecordsManagementEventService");
        this.rmAdminService = (RecordsManagementAdminService)this.applicationContext.getBean("RecordsManagementAdminService");
        this.rmActionService = (RecordsManagementActionService)this.applicationContext.getBean("RecordsManagementActionService");
        this.rmSearchService = (RecordsManagementSearchService)this.applicationContext.getBean("RecordsManagementSearchService");
        this.filePlanRoleService = (FilePlanRoleService)this.applicationContext.getBean("FilePlanRoleService");
        this.filePlanPermissionService = (FilePlanPermissionService)this.applicationContext.getBean("FilePlanPermissionService");
        this.capabilityService = (CapabilityService)this.applicationContext.getBean("CapabilityService");
        this.vitalRecordService = (VitalRecordService)this.applicationContext.getBean("VitalRecordService");
        this.dataSetService = (DataSetService)this.applicationContext.getBean("DataSetService");
        this.freezeService = (FreezeService)this.applicationContext.getBean("FreezeService");
        this.recordService = (RecordService)this.applicationContext.getBean("RecordService");
        this.filePlanService = (FilePlanService)this.applicationContext.getBean("FilePlanService");
        this.recordFolderService = (RecordFolderService)this.applicationContext.getBean("RecordFolderService");
        this.extendedSecurityService = (ExtendedSecurityService)this.applicationContext.getBean("ExtendedSecurityService");
        this.reportService = (ReportService)this.applicationContext.getBean("ReportService");
        this.rmAuditService = (RecordsManagementAuditService)this.applicationContext.getBean("RecordsManagementAuditService");
        this.identifierService = (IdentifierService)this.applicationContext.getBean("recordsManagementIdentifierService");
        this.holdService = (HoldService)this.applicationContext.getBean("HoldService");
        this.inplaceRecordService = (InplaceRecordService)this.applicationContext.getBean("InplaceRecordService");
        this.relationshipService = (RelationshipService)this.applicationContext.getBean("RelationshipService");
        this.rmContainerCacheManager = (RMContainerCacheManager)this.applicationContext.getBean("rmContainerCacheManager");
    }

    protected void tearDown() throws Exception {
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.runAsSystem(() -> {
                    BaseRMTestCase.this.tearDownImpl();
                    return null;
                });
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDownImpl() {
        BehaviourFilter filter = (BehaviourFilter)this.applicationContext.getBean("policyBehaviourFilter");
        filter.disableBehaviour();
        try {
            if (this.filePlan != null && this.nodeService.exists(this.filePlan)) {
                List holds = this.holdService.getHolds(this.filePlan);
                for (NodeRef hold : holds) {
                    this.holdService.deleteHold(hold);
                }
            }
            if (this.folder != null && this.nodeService.exists(this.folder)) {
                this.nodeService.deleteNode(this.folder);
            }
            if (this.siteId != null && this.siteService.getSite(this.siteId) != null) {
                this.siteService.deleteSite(this.siteId);
            }
            if (this.isCollaborationSiteTest() && this.siteService.getSite(this.collabSiteId) != null) {
                this.siteService.deleteSite(this.collabSiteId);
            }
            if (this.rmContainerCacheManager != null) {
                this.rmContainerCacheManager.reset();
            }
        }
        finally {
            filter.enableBehaviour();
        }
    }

    public RetryingTransactionHelper getRetryingTransactionHelper() {
        return this.retryingTransactionHelper;
    }

    protected void setupTestData() {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                BaseRMTestCase.this.setupTestDataImpl();
                if (BaseRMTestCase.this.isRecordTest() && BaseRMTestCase.this.isRMSiteTest()) {
                    BaseRMTestCase.this.setupTestRecords();
                }
                return null;
            }

            public void test(Void result) throws Exception {
                if (BaseRMTestCase.this.isRMSiteTest()) {
                    if (BaseRMTestCase.this.isRecordTest()) {
                        BaseRMTestCase.this.utils.completeRecord(BaseRMTestCase.this.recordDeclaredOne);
                        BaseRMTestCase.this.utils.completeRecord(BaseRMTestCase.this.recordDeclaredTwo);
                    }
                    BaseRMTestCase.this.unfiledContainer = BaseRMTestCase.this.filePlanService.getUnfiledContainer(BaseRMTestCase.this.filePlan);
                    TestCase.assertNotNull((Object)BaseRMTestCase.this.unfiledContainer);
                    BaseRMTestCase.this.holdsContainer = BaseRMTestCase.this.filePlanService.getHoldContainer(BaseRMTestCase.this.filePlan);
                    TestCase.assertNotNull((Object)BaseRMTestCase.this.holdsContainer);
                    BaseRMTestCase.this.transfersContainer = BaseRMTestCase.this.filePlanService.getTransferContainer(BaseRMTestCase.this.filePlan);
                    TestCase.assertNotNull((Object)BaseRMTestCase.this.transfersContainer);
                }
            }
        }, AuthenticationUtil.getAdminUserName());
    }

    protected void setupTestDataImpl() {
        this.storeRef = StoreRef.STORE_REF_WORKSPACE_SPACESSTORE;
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        String containerName = "RM2_" + System.currentTimeMillis();
        HashMap<QName, CallSite> containerProps = new HashMap<QName, CallSite>(1);
        containerProps.put(ContentModel.PROP_NAME, (CallSite)((Object)containerName));
        this.folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)containerName), ContentModel.TYPE_FOLDER, containerProps).getChildRef();
        BaseRMTestCase.assertNotNull((String)"Could not create base folder", (Object)this.folder);
        this.permissionService.setPermission(this.folder, ADMIN_USER, "Write", true);
        this.permissionService.setPermission(this.folder, ADMIN_USER, "AddChildren", true);
        if (this.isRMSiteTest()) {
            this.siteId = GUID.generate();
            this.siteInfo = this.siteService.createSite("rm-site-dashboard", this.siteId, "title", "descrition", SiteVisibility.PUBLIC, RecordsManagementModel.TYPE_RM_SITE);
            this.filePlan = this.siteService.getContainer(this.siteId, "documentLibrary");
            BaseRMTestCase.assertNotNull((String)"Site document library container was not created successfully.", (Object)this.filePlan);
            this.rmContainer = this.filePlanService.createRecordCategory(this.filePlan, "rmContainer");
            BaseRMTestCase.assertNotNull((String)"Could not create rm container", (Object)this.rmContainer);
            this.rm_Container = this.filePlanService.createRecordCategory(this.filePlan, "rm Container");
            BaseRMTestCase.assertNotNull((String)"Could not create rm container", (Object)this.rm_Container);
            this.dispositionSchedule = this.utils.createBasicDispositionSchedule(this.rmContainer);
            this.rmFolder = this.recordFolderService.createRecordFolder(this.rmContainer, "rmFolder");
            BaseRMTestCase.assertNotNull((String)"Could not create rm folder", (Object)this.rmFolder);
            this.rm_Folder = this.recordFolderService.createRecordFolder(this.rm_Container, "rm Folder");
            BaseRMTestCase.assertNotNull((String)"Could not create rm folder", (Object)this.rm_Folder);
        }
    }

    protected void setupTestRecords() {
        this.recordOne = this.utils.createRecord(this.rmFolder, "one.txt");
        this.recordTwo = this.utils.createRecord(this.rmFolder, "two.txt");
        this.recordThree = this.utils.createRecord(this.rmFolder, "three.txt");
        this.recordFour = this.utils.createRecord(this.rmFolder, "four.txt");
        this.recordFive = this.utils.createRecord(this.rmFolder, "five.txt");
        this.recordDeclaredOne = this.utils.createRecord(this.rmFolder, "declaredOne.txt");
        this.recordDeclaredTwo = this.utils.createRecord(this.rmFolder, "declaredTwo.txt");
    }

    protected void setupTestUsers(final NodeRef filePlan) {
        AuthenticationUtil.runAs(() -> {
            this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                public Object execute() throws Throwable {
                    BaseRMTestCase.this.setupTestUsersImpl(filePlan);
                    return null;
                }
            });
            return null;
        }, (String)AuthenticationUtil.getAdminUserName());
    }

    protected void setupTestUsersImpl(NodeRef filePlan) {
        this.userName = GUID.generate();
        this.userPerson = this.createPerson(this.userName);
        this.rmUserName = GUID.generate();
        this.rmUserPerson = this.createPerson(this.rmUserName);
        this.filePlanRoleService.assignRoleToAuthority(filePlan, "User", this.rmUserName);
        this.powerUserName = GUID.generate();
        this.powerUserPerson = this.createPerson(this.powerUserName);
        this.filePlanRoleService.assignRoleToAuthority(filePlan, "PowerUser", this.powerUserName);
        this.securityOfficerName = GUID.generate();
        this.securityOfficerPerson = this.createPerson(this.securityOfficerName);
        this.filePlanRoleService.assignRoleToAuthority(filePlan, "SecurityOfficer", this.securityOfficerName);
        this.recordsManagerName = GUID.generate();
        this.recordsManagerPerson = this.createPerson(this.recordsManagerName);
        this.filePlanRoleService.assignRoleToAuthority(filePlan, "RecordsManager", this.recordsManagerName);
        this.rmAdminName = GUID.generate();
        this.rmAdminPerson = this.createPerson(this.rmAdminName);
        this.filePlanRoleService.assignRoleToAuthority(filePlan, "Administrator", this.rmAdminName);
        this.testUsers = new String[]{this.userName, this.rmUserName, this.powerUserName, this.securityOfficerName, this.recordsManagerName, this.rmAdminName};
        if (this.isFillingForAllUsers()) {
            for (String user : this.testUsers) {
                this.filePlanPermissionService.setPermission(filePlan, user, "Filing");
                this.filePlanPermissionService.setPermission(this.rmContainer, user, "Filing");
                this.filePlanPermissionService.setPermission(this.rmFolder, user, "Filing");
                this.filePlanPermissionService.setPermission(this.unfiledContainer, user, "Filing");
            }
        }
    }

    protected NodeRef createPerson(String userName, boolean createAuth) {
        if (createAuth) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
        }
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(ContentModel.PROP_USERNAME, userName);
        properties.put(ContentModel.PROP_FIRSTNAME, userName);
        return this.personService.createPerson(properties);
    }

    protected NodeRef createPerson(String userName) {
        return this.createPerson(userName, true);
    }

    protected void setupMultiHierarchyTestData() {
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                return AuthenticationUtil.runAsSystem(() -> {
                    BaseRMTestCase.this.setupMultiHierarchyTestDataImpl();
                    return null;
                });
            }
        });
    }

    protected void setupMultiHierarchyTestDataImpl() {
        this.mhContainer = this.filePlanService.createRecordCategory(this.filePlan, "mhContainer");
        this.mhContainer11 = this.filePlanService.createRecordCategory(this.mhContainer, "mhContainer11");
        this.mhDispositionSchedule11 = this.utils.createBasicDispositionSchedule(this.mhContainer11, "ds11", "disposition authority", false, true);
        this.mhContainer12 = this.filePlanService.createRecordCategory(this.mhContainer, "mhContainer12");
        this.mhDispositionSchedule12 = this.utils.createBasicDispositionSchedule(this.mhContainer12, "ds12", "disposition authority", false, true);
        this.mhContainer21 = this.filePlanService.createRecordCategory(this.mhContainer11, "mhContainer21");
        this.mhContainer22 = this.filePlanService.createRecordCategory(this.mhContainer12, "mhContainer22");
        this.mhContainer23 = this.filePlanService.createRecordCategory(this.mhContainer12, "mhContainer23");
        this.mhDispositionSchedule23 = this.utils.createBasicDispositionSchedule(this.mhContainer23, "ds23", "disposition authority", false, true);
        this.mhContainer31 = this.filePlanService.createRecordCategory(this.mhContainer21, "mhContainer31");
        this.mhContainer32 = this.filePlanService.createRecordCategory(this.mhContainer22, "mhContainer32");
        this.mhContainer33 = this.filePlanService.createRecordCategory(this.mhContainer22, "mhContainer33");
        this.mhDispositionSchedule33 = this.utils.createBasicDispositionSchedule(this.mhContainer33, "ds33", "disposition authority", true, true);
        this.mhContainer34 = this.filePlanService.createRecordCategory(this.mhContainer23, "mhContainer34");
        this.mhContainer35 = this.filePlanService.createRecordCategory(this.mhContainer23, "mhContainer35");
        this.mhDispositionSchedule35 = this.utils.createBasicDispositionSchedule(this.mhContainer35, "ds35", "disposition authority", true, true);
        this.mhRecordFolder41 = this.recordFolderService.createRecordFolder(this.mhContainer31, "mhFolder41");
        this.mhRecordFolder42 = this.recordFolderService.createRecordFolder(this.mhContainer32, "mhFolder42");
        this.mhRecordFolder43 = this.recordFolderService.createRecordFolder(this.mhContainer33, "mhFolder43");
        this.mhRecordFolder44 = this.recordFolderService.createRecordFolder(this.mhContainer34, "mhFolder44");
        this.mhRecordFolder45 = this.recordFolderService.createRecordFolder(this.mhContainer35, "mhFolder45");
    }

    protected void setupCollaborationSiteTestData() {
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                BaseRMTestCase.this.setupCollaborationSiteTestDataImpl();
                return null;
            }
        }, AuthenticationUtil.getAdminUserName());
    }

    protected void setupCollaborationSiteTestDataImpl() {
        this.collabSiteId = GUID.generate();
        this.collaborationSite = this.siteService.createSite("site-dashboard", this.collabSiteId, "title", "description", SiteVisibility.PRIVATE);
        this.documentLibrary = SiteServiceImpl.getSiteContainer((String)this.collabSiteId, (String)"documentLibrary", (boolean)true, (SiteService)this.siteService, (TransactionService)this.transactionService, (TaggingService)this.taggingService);
        BaseRMTestCase.assertNotNull((String)"Collaboration site document library component was not successfully created.", (Object)this.documentLibrary);
        this.dmFolder = this.fileFolderService.create(this.documentLibrary, "collabFolder", ContentModel.TYPE_FOLDER).getNodeRef();
        this.dmDocument = this.fileFolderService.create(this.dmFolder, this.NAME_DM_DOCUMENT, ContentModel.TYPE_CONTENT).getNodeRef();
        this.dmFolder1 = this.fileFolderService.create(this.documentLibrary, "collabFolder1", ContentModel.TYPE_FOLDER).getNodeRef();
        this.dmDocument1 = this.fileFolderService.create(this.dmFolder1, this.NAME_DM_DOCUMENT1, ContentModel.TYPE_CONTENT).getNodeRef();
        this.dmConsumer = GUID.generate();
        this.dmConsumerNodeRef = this.createPerson(this.dmConsumer);
        this.siteService.setMembership(this.collabSiteId, this.dmConsumer, "SiteConsumer");
        this.dmContributor = GUID.generate();
        this.dmContributorNodeRef = this.createPerson(this.dmContributor);
        this.siteService.setMembership(this.collabSiteId, this.dmContributor, "SiteContributor");
        this.dmCollaborator = GUID.generate();
        this.dmCollaboratorNodeRef = this.createPerson(this.dmCollaborator);
        this.siteService.setMembership(this.collabSiteId, this.dmCollaborator, "SiteCollaborator");
    }

    protected <A> A doTestInTransaction(RetryingTransactionHelperTestCase.Test<A> test) {
        return (A)super.doTestInTransaction(test, AuthenticationUtil.getAdminUserName());
    }

    protected void doTestInTransaction(RetryingTransactionHelperTestCase.FailureTest test) {
        super.doTestInTransaction(test, AuthenticationUtil.getAdminUserName());
    }

    protected void doBehaviourDrivenTest(BehaviourDrivenTest test) {
        try {
            test.run();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    protected abstract class BehaviourDrivenTest {
        protected boolean runInTransactionTests = true;
        protected String runAsUser = AuthenticationUtil.getAdminUserName();
        protected Class<?> expectedException;

        public BehaviourDrivenTest() {
        }

        public BehaviourDrivenTest(Class<?> expectedException) {
            this.expectedException = expectedException;
        }

        public BehaviourDrivenTest(Class<?> expectedException, String runAsUser) {
            this.expectedException = expectedException;
            this.runAsUser = runAsUser;
        }

        public BehaviourDrivenTest(String runAsUser) {
            this.runAsUser = runAsUser;
        }

        public BehaviourDrivenTest(String runAsUser, boolean runInTransactionTests) {
            this.runInTransactionTests = runInTransactionTests;
            if (runAsUser != null) {
                this.runAsUser = runAsUser;
            }
        }

        public BehaviourDrivenTest(Class<?> expectedException, String runAsUser, boolean runInTransactionTests) {
            this.expectedException = expectedException;
            this.runAsUser = runAsUser;
            this.runInTransactionTests = runInTransactionTests;
        }

        public void given() throws Exception {
        }

        public void when() throws Exception {
        }

        public void then() throws Exception {
        }

        public void after() throws Exception {
        }

        public void run() throws Exception {
            block11: {
                block10: {
                    try {
                        if (this.runInTransactionTests) {
                            BaseRMTestCase.this.doTestInTransaction(new VoidTest(){

                                @Override
                                public void runImpl() throws Exception {
                                    BehaviourDrivenTest.this.given();
                                }
                            }, this.runAsUser);
                        } else {
                            this.given();
                        }
                        if (this.expectedException == null) {
                            if (this.runInTransactionTests) {
                                BaseRMTestCase.this.doTestInTransaction(new VoidTest(){

                                    @Override
                                    public void runImpl() throws Exception {
                                        BehaviourDrivenTest.this.when();
                                    }
                                }, this.runAsUser);
                                BaseRMTestCase.this.doTestInTransaction(new VoidTest(){

                                    @Override
                                    public void runImpl() throws Exception {
                                        BehaviourDrivenTest.this.then();
                                    }
                                }, this.runAsUser);
                            } else {
                                this.when();
                                this.then();
                            }
                        } else {
                            BaseRMTestCase.this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(this.expectedException){

                                public void run() throws Exception {
                                    BehaviourDrivenTest.this.when();
                                }
                            }, this.runAsUser);
                        }
                        if (!this.runInTransactionTests) break block10;
                    }
                    catch (Throwable throwable) {
                        if (this.runInTransactionTests) {
                            BaseRMTestCase.this.doTestInTransaction(new VoidTest(){

                                @Override
                                public void runImpl() throws Exception {
                                    BehaviourDrivenTest.this.after();
                                }
                            }, this.runAsUser);
                        } else {
                            this.after();
                        }
                        throw throwable;
                    }
                    BaseRMTestCase.this.doTestInTransaction(new /* invalid duplicate definition of identical inner class */, this.runAsUser);
                    break block11;
                }
                this.after();
            }
        }
    }

    protected abstract class VoidTest
    extends RetryingTransactionHelperTestCase.Test<Void> {
        protected VoidTest(BaseRMTestCase this$0) {
            super((RetryingTransactionHelperTestCase)this$0);
        }

        public Void run() throws Exception {
            this.runImpl();
            return null;
        }

        public abstract void runImpl() throws Exception;

        public void test(Void result) throws Exception {
            this.testImpl();
        }

        public void testImpl() throws Exception {
        }
    }
}

