/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.RecordsManagementPolicies;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementAction;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;

public class RecordsManagementActionServiceImplTest
extends BaseRMTestCase
implements RecordsManagementPolicies.BeforeRMActionExecution,
RecordsManagementPolicies.OnRMActionExecution {
    private RetryingTransactionHelper txnHelper;
    private NodeRef nodeRef;
    private List<NodeRef> nodeRefs;
    private boolean beforeMarker;
    private boolean onMarker;
    private boolean inTest;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.txnHelper = this.transactionService.getRetryingTransactionHelper();
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
        RetryingTransactionHelper.RetryingTransactionCallback<Void> setUpCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef rootNodeRef = RecordsManagementActionServiceImplTest.this.nodeService.getRootNode(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE);
                RecordsManagementActionServiceImplTest.this.nodeRef = RecordsManagementActionServiceImplTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"temp.txt"), ContentModel.TYPE_CONTENT).getChildRef();
                RecordsManagementActionServiceImplTest.this.nodeRefs = new ArrayList<NodeRef>(5);
                for (int i = 0; i < 5; ++i) {
                    RecordsManagementActionServiceImplTest.this.nodeRefs.add(RecordsManagementActionServiceImplTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm", (String)"temp.txt"), ContentModel.TYPE_CONTENT).getChildRef());
                }
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)setUpCallback);
        this.beforeMarker = false;
        this.onMarker = false;
        this.inTest = false;
    }

    @Override
    protected void tearDown() {
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void testGetActions() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                RecordsManagementActionServiceImplTest.this.getActionsImpl();
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)testCallback);
    }

    private void getActionsImpl() {
        List result = this.rmActionService.getRecordsManagementActions();
        RecordsManagementActionServiceImplTest.assertNotNull((Object)result);
        HashMap<String, RecordsManagementAction> resultMap = new HashMap<String, RecordsManagementAction>(8);
        for (RecordsManagementAction action : result) {
            resultMap.put(action.getName(), action);
        }
        RecordsManagementActionServiceImplTest.assertTrue((boolean)resultMap.containsKey("testAction"));
        RecordsManagementActionServiceImplTest.assertTrue((boolean)resultMap.containsKey("testAction2"));
        result = this.rmActionService.getDispositionActions();
        resultMap = new HashMap(8);
        for (RecordsManagementAction action : result) {
            resultMap.put(action.getName(), action);
        }
        RecordsManagementActionServiceImplTest.assertTrue((boolean)resultMap.containsKey("testAction"));
        RecordsManagementActionServiceImplTest.assertFalse((boolean)resultMap.containsKey("testAction2"));
        RecordsManagementAction cutoff = this.rmActionService.getDispositionAction("cutoff");
        RecordsManagementActionServiceImplTest.assertNotNull((Object)cutoff);
        RecordsManagementActionServiceImplTest.assertEquals((String)"Cut Off", (String)cutoff.getLabel());
        RecordsManagementAction freeze = this.rmActionService.getRecordsManagementAction("freeze");
        RecordsManagementActionServiceImplTest.assertNotNull((Object)freeze);
        RecordsManagementActionServiceImplTest.assertEquals((String)"Freeze", (String)freeze.getLabel());
        RecordsManagementActionServiceImplTest.assertEquals((String)"Freeze", (String)freeze.getLabel());
        RecordsManagementActionServiceImplTest.assertNull((Object)this.rmActionService.getDispositionAction("notThere"));
        RecordsManagementActionServiceImplTest.assertNull((Object)this.rmActionService.getRecordsManagementAction("notThere"));
    }

    public void testExecution() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                RecordsManagementActionServiceImplTest.this.executionImpl();
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)testCallback);
    }

    public void beforeRMActionExecution(NodeRef nodeRef, String name, Map<String, Serializable> parameters) {
        if (this.inTest) {
            RecordsManagementActionServiceImplTest.assertEquals((Object)this.nodeRef, (Object)nodeRef);
            RecordsManagementActionServiceImplTest.assertEquals((String)"testAction", (String)name);
            RecordsManagementActionServiceImplTest.assertEquals((int)1, (int)parameters.size());
            RecordsManagementActionServiceImplTest.assertTrue((boolean)parameters.containsKey("testActionParam"));
            RecordsManagementActionServiceImplTest.assertEquals((Object)"value", (Object)parameters.get("testActionParam"));
            this.beforeMarker = true;
        }
    }

    public void onRMActionExecution(NodeRef nodeRef, String name, Map<String, Serializable> parameters) {
        if (this.inTest) {
            RecordsManagementActionServiceImplTest.assertEquals((Object)this.nodeRef, (Object)nodeRef);
            RecordsManagementActionServiceImplTest.assertEquals((String)"testAction", (String)name);
            RecordsManagementActionServiceImplTest.assertEquals((int)1, (int)parameters.size());
            RecordsManagementActionServiceImplTest.assertTrue((boolean)parameters.containsKey("testActionParam"));
            RecordsManagementActionServiceImplTest.assertEquals((Object)"value", (Object)parameters.get("testActionParam"));
            this.onMarker = true;
        }
    }

    private void executionImpl() {
        this.inTest = true;
        try {
            this.policyComponent.bindClassBehaviour(RecordsManagementPolicies.BEFORE_RM_ACTION_EXECUTION, (Object)this, (Behaviour)new JavaBehaviour((Object)this, "beforeRMActionExecution", Behaviour.NotificationFrequency.EVERY_EVENT));
            this.policyComponent.bindClassBehaviour(RecordsManagementPolicies.ON_RM_ACTION_EXECUTION, (Object)this, (Behaviour)new JavaBehaviour((Object)this, "onRMActionExecution", Behaviour.NotificationFrequency.EVERY_EVENT));
            RecordsManagementActionServiceImplTest.assertFalse((boolean)this.beforeMarker);
            RecordsManagementActionServiceImplTest.assertFalse((boolean)this.onMarker);
            RecordsManagementActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(this.nodeRef, ASPECT_RECORD));
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put("testActionParam", "value");
            this.rmActionService.executeRecordsManagementAction(this.nodeRef, "testAction", params);
            RecordsManagementActionServiceImplTest.assertTrue((boolean)this.beforeMarker);
            RecordsManagementActionServiceImplTest.assertTrue((boolean)this.onMarker);
            RecordsManagementActionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(this.nodeRef, ASPECT_RECORD));
        }
        finally {
            this.inTest = false;
        }
    }

    public void testBulkExecution() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> testCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                RecordsManagementActionServiceImplTest.this.bulkExecutionImpl();
                return null;
            }
        };
        this.txnHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)testCallback);
    }

    private void bulkExecutionImpl() {
        for (NodeRef nodeRef : this.nodeRefs) {
            RecordsManagementActionServiceImplTest.assertFalse((boolean)this.nodeService.hasAspect(nodeRef, ASPECT_RECORD));
        }
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("testActionParam", "value");
        this.rmActionService.executeRecordsManagementAction(this.nodeRefs, "testAction", params);
        for (NodeRef nodeRef : this.nodeRefs) {
            RecordsManagementActionServiceImplTest.assertTrue((boolean)this.nodeService.hasAspect(nodeRef, ASPECT_RECORD));
        }
    }
}

