/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.record;

import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.node.integrity.IntegrityException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.springframework.extensions.webscripts.GUID;

public class UpdateRecordAspectsTest
extends BaseRMTestCase {
    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected boolean isCollaborationSiteTest() {
        return true;
    }

    public void testRemoveRMAspectsFromElectronicRecord() throws Exception {
        final NodeRef record = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                NodeRef rc = UpdateRecordAspectsTest.this.filePlanService.createRecordCategory(UpdateRecordAspectsTest.this.filePlan, GUID.generate());
                NodeRef recordFolder = UpdateRecordAspectsTest.this.recordFolderService.createRecordFolder(rc, GUID.generate());
                return UpdateRecordAspectsTest.this.recordService.createRecordFromContent(recordFolder, GUID.generate(), ContentModel.TYPE_CONTENT, null, null);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(IntegrityException.class){

            public void run() {
                UpdateRecordAspectsTest.this.nodeService.removeAspect(record, RecordsManagementModel.ASPECT_RECORD);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(IntegrityException.class){

            public void run() {
                UpdateRecordAspectsTest.this.nodeService.removeAspect(record, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(IntegrityException.class){

            public void run() {
                UpdateRecordAspectsTest.this.nodeService.removeAspect(record, RecordsManagementModel.ASPECT_RECORD_COMPONENT_ID);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(IntegrityException.class){

            public void run() {
                UpdateRecordAspectsTest.this.nodeService.removeAspect(record, RecordsManagementModel.ASPECT_COMMON_RECORD_DETAILS);
            }
        });
        this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                UpdateRecordAspectsTest.this.nodeService.removeAspect(record, RecordsManagementModel.ASPECT_RECORD);
                UpdateRecordAspectsTest.this.nodeService.removeAspect(record, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT);
                UpdateRecordAspectsTest.this.nodeService.removeAspect(record, RecordsManagementModel.ASPECT_RECORD_COMPONENT_ID);
                UpdateRecordAspectsTest.this.nodeService.removeAspect(record, RecordsManagementModel.ASPECT_COMMON_RECORD_DETAILS);
                return null;
            }
        }, AuthenticationUtil.getSystemUserName());
    }
}

