/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.holds;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.alfresco.module.org_alfresco_module_rm.bulk.BulkCancellationRequest;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkMonitor;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkService;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkStatusAndProcessDetails;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkUtils;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.rest.framework.Operation;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.core.exceptions.NotFoundException;
import org.alfresco.rest.framework.core.exceptions.PermissionDeniedException;
import org.alfresco.rest.framework.core.exceptions.RelationshipResourceNotFoundException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rest.framework.webscripts.WithResponse;
import org.alfresco.rm.rest.api.holds.HoldsEntityResource;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.BulkCancellationEntry;
import org.alfresco.rm.rest.api.model.HoldBulkStatusEntry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.util.ParameterCheck;
import org.springframework.extensions.surf.util.I18NUtil;

@RelationshipResource(name="bulk-statuses", entityResource=HoldsEntityResource.class, title="Bulk statuses of a hold")
public class HoldsBulkStatusesRelation
implements RelationshipResourceAction.Read<HoldBulkStatusEntry>,
RelationshipResourceAction.ReadById<HoldBulkStatusEntry> {
    private HoldBulkMonitor holdBulkMonitor;
    private HoldBulkService holdBulkService;
    private FilePlanComponentsApiUtils apiUtils;
    private PermissionService permissionService;

    public CollectionWithPagingInfo<HoldBulkStatusEntry> readAll(String holdId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("holdId", holdId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef holdRef = this.apiUtils.lookupAndValidateNodeType(holdId, RecordsManagementModel.TYPE_HOLD);
        this.checkReadPermissions(holdRef);
        List<HoldBulkStatusAndProcessDetails> statuses = this.holdBulkMonitor.getBulkStatusesWithProcessDetails(holdId);
        List page = statuses.stream().map(HoldBulkUtils::toHoldBulkStatusEntry).skip(parameters.getPaging().getSkipCount()).limit(parameters.getPaging().getMaxItems()).collect(Collectors.toCollection(LinkedList::new));
        int totalItems = statuses.size();
        boolean hasMore = parameters.getPaging().getSkipCount() + parameters.getPaging().getMaxItems() < totalItems;
        return CollectionWithPagingInfo.asPaged((Paging)parameters.getPaging(), (Collection)page, (boolean)hasMore, (Integer)totalItems);
    }

    public HoldBulkStatusEntry readById(String holdId, String bulkStatusId, Parameters parameters) throws RelationshipResourceNotFoundException {
        RMParameterCheck.checkNotBlank("holdId", holdId);
        RMParameterCheck.checkNotBlank("bulkStatusId", bulkStatusId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef holdRef = this.apiUtils.lookupAndValidateNodeType(holdId, RecordsManagementModel.TYPE_HOLD);
        this.checkReadPermissions(holdRef);
        return Optional.ofNullable(this.holdBulkMonitor.getBulkStatusWithProcessDetails(holdId, bulkStatusId)).map(HoldBulkUtils::toHoldBulkStatusEntry).orElseThrow(() -> new EntityNotFoundException(bulkStatusId));
    }

    @Operation(value="cancel")
    @WebApiDescription(title="Cancel a bulk operation", successStatus=200)
    public void cancelBulkOperation(String holdId, String bulkStatusId, BulkCancellationEntry bulkCancellationEntry, Parameters parameters, WithResponse withResponse) {
        RMParameterCheck.checkNotBlank("holdId", holdId);
        RMParameterCheck.checkNotBlank("bulkStatusId", bulkStatusId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef holdRef = this.apiUtils.lookupAndValidateNodeType(holdId, RecordsManagementModel.TYPE_HOLD);
        this.checkReadPermissions(holdRef);
        if (this.holdBulkMonitor.getBulkStatus(bulkStatusId) == null) {
            throw new NotFoundException("Bulk status not found");
        }
        this.holdBulkService.cancelBulkOperation(holdRef, bulkStatusId, new BulkCancellationRequest(bulkCancellationEntry.reason()));
    }

    private void checkReadPermissions(NodeRef holdRef) {
        if (this.permissionService.hasReadPermission(holdRef) == AccessStatus.DENIED) {
            throw new PermissionDeniedException(I18NUtil.getMessage((String)"permissions.err_access_denied"));
        }
    }

    public void setHoldBulkMonitor(HoldBulkMonitor holdBulkMonitor) {
        this.holdBulkMonitor = holdBulkMonitor;
    }

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setHoldBulkService(HoldBulkService holdBulkService) {
        this.holdBulkService = holdBulkService;
    }
}

