/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.admin.RecordsManagementAdminService;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.springframework.extensions.webscripts.Cache;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.Status;
import org.springframework.extensions.webscripts.WebScriptRequest;

public class CustomisableGet
extends DeclarativeWebScript {
    private RecordsManagementAdminService rmAdminService;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;

    public void setRecordsManagementAdminService(RecordsManagementAdminService rmAdminService) {
        this.rmAdminService = rmAdminService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public Map<String, Object> executeImpl(WebScriptRequest req, Status status, Cache cache) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        Set<QName> qnames = this.rmAdminService.getCustomisable();
        ArrayList<Item> items = new ArrayList<Item>(qnames.size());
        for (QName qname : qnames) {
            ClassDefinition definition = this.dictionaryService.getClass(qname);
            if (definition == null) continue;
            String name = qname.toPrefixString((NamespacePrefixResolver)this.namespaceService);
            String title = definition.getTitle((MessageLookup)this.dictionaryService);
            if (title == null || title.length() == 0) {
                title = qname.getLocalName();
            }
            boolean isAspect = definition.isAspect();
            items.add(new Item(this, name, isAspect, title));
        }
        Collections.sort(items, new Comparator<Item>(this){

            @Override
            public int compare(Item o1, Item o2) {
                return o1.title.compareToIgnoreCase(o2.title);
            }
        });
        model.put("items", items);
        return model;
    }

    public class Item {
        private String name;
        private boolean isAspect;
        private String title;

        public Item(CustomisableGet this$0, String name, boolean isAspect, String title) {
            this.name = name;
            this.isAspect = isAspect;
            this.title = title;
        }

        public String getName() {
            return this.name;
        }

        public boolean getIsAspect() {
            return this.isAspect;
        }

        public String getTitle() {
            return this.title;
        }

        public int hashCode() {
            int varCode = null == this.name ? 0 : this.name.hashCode();
            return 31 + varCode;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            return this.name.equals(((Item)obj).name);
        }
    }
}

