/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.AlfMock;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.repo.security.permissions.impl.ExtendedPermissionServiceImpl;
import org.alfresco.repo.security.permissions.processor.PermissionPostProcessor;
import org.alfresco.repo.security.permissions.processor.PermissionPreProcessor;
import org.alfresco.repo.security.permissions.processor.PermissionProcessorRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.util.Pair;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;

public class ExtendedPermissionServiceImplUnitTest
extends BaseUnitTest {
    private static final Long NODE_ACL_ID = 100L;
    private static final Set<String> READERS = Stream.of(AlfMock.generateText(), AlfMock.generateText()).collect(Collectors.toSet());
    private static final Set<String> WRITERS = Stream.of(AlfMock.generateText(), AlfMock.generateText()).collect(Collectors.toSet());
    private static final String OWNER = AlfMock.generateText();
    @InjectMocks
    @Spy
    private ExtendedPermissionServiceImpl extendedPermissionServiceImpl = new ExtendedPermissionServiceImpl(this){

        protected AccessStatus hasPermissionImpl(NodeRef nodeRef, String perm) {
            return AccessStatus.UNDETERMINED;
        }
    };
    @InjectMocks
    private ExtendedPermissionServiceImpl extendedPermissionServiceImplWithReaderWritersSet = new ExtendedPermissionServiceImpl(this){

        protected AccessStatus hasPermissionImpl(NodeRef nodeRef, String perm) {
            return AccessStatus.UNDETERMINED;
        }

        public Set<String> getReaders(Long aclId) {
            return READERS;
        }

        public Set<String> getWriters(Long aclId) {
            return WRITERS;
        }
    };
    @Mock
    private PermissionProcessorRegistry mockedPermissionProcessorRegistry;
    @Mock
    private PermissionPreProcessor mockedPermissionPreProcessor;
    @Mock
    private PermissionPostProcessor mockedPermissionPostProcessor;

    @Test
    public void preProcessorDoesNotDeny() {
        NodeRef nodeRef = this.generateCmContent("anyname");
        String perm = AlfMock.generateText();
        Mockito.when((Object)this.mockedPermissionProcessorRegistry.getPermissionPreProcessors()).thenReturn(Arrays.asList(this.mockedPermissionPreProcessor));
        Mockito.when((Object)this.mockedPermissionPreProcessor.process(nodeRef, perm)).thenReturn((Object)AccessStatus.UNDETERMINED);
        AccessStatus result = this.extendedPermissionServiceImpl.hasPermission(nodeRef, perm);
        Assert.assertEquals((Object)AccessStatus.UNDETERMINED, (Object)result);
        ((PermissionPreProcessor)Mockito.verify((Object)this.mockedPermissionPreProcessor)).process(nodeRef, perm);
        ((ExtendedPermissionServiceImpl)Mockito.verify((Object)this.extendedPermissionServiceImpl)).hasPermissionImpl(nodeRef, perm);
    }

    @Test
    public void preProcessorDenys() {
        NodeRef nodeRef = this.generateCmContent("anyname");
        String perm = AlfMock.generateText();
        Mockito.when((Object)this.mockedPermissionProcessorRegistry.getPermissionPreProcessors()).thenReturn(Arrays.asList(this.mockedPermissionPreProcessor));
        Mockito.when((Object)this.mockedPermissionPreProcessor.process(nodeRef, perm)).thenReturn((Object)AccessStatus.DENIED);
        AccessStatus result = this.extendedPermissionServiceImpl.hasPermission(nodeRef, perm);
        Assert.assertEquals((Object)AccessStatus.DENIED, (Object)result);
        ((PermissionPreProcessor)Mockito.verify((Object)this.mockedPermissionPreProcessor)).process(nodeRef, perm);
        ((ExtendedPermissionServiceImpl)Mockito.verify((Object)this.extendedPermissionServiceImpl, (VerificationMode)Mockito.never())).hasPermissionImpl(nodeRef, perm);
    }

    @Test
    public void postProcessorRegistered() {
        NodeRef nodeRef = this.generateCmContent("anyname");
        String perm = AlfMock.generateText();
        List<String> configuredReadPermissions = Arrays.asList("ReadProperties", "ReadChildren");
        List<String> configuredFilePermissions = Arrays.asList("WriteProperties", "AddChildren");
        this.extendedPermissionServiceImpl.setConfiguredReadPermissions("ReadProperties,ReadChildren");
        this.extendedPermissionServiceImpl.setConfiguredFilePermissions("WriteProperties,AddChildren");
        Mockito.when((Object)this.mockedPermissionProcessorRegistry.getPermissionPostProcessors()).thenReturn(Arrays.asList(this.mockedPermissionPostProcessor));
        Mockito.when((Object)this.mockedPermissionPostProcessor.process(AccessStatus.UNDETERMINED, nodeRef, perm, configuredReadPermissions, configuredFilePermissions)).thenReturn((Object)AccessStatus.ALLOWED);
        AccessStatus result = this.extendedPermissionServiceImpl.hasPermission(nodeRef, perm);
        Assert.assertEquals((Object)AccessStatus.ALLOWED, (Object)result);
        ((PermissionPostProcessor)Mockito.verify((Object)this.mockedPermissionPostProcessor)).process(AccessStatus.UNDETERMINED, nodeRef, perm, configuredReadPermissions, configuredFilePermissions);
        ((ExtendedPermissionServiceImpl)Mockito.verify((Object)this.extendedPermissionServiceImpl)).hasPermissionImpl(nodeRef, perm);
    }

    @Test
    public void getReadersAndWritersForNodeWithNoOwnerAspect() {
        NodeRef nodeRef = this.generateNodeRef();
        Mockito.when((Object)this.mockedNodeService.getNodeAclId(nodeRef)).thenReturn((Object)NODE_ACL_ID);
        Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ContentModel.ASPECT_OWNABLE)).thenReturn((Object)false);
        Pair result = this.extendedPermissionServiceImplWithReaderWritersSet.getReadersAndWriters(nodeRef);
        Assert.assertEquals(READERS, (Object)result.getFirst());
        Assert.assertEquals(WRITERS, (Object)result.getSecond());
    }

    @Test
    public void getReadersAndWritersForNodeWithNoOwnerSet() {
        NodeRef nodeRef = this.generateNodeRef();
        Mockito.when((Object)this.mockedNodeService.getNodeAclId(nodeRef)).thenReturn((Object)NODE_ACL_ID);
        Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ContentModel.ASPECT_OWNABLE)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedOwnableService.getOwner(nodeRef)).thenReturn((Object)"");
        Pair result = this.extendedPermissionServiceImplWithReaderWritersSet.getReadersAndWriters(nodeRef);
        Assert.assertEquals(READERS, (Object)result.getFirst());
        Assert.assertEquals(WRITERS, (Object)result.getSecond());
    }

    @Test
    public void getReadersAndWritersForNodeWithNoOwnerValueSet() {
        NodeRef nodeRef = this.generateNodeRef();
        Mockito.when((Object)this.mockedNodeService.getNodeAclId(nodeRef)).thenReturn((Object)NODE_ACL_ID);
        Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ContentModel.ASPECT_OWNABLE)).thenReturn((Object)false);
        Mockito.when((Object)this.mockedOwnableService.getOwner(nodeRef)).thenReturn((Object)"");
        Pair result = this.extendedPermissionServiceImplWithReaderWritersSet.getReadersAndWriters(nodeRef);
        Assert.assertEquals(READERS, (Object)result.getFirst());
        Assert.assertEquals(WRITERS, (Object)result.getSecond());
    }

    @Test
    public void getReadersAndWritersForNodeWithOwner() {
        NodeRef nodeRef = this.generateNodeRef();
        Mockito.when((Object)this.mockedNodeService.getNodeAclId(nodeRef)).thenReturn((Object)NODE_ACL_ID);
        Mockito.when((Object)this.mockedNodeService.hasAspect(nodeRef, ContentModel.ASPECT_OWNABLE)).thenReturn((Object)true);
        Mockito.when((Object)this.mockedOwnableService.getOwner(nodeRef)).thenReturn((Object)OWNER);
        Mockito.when((Object)this.mockedAuthorityService.authorityExists(OWNER)).thenReturn((Object)true);
        Pair result = this.extendedPermissionServiceImplWithReaderWritersSet.getReadersAndWriters(nodeRef);
        Assert.assertEquals(READERS, (Object)result.getFirst());
        HashSet<String> writersWithOwner = new HashSet<String>(WRITERS);
        writersWithOwner.add(OWNER);
        Assert.assertEquals(writersWithOwner, (Object)result.getSecond());
    }
}

