/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.record;

import java.io.Serializable;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.InplaceRecordService;
import org.alfresco.module.org_alfresco_module_rm.security.ExtendedSecurityService;
import org.alfresco.module.org_alfresco_module_rm.util.ServiceBaseImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.ParameterCheck;

public class InplaceRecordServiceImpl
extends ServiceBaseImpl
implements InplaceRecordService,
RecordsManagementModel {
    private SiteService siteService;
    private ExtendedSecurityService extendedSecurityService;
    private FileFolderService fileFolderService;

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setExtendedSecurityService(ExtendedSecurityService extendedSecurityService) {
        this.extendedSecurityService = extendedSecurityService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    @Override
    public void hideRecord(final NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"NodeRef", (Object)nodeRef);
        this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                NodeRef originatingLocation = (NodeRef)InplaceRecordServiceImpl.this.nodeService.getProperty(nodeRef, RecordsManagementModel.PROP_RECORD_ORIGINATING_LOCATION);
                if (originatingLocation != null) {
                    List parentAssocs = InplaceRecordServiceImpl.this.nodeService.getParentAssocs(nodeRef);
                    for (ChildAssociationRef childAssociationRef : parentAssocs) {
                        if (childAssociationRef.isPrimary() || !childAssociationRef.getParentRef().equals((Object)originatingLocation) || InplaceRecordServiceImpl.this.nodeService.hasAspect(childAssociationRef.getChildRef(), ContentModel.ASPECT_PENDING_DELETE)) continue;
                        InplaceRecordServiceImpl.this.nodeService.removeChildAssociation(childAssociationRef);
                        break;
                    }
                    InplaceRecordServiceImpl.this.extendedSecurityService.remove(nodeRef);
                }
                return null;
            }
        });
    }

    @Override
    public void moveRecord(final NodeRef nodeRef, final NodeRef targetNodeRef) {
        SiteInfo targetSite;
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"targetNodeRef", (Object)targetNodeRef);
        NodeRef sourceParentNodeRef = null;
        NodeRef originatingLocation = (NodeRef)this.nodeService.getProperty(nodeRef, PROP_RECORD_ORIGINATING_LOCATION);
        for (ChildAssociationRef parentAssoc : this.nodeService.getParentAssocs(nodeRef)) {
            if (parentAssoc.isPrimary() || !parentAssoc.getParentRef().equals((Object)originatingLocation)) continue;
            sourceParentNodeRef = parentAssoc.getParentRef();
            break;
        }
        if (sourceParentNodeRef == null) {
            throw new AlfrescoRuntimeException("Could not find source parent node reference.");
        }
        SiteInfo sourceSite = this.siteService.getSite(sourceParentNodeRef);
        if (!sourceSite.equals((Object)(targetSite = this.siteService.getSite(targetNodeRef)))) {
            throw new AlfrescoRuntimeException("The record can only be moved within the same collaboration site.");
        }
        if (!sourceSite.getSitePreset().equals("site-dashboard")) {
            throw new AlfrescoRuntimeException("Only records within a collaboration site can be moved.");
        }
        final NodeRef source = sourceParentNodeRef;
        this.authenticationUtil.runAsSystem(new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                try {
                    InplaceRecordServiceImpl.this.fileFolderService.moveFrom(nodeRef, source, targetNodeRef, null);
                    InplaceRecordServiceImpl.this.nodeService.setProperty(nodeRef, RecordsManagementModel.PROP_RECORD_ORIGINATING_LOCATION, (Serializable)targetNodeRef);
                }
                catch (FileExistsException | FileNotFoundException ex) {
                    throw new AlfrescoRuntimeException("Can't move node: " + String.valueOf(ex));
                }
                return null;
            }
        });
    }
}

