/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.model.rma.aspect;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.BaseBehaviourBean;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.copy.AbstractCopyBehaviourCallback;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.annotation.Behaviour;
import org.alfresco.repo.policy.annotation.BehaviourBean;
import org.alfresco.repo.policy.annotation.BehaviourKind;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.PropertyMap;

@BehaviourBean(defaultType="rma:filePlanComponent")
public class FilePlanComponentAspect
extends BaseBehaviourBean
implements NodeServicePolicies.OnUpdatePropertiesPolicy,
NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.OnMoveNodePolicy {
    private NodeRef scriptsFolderNodeRef = new NodeRef("workspace", "SpacesStore", "rm_behavior_scripts");
    private ScriptService scriptService;
    private NamespaceService namespaceService;
    private FilePlanService filePlanService;

    public void setScriptService(ScriptService scriptService) {
        this.scriptService = scriptService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onUpdateProperties(final NodeRef nodeRef, final Map<QName, Serializable> before, final Map<QName, Serializable> after) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                if (FilePlanComponentAspect.this.nodeService.exists(nodeRef)) {
                    FilePlanComponentAspect.this.lookupAndExecuteScripts(nodeRef, before, after);
                }
                return null;
            }
        });
    }

    private void lookupAndExecuteScripts(NodeRef nodeWithChangedProperties, Map<QName, Serializable> oldProps, Map<QName, Serializable> newProps) {
        List<NodeRef> scriptRefs = this.lookupScripts(oldProps, newProps);
        HashMap<String, Object> objectModel = new HashMap<String, Object>(1);
        objectModel.put("node", nodeWithChangedProperties);
        objectModel.put("oldProperties", oldProps);
        objectModel.put("newProperties", newProps);
        for (NodeRef scriptRef : scriptRefs) {
            this.scriptService.executeScript(scriptRef, null, objectModel);
        }
    }

    private List<NodeRef> lookupScripts(Map<QName, Serializable> oldProps, Map<QName, Serializable> newProps) {
        ArrayList<NodeRef> result = new ArrayList<NodeRef>();
        Map changedProps = PropertyMap.getChangedProperties(oldProps, newProps);
        for (QName propQName : changedProps.keySet()) {
            String localName;
            QName prefixedQName = propQName.getPrefixedQName((NamespacePrefixResolver)this.namespaceService);
            String[] splitQName = QName.splitPrefixedQName((String)prefixedQName.toPrefixString());
            String shortPrefix = splitQName[0];
            String expectedScriptName = shortPrefix + "_" + (localName = splitQName[1]) + ".js";
            NodeRef nextElement = this.nodeService.getChildByName(this.scriptsFolderNodeRef, ContentModel.ASSOC_CONTAINS, expectedScriptName);
            if (nextElement == null) continue;
            result.add(nextElement);
        }
        return result;
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onAddAspect(final NodeRef nodeRef, final QName aspectTypeQName) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                if (FilePlanComponentAspect.this.nodeService.exists(nodeRef) && FilePlanComponentAspect.this.nodeService.hasAspect(nodeRef, aspectTypeQName)) {
                    NodeRef root = FilePlanComponentAspect.this.filePlanService.getFilePlan(nodeRef);
                    if (root != null) {
                        FilePlanComponentAspect.this.nodeService.setProperty(nodeRef, RecordsManagementModel.PROP_ROOT_NODEREF, (Serializable)root);
                    }
                    List renditions = FilePlanComponentAspect.this.renditionService.getRenditions(nodeRef);
                    for (ChildAssociationRef chAssRef : renditions) {
                        NodeRef rendition = chAssRef.getChildRef();
                        if (!FilePlanComponentAspect.this.nodeService.exists(rendition)) continue;
                        FilePlanComponentAspect.this.nodeService.addAspect(rendition, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT, null);
                    }
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Behaviour(kind=BehaviourKind.CLASS, notificationFrequency=Behaviour.NotificationFrequency.TRANSACTION_COMMIT)
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, final ChildAssociationRef newChildAssocRef) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() {
                if (FilePlanComponentAspect.this.nodeService.exists(newChildAssocRef.getParentRef()) && FilePlanComponentAspect.this.nodeService.exists(newChildAssocRef.getChildRef())) {
                    NodeRef root = FilePlanComponentAspect.this.filePlanService.getFilePlan(newChildAssocRef.getParentRef());
                    FilePlanComponentAspect.this.nodeService.setProperty(newChildAssocRef.getChildRef(), RecordsManagementModel.PROP_ROOT_NODEREF, (Serializable)root);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Behaviour(kind=BehaviourKind.CLASS, policy="alf:getCopyCallback")
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return new AbstractCopyBehaviourCallback(){

            public CopyBehaviourCallback.ChildAssocCopyAction getChildAssociationCopyAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyChildAssociationDetails childAssocCopyDetails) {
                return null;
            }

            public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
                NodeRef root = FilePlanComponentAspect.this.filePlanService.getFilePlan(copyDetails.getTargetParentNodeRef());
                if (root != null) {
                    properties.put(RecordsManagementModel.PROP_ROOT_NODEREF, (Serializable)root);
                }
                return properties;
            }

            public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
                return true;
            }
        };
    }
}

