/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.action;

import java.io.Serializable;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.webscripts.GUID;

public class FileReportActionTest
extends BaseRMTestCase {
    @Override
    protected boolean isUserTest() {
        return true;
    }

    public void testFileReport() {
        this.fileReport("text/html");
    }

    public void testfileReportDefaultMimetype() {
        this.fileReport(null);
    }

    private void fileReport(final String mimeType) {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        final NodeRef recordFolder = this.recordFolderService.createRecordFolder(this.rmContainer, GUID.generate());
        this.recordFolderService.closeRecordFolder(recordFolder);
        final NodeRef hold = this.holdService.createHold(this.filePlan, "holdName", "holdReason", "holdDescription");
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() throws Exception {
                FileReportActionTest.this.executeAction(mimeType, recordFolder, hold);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                FileReportActionTest.this.rmActionService.executeRecordsManagementAction(recordFolder, "openRecordFolder");
                return null;
            }

            public void test(Void result) throws Exception {
                FileReportActionTest.this.executeAction(mimeType, recordFolder, hold);
            }
        });
    }

    private void executeAction(String mimeType, NodeRef recordFolder, NodeRef hold) {
        Action action = this.actionService.createAction("fileReport");
        if (StringUtils.isNotBlank((CharSequence)mimeType)) {
            action.setParameterValue("mimetype", (Serializable)((Object)mimeType));
        }
        action.setParameterValue("destination", (Serializable)((Object)recordFolder.toString()));
        action.setParameterValue("reportType", (Serializable)((Object)"rmr:destructionReport"));
        this.actionService.executeAction(action, hold);
    }
}

