/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script;

import java.io.IOException;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.script.BaseAuditRetrievalWebScript;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.extensions.webscripts.WebScriptException;
import org.springframework.extensions.webscripts.WebScriptRequest;
import org.springframework.extensions.webscripts.WebScriptResponse;

public class AuditLogPost
extends BaseAuditRetrievalWebScript {
    private static Log logger = LogFactory.getLog(AuditLogPost.class);
    protected static final String PARAM_DESTINATION = "destination";
    protected static final String RESPONSE_SUCCESS = "success";
    protected static final String RESPONSE_RECORD = "record";
    protected static final String RESPONSE_RECORD_NAME = "recordName";
    private RecordFolderService recordFolderService;
    private DispositionService dispositionService;

    public void setRecordFolderService(RecordFolderService recordFolderService) {
        this.recordFolderService = recordFolderService;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void execute(WebScriptRequest req, WebScriptResponse res) throws IOException {
        try {
            ParameterCheck.mandatory((String)"req", (Object)req);
            ParameterCheck.mandatory((String)"res", (Object)res);
            JSONObject json = this.getJSONObjectFromRequest(req);
            NodeRef destination = this.getDestination(json);
            NodeRef record = this.fileAuditTrail(destination, req);
            String response = this.createResponse(record);
            this.writeResponse(res, response);
        }
        catch (Exception ex) {
            JSONObject json = new JSONObject();
            this.putToJSONObject(json, "message", ex.getMessage());
            this.writeResponse(res, json.toString());
        }
    }

    private void writeResponse(WebScriptResponse res, String response) throws IOException {
        res.setContentType("application/json");
        res.setContentEncoding("UTF-8");
        res.setHeader("Content-Length", Long.toString(response.length()));
        res.getWriter().write(response);
    }

    private String createResponse(NodeRef record) {
        JSONObject responseJSON = new JSONObject();
        boolean recordExists = record != null;
        this.putToJSONObject(responseJSON, RESPONSE_SUCCESS, recordExists);
        if (recordExists) {
            this.putToJSONObject(responseJSON, RESPONSE_RECORD, record.toString());
            this.putToJSONObject(responseJSON, RESPONSE_RECORD_NAME, (String)((Object)this.nodeService.getProperty(record, ContentModel.PROP_NAME)));
        }
        return responseJSON.toString();
    }

    private void putToJSONObject(JSONObject json, String key, Object value) {
        try {
            json.put(key, value);
        }
        catch (JSONException error) {
            throw new AlfrescoRuntimeException("Error writing the value '" + String.valueOf(value) + "' of the key '" + key + "' to the json object.", (Throwable)error);
        }
    }

    private NodeRef fileAuditTrail(NodeRef destination, WebScriptRequest req) {
        NodeRef record = this.rmAuditService.fileAuditTrailAsRecord(this.parseQueryParameters(req), destination, this.parseReportFormat(req));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Filed audit trail as new record: '" + String.valueOf(record) + "'."));
        }
        return record;
    }

    private JSONObject getJSONObjectFromRequest(WebScriptRequest req) throws IOException {
        JSONObject json;
        try {
            json = new JSONObject(new JSONTokener(req.getContent().getContent()));
        }
        catch (JSONException error) {
            throw new AlfrescoRuntimeException("Error creating json object from request content.", (Throwable)error);
        }
        return json;
    }

    private NodeRef getDestination(JSONObject json) {
        String destinationParam;
        if (!json.has(PARAM_DESTINATION)) {
            throw new WebScriptException(400, "Mandatory parameter 'destination' has not been supplied.");
        }
        try {
            destinationParam = json.getString(PARAM_DESTINATION);
        }
        catch (JSONException error) {
            throw new AlfrescoRuntimeException("Error extracting 'destination' from parameter.", (Throwable)error);
        }
        if (StringUtils.isBlank((CharSequence)destinationParam)) {
            throw new WebScriptException(400, "Please select a record folder.");
        }
        NodeRef destination = new NodeRef(destinationParam);
        if (!this.nodeService.exists(destination)) {
            throw new WebScriptException(404, "Selected node does not exist");
        }
        if (!RecordsManagementModel.TYPE_RECORD_FOLDER.equals((Object)this.nodeService.getType(destination))) {
            throw new WebScriptException(400, "Selected node is not a record folder");
        }
        if (this.recordFolderService.isRecordFolderClosed(destination)) {
            throw new WebScriptException(400, "Cannot file into a closed folder.");
        }
        if (this.dispositionService.isDisposableItemCutoff(destination)) {
            throw new WebScriptException(400, "Cannot file into a cut off folder.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Filing audit trail as record in record folder: '" + String.valueOf(destination) + "'."));
        }
        return destination;
    }
}

