/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.permission;

import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.model.PermissionModel;
import org.alfresco.repo.security.permissions.processor.impl.PermissionPostProcessorBaseImpl;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;

public class RecordsManagementPermissionPostProcessor
extends PermissionPostProcessorBaseImpl {
    private NodeService nodeService;
    private PermissionService permissionService;
    private PermissionModel permissionModel;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setPermissionModel(PermissionModel permissionModel) {
        this.permissionModel = permissionModel;
    }

    @Override
    public AccessStatus process(AccessStatus accessStatus, NodeRef nodeRef, String perm, List<String> configuredReadPermissions, List<String> configuredFilePermissions) {
        AccessStatus result = accessStatus;
        if (AccessStatus.DENIED.equals((Object)accessStatus) && this.nodeService.hasAspect(nodeRef, RecordsManagementModel.ASPECT_FILE_PLAN_COMPONENT)) {
            if ("Read".equals(perm) || this.isPermissionContained(perm, configuredReadPermissions)) {
                result = this.permissionService.hasPermission(nodeRef, "ReadRecords");
            } else if ("Write".equals(perm) || this.isPermissionContained(perm, configuredFilePermissions)) {
                result = this.permissionService.hasPermission(nodeRef, "FileRecords");
            }
        }
        return result;
    }

    private boolean isPermissionContained(String perm, List<String> configuredPermissions) {
        if (configuredPermissions.contains(perm)) {
            return true;
        }
        for (String configuredPermission : configuredPermissions) {
            PermissionReference permissionReference = this.permissionModel.getPermissionReference(null, configuredPermission);
            for (PermissionReference granteePermission : this.permissionModel.getGranteePermissions(permissionReference)) {
                if (!granteePermission.getName().equals(perm)) continue;
                return true;
            }
        }
        return false;
    }
}

