/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.impl;

import java.util.Arrays;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.action.RMActionExecuterAbstractBase;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class CopyMoveLinkFileToBaseAction
extends RMActionExecuterAbstractBase {
    private static Log logger = LogFactory.getLog(CopyMoveLinkFileToBaseAction.class);
    public static final String PARAM_DESTINATION_RECORD_FOLDER = "destinationRecordFolder";
    public static final String PARAM_PATH = "path";
    public static final String PARAM_CREATE_RECORD_PATH = "createRecordPath";
    public static final String ACTION_FILETO = "fileTo";
    public static final String ACTION_LINKTO = "linkTo";
    private FileFolderService fileFolderService;
    private FilePlanService filePlanService;
    private CopyMoveLinkFileToActionMode mode;

    protected CopyMoveLinkFileToActionMode getMode() {
        return this.mode;
    }

    protected void setMode(CopyMoveLinkFileToActionMode mode) {
        this.mode = mode;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add((ParameterDefinition)new ParameterDefinitionImpl(PARAM_PATH, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_PATH)));
        paramList.add((ParameterDefinition)new ParameterDefinitionImpl(PARAM_CREATE_RECORD_PATH, DataTypeDefinition.BOOLEAN, false, this.getParamDisplayLabel(PARAM_CREATE_RECORD_PATH)));
    }

    protected synchronized void executeImpl(Action action, final NodeRef actionedUponNodeRef) {
        String actionName = action.getActionDefinitionName();
        if (this.isOkToProceedWithAction(actionedUponNodeRef, actionName)) {
            QName actionedUponType = this.getNodeService().getType(actionedUponNodeRef);
            boolean targetIsUnfiledRecords = ACTION_FILETO.equals(action.getActionDefinitionName()) ? false : this.getDictionaryService().isSubClass(actionedUponType, ContentModel.TYPE_CONTENT) && !this.getRecordService().isFiled(actionedUponNodeRef) || TYPE_UNFILED_RECORD_FOLDER.equals((Object)actionedUponType);
            NodeRef recordFolder = (NodeRef)action.getParameterValue(PARAM_DESTINATION_RECORD_FOLDER);
            if (recordFolder == null) {
                recordFolder = this.createOrResolvePath(action, actionedUponNodeRef, targetIsUnfiledRecords);
            }
            this.validateActionPostPathResolution(actionedUponNodeRef, recordFolder, actionName, targetIsUnfiledRecords);
            final NodeRef finalRecordFolder = recordFolder;
            AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                public Void doWork() {
                    try {
                        if (CopyMoveLinkFileToBaseAction.this.getMode() == CopyMoveLinkFileToActionMode.MOVE) {
                            CopyMoveLinkFileToBaseAction.this.fileFolderService.move(actionedUponNodeRef, finalRecordFolder, null);
                        } else if (CopyMoveLinkFileToBaseAction.this.getMode() == CopyMoveLinkFileToActionMode.COPY) {
                            CopyMoveLinkFileToBaseAction.this.fileFolderService.copy(actionedUponNodeRef, finalRecordFolder, null);
                        } else if (CopyMoveLinkFileToBaseAction.this.getMode() == CopyMoveLinkFileToActionMode.LINK) {
                            CopyMoveLinkFileToBaseAction.this.getRecordService().link(actionedUponNodeRef, finalRecordFolder);
                        }
                    }
                    catch (FileNotFoundException fileNotFound) {
                        throw new AlfrescoRuntimeException("Unable to execute file to action, because the " + (CopyMoveLinkFileToBaseAction.this.mode == CopyMoveLinkFileToActionMode.MOVE ? "move" : "copy") + " operation failed.", (Throwable)fileNotFound);
                    }
                    return null;
                }
            });
        }
    }

    private boolean isOkToProceedWithAction(NodeRef actionedUponNodeRef, String actionName) {
        boolean okToProceed = false;
        if (this.getNodeService().exists(actionedUponNodeRef) && !this.getFreezeService().isFrozen(actionedUponNodeRef)) {
            QName actionedUponType = this.getNodeService().getType(actionedUponNodeRef);
            if (ACTION_FILETO.equals(actionName)) {
                boolean bl = okToProceed = !this.getRecordService().isFiled(actionedUponNodeRef) && this.getDictionaryService().isSubClass(actionedUponType, ContentModel.TYPE_CONTENT);
                if (!okToProceed && logger.isDebugEnabled()) {
                    logger.debug((Object)("Unable to run " + actionName + " action on a node that isn't unfiled and a sub-class of content type"));
                }
            } else if (ACTION_LINKTO.equals(actionName)) {
                boolean bl = okToProceed = this.getRecordService().isFiled(actionedUponNodeRef) && this.getDictionaryService().isSubClass(actionedUponType, ContentModel.TYPE_CONTENT);
                if (!okToProceed && logger.isDebugEnabled()) {
                    logger.debug((Object)("Unable to run " + actionName + " action on a node that isn't filed and a sub-class of content type"));
                }
            } else {
                okToProceed = true;
            }
        }
        return okToProceed;
    }

    private void validateActionPostPathResolution(NodeRef actionedUponNodeRef, NodeRef target, String actionName, boolean targetIsUnfiledRecords) {
        QName actionedUponType = this.getNodeService().getType(actionedUponNodeRef);
        if (target == null) {
            throw new AlfrescoRuntimeException("Unable to run " + actionName + " action, because the destination record folder could not be determined.");
        }
        if (targetIsUnfiledRecords) {
            QName targetFolderType = this.getNodeService().getType(target);
            if (!TYPE_UNFILED_RECORD_CONTAINER.equals((Object)targetFolderType) && !TYPE_UNFILED_RECORD_FOLDER.equals((Object)targetFolderType)) {
                throw new AlfrescoRuntimeException("Unable to run " + actionName + " action, because the destination record folder is an inappropriate type.");
            }
        } else {
            if (this.getRecordFolderService().isRecordFolder(target) && !this.getDictionaryService().isSubClass(actionedUponType, ContentModel.TYPE_CONTENT) && (this.getRecordFolderService().isRecordFolder(actionedUponNodeRef) || this.filePlanService.isRecordCategory(actionedUponNodeRef))) {
                throw new AlfrescoRuntimeException("Unable to run " + actionName + " action, because the destination record folder is an inappropriate type. A record folder cannot contain another folder or a category");
            }
            if (this.filePlanService.isRecordCategory(target) && this.getDictionaryService().isSubClass(actionedUponType, ContentModel.TYPE_CONTENT)) {
                throw new AlfrescoRuntimeException("Unable to run " + actionName + " action, because the destination record folder is an inappropriate type. A record category cannot contain a record");
            }
        }
    }

    private NodeRef createOrResolvePath(final Action action, final NodeRef actionedUponNodeRef, final boolean targetisUnfiledRecords) {
        NodeRef context;
        NodeRef path = context = this.getContext(action, actionedUponNodeRef, targetisUnfiledRecords);
        String pathParameter = (String)((Object)action.getParameterValue(PARAM_PATH));
        final String[] pathElementsArray = StringUtils.tokenizeToStringArray((String)pathParameter, (String)"/", (boolean)false, (boolean)true);
        if (pathElementsArray != null && pathElementsArray.length > 0) {
            Boolean createValue = (Boolean)action.getParameterValue(PARAM_CREATE_RECORD_PATH);
            final boolean create = createValue == null ? false : createValue;
            QName type = this.getNodeService().getType(actionedUponNodeRef);
            final boolean isRecord = this.getDictionaryService().isSubClass(type, ContentModel.TYPE_CONTENT);
            path = (NodeRef)this.getTransactionService().getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

                public NodeRef execute() throws Throwable {
                    return CopyMoveLinkFileToBaseAction.this.createOrResolvePath(action, context, actionedUponNodeRef, isRecord, Arrays.asList(pathElementsArray), targetisUnfiledRecords, create, false);
                }
            }, false, true);
        }
        return path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NodeRef createOrResolvePath(Action action, NodeRef parent, NodeRef actionedUponNodeRef, boolean isRecord, List<String> pathElements, boolean targetisUnfiledRecords, boolean create, boolean creating) {
        boolean lastPathElement;
        NodeRef nodeRef = null;
        String childName = pathElements.get(0);
        boolean bl = lastPathElement = pathElements.size() == 1;
        if (!creating) {
            nodeRef = this.getChild(parent, childName);
        }
        if (nodeRef == null) {
            if (!create) throw new AlfrescoRuntimeException("Unable to execute " + action.getActionDefinitionName() + " action, because the destination path could not be determined.");
            creating = true;
            boolean lastAsFolder = lastPathElement && isRecord;
            nodeRef = this.createChild(action, parent, childName, targetisUnfiledRecords, lastAsFolder);
        } else {
            QName nodeType = this.getNodeService().getType(nodeRef);
            if (nodeType.equals((Object)RecordsManagementModel.TYPE_HOLD_CONTAINER)) throw new AlfrescoRuntimeException("Unable to execute " + action.getActionDefinitionName() + " action, because the destination path in invalid.");
            if (nodeType.equals((Object)RecordsManagementModel.TYPE_TRANSFER_CONTAINER)) throw new AlfrescoRuntimeException("Unable to execute " + action.getActionDefinitionName() + " action, because the destination path in invalid.");
            if (nodeType.equals((Object)RecordsManagementModel.TYPE_UNFILED_RECORD_CONTAINER)) {
                throw new AlfrescoRuntimeException("Unable to execute " + action.getActionDefinitionName() + " action, because the destination path in invalid.");
            }
        }
        if (pathElements.size() <= 1) return nodeRef;
        return this.createOrResolvePath(action, nodeRef, actionedUponNodeRef, isRecord, pathElements.subList(1, pathElements.size()), targetisUnfiledRecords, create, creating);
    }

    private NodeRef getChild(NodeRef parent, String childName) {
        return this.getNodeService().getChildByName(parent, ContentModel.ASSOC_CONTAINS, childName);
    }

    private NodeRef createChild(Action action, NodeRef parent, String childName, boolean targetisUnfiledRecords, boolean lastAsFolder) {
        NodeRef child = this.getChild(parent, childName);
        if (child == null) {
            if (targetisUnfiledRecords) {
                child = this.fileFolderService.create(parent, childName, RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER).getNodeRef();
            } else if (lastAsFolder) {
                child = this.getRecordFolderService().createRecordFolder(parent, childName);
            } else {
                if (RecordsManagementModel.TYPE_RECORD_FOLDER.equals((Object)this.getNodeService().getType(parent))) {
                    throw new AlfrescoRuntimeException("Unable to execute " + action.getActionDefinitionName() + " action, because the destination path has a record category within a record folder.");
                }
                child = this.filePlanService.createRecordCategory(parent, childName);
            }
        }
        return child;
    }

    private NodeRef getContext(Action action, NodeRef actionedUponNodeRef, boolean targetisUnfiledRecords) {
        NodeRef context = this.filePlanService.getFilePlan(actionedUponNodeRef);
        if (targetisUnfiledRecords && context != null && this.getNodeService().exists(context)) {
            context = this.filePlanService.getUnfiledContainer(context);
        }
        if (context == null || !this.getNodeService().exists(context)) {
            throw new AlfrescoRuntimeException("Unable to execute " + action.getActionDefinitionName() + " action, because the path resolution context could not be determined.");
        }
        return context;
    }

    public static enum CopyMoveLinkFileToActionMode {
        COPY,
        MOVE,
        LINK;

    }
}

