/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.fileplans;

import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.RMRoles;
import org.alfresco.rm.rest.api.fileplans.FilePlanEntityResource;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.RoleModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="roles", entityResource=FilePlanEntityResource.class, title="Roles in a file plan")
public class FilePlanRolesRelation
implements RelationshipResourceAction.Read<RoleModel>,
InitializingBean {
    private RMRoles rmRoles;
    private FilePlanService filePlanService;
    private FilePlanComponentsApiUtils apiUtils;

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"rmRoles", (Object)this.rmRoles);
        ParameterCheck.mandatory((String)"apiUtils", (Object)this.apiUtils);
        ParameterCheck.mandatory((String)"filePlanService", (Object)this.filePlanService);
    }

    public CollectionWithPagingInfo<RoleModel> readAll(String filePlanId, Parameters params) {
        NodeRef filePlanNodeRef = this.getFilePlan(filePlanId);
        if (filePlanNodeRef == null) {
            throw new EntityNotFoundException(filePlanId);
        }
        return this.rmRoles.getRoles(filePlanNodeRef, params);
    }

    private NodeRef getFilePlan(String filePlanId) {
        NodeRef filePlanNodeRef = this.apiUtils.lookupAndValidateFilePlan(filePlanId);
        if (!"-filePlan-".equals(filePlanId)) {
            filePlanNodeRef = this.filePlanService.getFilePlan(filePlanNodeRef);
        }
        return filePlanNodeRef;
    }

    public void setRmRoles(RMRoles rmRoles) {
        this.rmRoles = rmRoles;
    }

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }
}

