/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.hold;

import java.util.ArrayList;
import java.util.Collections;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.script.hold.BaseHoldWebScriptWithContentUnitTest;
import org.alfresco.module.org_alfresco_module_rm.script.hold.HoldPost;
import org.alfresco.service.cmr.repository.NodeRef;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.springframework.extensions.webscripts.DeclarativeWebScript;

public class HoldPostUnitTest
extends BaseHoldWebScriptWithContentUnitTest {
    private static final String WEBSCRIPT_TEMPLATE = "alfresco/templates/webscripts/org/alfresco/rma/hold.post.json.ftl";
    @Spy
    @InjectMocks
    protected HoldPost webScript;

    protected DeclarativeWebScript getWebScript() {
        return this.webScript;
    }

    @Override
    protected String getWebScriptTemplate() {
        return WEBSCRIPT_TEMPLATE;
    }

    @Test
    public void addRecordToHolds() throws Exception {
        String content = this.buildContent(this.records, this.holds);
        JSONObject json = this.executeJSONWebScript(Collections.EMPTY_MAP, content);
        Assert.assertNotNull((Object)json);
        ((HoldService)Mockito.verify((Object)this.mockedHoldService, (VerificationMode)Mockito.times((int)1))).addToHolds(this.holds, this.records);
    }

    @Test
    public void addRecordFolderToHolds() throws Exception {
        String content = this.buildContent(this.recordFolders, this.holds);
        JSONObject json = this.executeJSONWebScript(Collections.EMPTY_MAP, content);
        Assert.assertNotNull((Object)json);
        ((HoldService)Mockito.verify((Object)this.mockedHoldService, (VerificationMode)Mockito.times((int)1))).addToHolds(this.holds, this.recordFolders);
    }

    @Test
    public void addActiveContentToHolds() throws Exception {
        String content = this.buildContent(this.activeContents, this.holds);
        JSONObject json = this.executeJSONWebScript(Collections.EMPTY_MAP, content);
        Assert.assertNotNull((Object)json);
        ((HoldService)Mockito.verify((Object)this.mockedHoldService, (VerificationMode)Mockito.times((int)1))).addToHolds(this.holds, this.activeContents);
    }

    @Test
    public void addActiveContentAndRecordsAndRecordFoldersToHolds() throws Exception {
        ArrayList<NodeRef> items = new ArrayList<NodeRef>(3);
        Collections.addAll(items, this.dmNodeRef, this.record, this.recordFolder);
        String content = this.buildContent(items, this.holds);
        JSONObject json = this.executeJSONWebScript(Collections.EMPTY_MAP, content);
        Assert.assertNotNull((Object)json);
        ((HoldService)Mockito.verify((Object)this.mockedHoldService, (VerificationMode)Mockito.times((int)1))).addToHolds(this.holds, items);
    }
}

