/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.unfiledrecordfolders;

import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.UnfiledRecordFolder;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="unfiled-record-folders", title="Unfiled Record Folders")
public class UnfiledRecordFolderEntityResource
implements EntityResourceAction.ReadById<UnfiledRecordFolder>,
EntityResourceAction.Delete,
EntityResourceAction.Update<UnfiledRecordFolder>,
InitializingBean {
    private FilePlanComponentsApiUtils apiUtils;
    private FileFolderService fileFolderService;
    private ApiNodesModelFactory nodesModelFactory;
    private TransactionService transactionService;

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"apiUtils", (Object)this.apiUtils);
        ParameterCheck.mandatory((String)"fileFolderService", (Object)this.fileFolderService);
        ParameterCheck.mandatory((String)"apiNodesModelFactory", (Object)this.nodesModelFactory);
    }

    @WebApiDescription(title="Get unfiled record folder information", description="Gets information for an unfiled record folder with id 'unfiledRecordFolderId'")
    @WebApiParam(name="unfiledRecordFolderId", title="The unfiled record folder id")
    public UnfiledRecordFolder readById(String unfiledRecordFolderId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("unfiledRecordFolderId", unfiledRecordFolderId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        String relativePath = parameters.getParameter("relativePath");
        NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(unfiledRecordFolderId, RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER, relativePath, true);
        FileInfo info = this.fileFolderService.getFileInfo(nodeRef);
        return this.nodesModelFactory.createUnfiledRecordFolder(info, parameters, null, false);
    }

    @WebApiDescription(title="Update unfiled record folder", description="Updates an unfiled record folder with id 'unfiledRecordFolderId'")
    public UnfiledRecordFolder update(String unfiledRecordFolderId, final UnfiledRecordFolder unfiledRecordFolderInfo, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("unfiledRecordFolderId", unfiledRecordFolderId);
        ParameterCheck.mandatory((String)"unfiledRecordFolderInfo", (Object)unfiledRecordFolderInfo);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        final NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(unfiledRecordFolderId, RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                UnfiledRecordFolderEntityResource.this.apiUtils.updateNode(nodeRef, unfiledRecordFolderInfo, parameters);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)callback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<FileInfo> readCallback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

            public FileInfo execute() {
                return UnfiledRecordFolderEntityResource.this.fileFolderService.getFileInfo(nodeRef);
            }
        };
        FileInfo info = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)readCallback, false, true);
        this.apiUtils.postActivity(info, unfiledRecordFolderInfo.getParentId(), "org.alfresco.documentlibrary.file-updated");
        return this.nodesModelFactory.createUnfiledRecordFolder(info, parameters, null, false);
    }

    @WebApiDescription(title="Delete unfiled record folder", description="Deletes an unfiled record folder with id 'unfiledRecordFolderId'")
    public void delete(String unfiledRecordFolderId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("unfiledRecordFolderId", unfiledRecordFolderId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(unfiledRecordFolderId, RecordsManagementModel.TYPE_UNFILED_RECORD_FOLDER);
        this.fileFolderService.delete(nodeRef);
    }
}

