/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.parameter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.admin.RecordsManagementAdminService;
import org.alfresco.repo.action.parameter.ParameterProcessor;
import org.alfresco.repo.action.parameter.ParameterSubstitutionSuggester;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.lang3.ArrayUtils;

public class NodeParameterProcessor
extends ParameterProcessor
implements ParameterSubstitutionSuggester {
    private QName[] supportedDataTypes = new QName[]{DataTypeDefinition.TEXT, DataTypeDefinition.BOOLEAN, DataTypeDefinition.DATE, DataTypeDefinition.DATETIME, DataTypeDefinition.DOUBLE, DataTypeDefinition.FLOAT, DataTypeDefinition.INT, DataTypeDefinition.MLTEXT};
    private int maximumNumberSuggestions = 10;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private DictionaryService dictionaryService;
    private RecordsManagementAdminService recordsManagementAdminService;
    private List<QName> suggestionDefinitions = null;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setRecordsManagementAdminService(RecordsManagementAdminService recordsManagementAdminService) {
        this.recordsManagementAdminService = recordsManagementAdminService;
    }

    @Override
    public String process(String value, NodeRef actionedUponNodeRef) {
        String result = value;
        if (!(value = this.stripName(value)).isEmpty()) {
            QName qname = QName.createQName((String)value, (NamespacePrefixResolver)this.namespaceService);
            PropertyDefinition propertyDefinition = this.dictionaryService.getProperty(qname);
            if (propertyDefinition == null) {
                throw new AlfrescoRuntimeException("The property " + value + " does not have a property definition.");
            }
            QName type = propertyDefinition.getDataType().getName();
            if (ArrayUtils.contains((Object[])this.supportedDataTypes, (Object)type)) {
                Serializable propertyValue = this.nodeService.getProperty(actionedUponNodeRef, qname);
                result = propertyValue != null ? propertyValue.toString() : "";
            } else {
                throw new AlfrescoRuntimeException("The property " + value + " is of type " + type.toString() + " which is not supported by parameter substitution.");
            }
        }
        return result;
    }

    public void setMaximumNumberSuggestions(int maximumNumberSuggestions) {
        this.maximumNumberSuggestions = maximumNumberSuggestions <= 0 ? 10 : maximumNumberSuggestions;
    }

    public void addSuggestionDefinition(QName definition) {
        if (this.suggestionDefinitions == null) {
            this.suggestionDefinitions = Collections.synchronizedList(new ArrayList());
        }
        this.suggestionDefinitions.add(definition);
    }

    @Override
    public List<String> getSubstitutionSuggestions(String substitutionFragment) {
        Set<String> suggestionSet = Collections.synchronizedSet(new HashSet());
        if (this.suggestionDefinitions != null) {
            for (QName definition : this.suggestionDefinitions) {
                if (this.getSubstitutionSuggestions(definition, substitutionFragment.toLowerCase(), suggestionSet)) break;
            }
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        suggestions.addAll(suggestionSet);
        Collections.sort(suggestions);
        return suggestions;
    }

    private boolean getSubstitutionSuggestions(QName definitionName, String substitutionFragment, Set<String> suggestions) {
        boolean gotMaximumSuggestions = false;
        AspectDefinition definition = this.dictionaryService.getAspect(definitionName);
        if (definition == null) {
            definition = this.dictionaryService.getType(definitionName);
        }
        if (definition != null) {
            gotMaximumSuggestions = this.getSubstitutionSuggestionsForDefinition((ClassDefinition)definition, substitutionFragment, suggestions);
        }
        if (this.recordsManagementAdminService.isCustomisable(definitionName) && !gotMaximumSuggestions) {
            gotMaximumSuggestions = this.processPropertyDefinitions(this.recordsManagementAdminService.getCustomPropertyDefinitions(definitionName), substitutionFragment, suggestions);
        }
        return gotMaximumSuggestions;
    }

    private boolean getSubstitutionSuggestionsForDefinition(ClassDefinition definition, String substitutionFragment, Set<String> suggestions) {
        boolean gotMaximumSuggestions;
        block1: {
            QName defaultAspect;
            gotMaximumSuggestions = this.processPropertyDefinitions(definition.getProperties(), substitutionFragment, suggestions);
            if (gotMaximumSuggestions) break block1;
            Iterator iterator = definition.getDefaultAspectNames().iterator();
            while (iterator.hasNext() && !(gotMaximumSuggestions = this.getSubstitutionSuggestions(defaultAspect = (QName)iterator.next(), substitutionFragment, suggestions))) {
            }
        }
        return gotMaximumSuggestions;
    }

    private boolean processPropertyDefinitions(Map<QName, PropertyDefinition> properties, String substitutionFragment, Set<String> suggestions) {
        boolean gotMaximumSuggestions = false;
        if (properties != null) {
            for (Map.Entry<QName, PropertyDefinition> entry : properties.entrySet()) {
                String suggestion;
                PropertyDefinition propertyDefinition = entry.getValue();
                QName type = propertyDefinition.getDataType().getName();
                if (!ArrayUtils.contains((Object[])this.supportedDataTypes, (Object)type) || !(suggestion = this.getName() + "." + entry.getKey().getPrefixString()).toLowerCase().contains(substitutionFragment)) continue;
                if (suggestions.size() < this.maximumNumberSuggestions) {
                    suggestions.add(suggestion);
                    continue;
                }
                gotMaximumSuggestions = true;
                break;
            }
        }
        return gotMaximumSuggestions;
    }
}

