/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action;

import java.util.Calendar;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.action.RecordsManagementActionService;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ScheduledDispositionJob
implements Job {
    private static Log logger = LogFactory.getLog(ScheduledDispositionJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        RecordsManagementActionService rmActionService = (RecordsManagementActionService)context.getJobDetail().getJobDataMap().get((Object)"recordsManagementActionService");
        NodeService nodeService = (NodeService)context.getJobDetail().getJobDataMap().get((Object)"nodeService");
        Calendar cal = Calendar.getInstance();
        String year = String.valueOf(cal.get(1));
        String month = String.valueOf(cal.get(2) + 1);
        String dayOfMonth = String.valueOf(cal.get(5));
        String currentDate = this.padString(year, 2) + "-" + this.padString(month, 2) + "-" + this.padString(dayOfMonth, 2) + "T00:00:00.00Z";
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Executing ").append(this.getClass().getSimpleName()).append(" with currentDate ").append(currentDate);
            logger.debug((Object)msg.toString());
        }
        String dateRange = "[\"1970-01-01T00:00:00.00Z\" TO \"" + currentDate + "\"]";
        String query = "+ASPECT:\"rma:record\" +ASPECT:\"rma:dispositionSchedule\" +@rma\\:dispositionAsOf:" + dateRange;
        SearchService search = (SearchService)context.getJobDetail().getJobDataMap().get((Object)"searchService");
        ResultSet results = search.query(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "fts-alfresco", query);
        List resultNodes = results.getNodeRefs();
        results.close();
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Found ").append(resultNodes.size()).append(" records eligible for disposition.");
            logger.debug((Object)msg.toString());
        }
        for (NodeRef node : resultNodes) {
            String dispActionName = (String)((Object)nodeService.getProperty(node, RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME));
            if (dispActionName == null || !dispActionName.equalsIgnoreCase("cutoff")) continue;
            rmActionService.executeRecordsManagementAction(node, dispActionName);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Performing " + dispActionName + " dispoition action on disposable item " + node.toString()));
        }
    }

    private String padString(String s, int len) {
        Object result = s;
        for (int i = 0; i < len - s.length(); ++i) {
            result = "0" + (String)result;
        }
        return result;
    }
}

