/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.security;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.security.RMMethodSecurityPostProcessor;
import org.junit.Assert;
import org.junit.Test;

public class RMMethodSecurityPostProcessorUnitTest {
    private RMMethodSecurityPostProcessor rmMethodSecurityPostProcessor = new RMMethodSecurityPostProcessor();

    @Test
    public void testConvertToMap_emptyString() {
        Map actual = this.rmMethodSecurityPostProcessor.convertToMap("");
        Assert.assertEquals((String)"Unexpectedly included empty string in output.", Collections.emptyMap(), (Object)actual);
    }

    @Test
    public void testConvertToMap_normalPairs() {
        Map actual = this.rmMethodSecurityPostProcessor.convertToMap("a=b\nc=d");
        Assert.assertEquals((String)"Failed to handle multiline input string.", (Object)ImmutableMap.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"), (Object)actual);
    }

    @Test
    public void testConvertToMap_stripWhitespace() {
        Map actual = this.rmMethodSecurityPostProcessor.convertToMap(" \n \t a=b \n \t ");
        Assert.assertEquals((String)"Failed to strip whitespace.", (Object)ImmutableMap.of((Object)"a", (Object)"b"), (Object)actual);
    }

    @Test
    public void testConvertToMap_ignoreBlankLine() {
        Map actual = this.rmMethodSecurityPostProcessor.convertToMap("a=b\n\nc=d");
        Assert.assertEquals((String)"Failed to ignore blank line.", (Object)ImmutableMap.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"), (Object)actual);
    }

    @Test
    public void testConvertToMap_multipleEquals() {
        Map actual = this.rmMethodSecurityPostProcessor.convertToMap("a=b=c\nd=e=f");
        Assert.assertEquals((String)"Issue with handling of = symbol in value.", (Object)ImmutableMap.of((Object)"a", (Object)"b=c", (Object)"d", (Object)"e=f"), (Object)actual);
    }

    @Test(expected=AlfrescoRuntimeException.class)
    public void testConvertToMap_missingEquals() {
        this.rmMethodSecurityPostProcessor.convertToMap("a=b\ncd");
    }
}

