/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.fileplans;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.resource.RelationshipResource;
import org.alfresco.rest.framework.resource.actions.interfaces.RelationshipResourceAction;
import org.alfresco.rest.framework.resource.parameters.CollectionWithPagingInfo;
import org.alfresco.rest.framework.resource.parameters.Paging;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.fileplans.FilePlanEntityResource;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.HoldModel;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@RelationshipResource(name="holds", entityResource=FilePlanEntityResource.class, title="Holds in a file plan")
public class FilePlanHoldsRelation
implements RelationshipResourceAction.Create<HoldModel>,
RelationshipResourceAction.Read<HoldModel>,
InitializingBean {
    private FilePlanComponentsApiUtils apiUtils;
    private ApiNodesModelFactory nodesModelFactory;
    private HoldService holdService;
    private FileFolderService fileFolderService;
    private TransactionService transactionService;

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"apiUtils", (Object)this.apiUtils);
        ParameterCheck.mandatory((String)"nodesModelFactory", (Object)this.nodesModelFactory);
        ParameterCheck.mandatory((String)"holdService", (Object)this.holdService);
        ParameterCheck.mandatory((String)"fileFolderService", (Object)this.fileFolderService);
        ParameterCheck.mandatory((String)"transactionService", (Object)this.transactionService);
    }

    @WebApiDescription(title="Return a paged list of holds for the file plan identified by 'filePlanId'")
    public CollectionWithPagingInfo<HoldModel> readAll(String filePlanId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("filePlanId", filePlanId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef parentNodeRef = this.apiUtils.lookupAndValidateFilePlan(filePlanId);
        List<NodeRef> holds = this.holdService.getHolds(parentNodeRef);
        List page = holds.stream().map(hold -> this.fileFolderService.getFileInfo(hold)).map(this.nodesModelFactory::createHoldModel).skip(parameters.getPaging().getSkipCount()).limit(parameters.getPaging().getMaxItems()).collect(Collectors.toCollection(LinkedList::new));
        int totalItems = holds.size();
        boolean hasMore = parameters.getPaging().getSkipCount() + parameters.getPaging().getMaxItems() < totalItems;
        return CollectionWithPagingInfo.asPaged((Paging)parameters.getPaging(), (Collection)page, (boolean)hasMore, (Integer)totalItems);
    }

    @WebApiDescription(title="Create one (or more) holds in a file plan identified by 'filePlanId'")
    public List<HoldModel> create(String filePlanId, List<HoldModel> holds, Parameters parameters) {
        RMParameterCheck.checkNotBlank("filePlanId", filePlanId);
        ParameterCheck.mandatory((String)"holds", holds);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        NodeRef parentNodeRef = this.apiUtils.lookupAndValidateFilePlan(filePlanId);
        RetryingTransactionHelper.RetryingTransactionCallback callback = () -> {
            LinkedList<NodeRef> createdNodes = new LinkedList<NodeRef>();
            for (HoldModel nodeInfo : holds) {
                NodeRef newNodeRef = this.holdService.createHold(parentNodeRef, nodeInfo.name(), nodeInfo.reason(), nodeInfo.description());
                createdNodes.add(newNodeRef);
            }
            return createdNodes;
        };
        List createdNodes = (List)this.transactionService.getRetryingTransactionHelper().doInTransaction(callback, false, true);
        return createdNodes.stream().map(hold -> this.fileFolderService.getFileInfo(hold)).map(this.nodesModelFactory::createHoldModel).collect(Collectors.toCollection(LinkedList::new));
    }

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setHoldService(HoldService holdService) {
        this.holdService = holdService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }
}

