/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.script.hold;

import java.util.Collections;
import java.util.Map;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.hold.HoldService;
import org.alfresco.module.org_alfresco_module_rm.script.hold.BaseHoldWebScriptUnitTest;
import org.alfresco.module.org_alfresco_module_rm.script.hold.HoldsGet;
import org.alfresco.module.org_alfresco_module_rm.test.util.WebScriptExceptionMatcher;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.hamcrest.Matcher;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.InjectMocks;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.springframework.extensions.webscripts.DeclarativeWebScript;
import org.springframework.extensions.webscripts.WebScriptException;

public class HoldsGetUnitTest
extends BaseHoldWebScriptUnitTest {
    private static final String WEBSCRIPT_TEMPLATE = "alfresco/templates/webscripts/org/alfresco/rma/holds.get.json.ftl";
    @Spy
    @InjectMocks
    protected HoldsGet webScript;

    protected DeclarativeWebScript getWebScript() {
        return this.webScript;
    }

    @Override
    protected String getWebScriptTemplate() {
        return WEBSCRIPT_TEMPLATE;
    }

    @Test
    public void invalidFilePlan() throws Exception {
        Map<String, String> parameters = this.buildParameters("store_type", this.filePlan.getStoreRef().getProtocol(), "store_id", this.filePlan.getStoreRef().getIdentifier(), "id", "imadethisup");
        this.exception.expect(WebScriptException.class);
        this.exception.expect((Matcher)WebScriptExceptionMatcher.fileNotFound());
        this.executeWebScript(parameters);
    }

    @Test
    public void defaultFilePlanDoesNotExist() throws Exception {
        this.exception.expect(WebScriptException.class);
        this.exception.expect((Matcher)WebScriptExceptionMatcher.fileNotFound());
        this.executeWebScript(Collections.EMPTY_MAP);
    }

    @Test
    public void getHoldsForFilePlan() throws Exception {
        ((HoldService)Mockito.doReturn((Object)this.holds).when((Object)this.mockedHoldService)).getHolds(this.filePlan);
        Map<String, String> parameters = this.buildParameters("store_type", this.filePlan.getStoreRef().getProtocol(), "store_id", this.filePlan.getStoreRef().getIdentifier(), "id", this.filePlan.getId());
        JSONObject json = this.executeJSONWebScript(parameters);
        Assert.assertNotNull((Object)json);
        this.testForBothHolds(json);
    }

    @Test
    public void getHoldsForDefaultFilePlan() throws Exception {
        ((HoldService)Mockito.doReturn((Object)this.holds).when((Object)this.mockedHoldService)).getHolds(this.filePlan);
        ((FilePlanService)Mockito.doReturn((Object)this.filePlan).when((Object)this.mockedFilePlanService)).getFilePlanBySiteId("rm");
        JSONObject json = this.executeJSONWebScript(Collections.EMPTY_MAP);
        Assert.assertNotNull((Object)json);
        this.testForBothHolds(json);
    }

    @Test
    public void getHoldsThatNodeRefIsHeldBy() throws Exception {
        ((HoldService)Mockito.doReturn((Object)this.holds).when((Object)this.mockedHoldService)).heldBy(this.record, true);
        Map<String, String> parameters = this.buildParameters("store_type", this.filePlan.getStoreRef().getProtocol(), "store_id", this.filePlan.getStoreRef().getIdentifier(), "id", this.filePlan.getId(), "itemNodeRef", this.record.toString());
        JSONObject json = this.executeJSONWebScript(parameters);
        Assert.assertNotNull((Object)json);
        this.testForBothHolds(json);
    }

    @Test
    public void getHoldsThatNodeRefIsNotHeldBy() throws Exception {
        ((HoldService)Mockito.doReturn((Object)this.holds).when((Object)this.mockedHoldService)).heldBy(this.record, false);
        Map<String, String> parameters = this.buildParameters("store_type", this.filePlan.getStoreRef().getProtocol(), "store_id", this.filePlan.getStoreRef().getIdentifier(), "id", this.filePlan.getId(), "itemNodeRef", this.record.toString(), "includedInHold", "false");
        JSONObject json = this.executeJSONWebScript(parameters);
        Assert.assertNotNull((Object)json);
        this.testForBothHolds(json);
    }

    @Test
    public void getHoldsThatActiveContentIsHeldBy() throws Exception {
        ((HoldService)Mockito.doReturn((Object)this.holds).when((Object)this.mockedHoldService)).heldBy(this.dmNodeRef, true);
        Map<String, String> parameters = this.buildParameters("store_type", this.filePlan.getStoreRef().getProtocol(), "store_id", this.filePlan.getStoreRef().getIdentifier(), "id", this.filePlan.getId(), "itemNodeRef", this.dmNodeRef.toString());
        JSONObject json = this.executeJSONWebScript(parameters);
        Assert.assertNotNull((Object)json);
        this.testForBothHolds(json);
    }

    @Test
    public void getHoldsThatActiveContentIsNotHeldBy() throws Exception {
        ((HoldService)Mockito.doReturn((Object)this.holds).when((Object)this.mockedHoldService)).heldBy(this.dmNodeRef, false);
        Map<String, String> parameters = this.buildParameters("store_type", this.filePlan.getStoreRef().getProtocol(), "store_id", this.filePlan.getStoreRef().getIdentifier(), "id", this.filePlan.getId(), "itemNodeRef", this.dmNodeRef.toString(), "includedInHold", "false");
        JSONObject json = this.executeJSONWebScript(parameters);
        Assert.assertNotNull((Object)json);
        this.testForBothHolds(json);
    }

    public void getFileOnlyHolds() throws Exception {
        ((PermissionService)Mockito.doReturn((Object)AccessStatus.ALLOWED).when((Object)this.mockedPermissionService)).hasPermission(this.hold1NodeRef, "Filing");
        ((PermissionService)Mockito.doReturn((Object)AccessStatus.DENIED).when((Object)this.mockedPermissionService)).hasPermission(this.hold2NodeRef, "Filing");
        Map<String, String> parameters = this.buildParameters("store_type", this.filePlan.getStoreRef().getProtocol(), "store_id", this.filePlan.getStoreRef().getIdentifier(), "id", this.filePlan.getId(), "itemNodeRef", this.record.toString(), "includedInHold", "false", "fileOnly", "true");
        JSONObject json = this.executeJSONWebScript(parameters);
        Assert.assertNotNull((Object)json);
        Assert.assertTrue((boolean)json.has("data"));
        Assert.assertTrue((boolean)json.getJSONObject("data").has("holds"));
        JSONArray jsonHolds = json.getJSONObject("data").getJSONArray("holds");
        Assert.assertNotNull((Object)jsonHolds);
        Assert.assertEquals((long)1L, (long)jsonHolds.length());
        JSONObject hold1 = jsonHolds.getJSONObject(0);
        Assert.assertNotNull((Object)hold1);
        Assert.assertEquals((Object)"hold1", (Object)hold1.getString("name"));
        Assert.assertEquals((Object)this.hold1NodeRef.toString(), (Object)hold1.getString("nodeRef"));
    }

    private void testForBothHolds(JSONObject json) throws Exception {
        Assert.assertTrue((boolean)json.has("data"));
        Assert.assertTrue((boolean)json.getJSONObject("data").has("holds"));
        JSONArray jsonHolds = json.getJSONObject("data").getJSONArray("holds");
        Assert.assertNotNull((Object)jsonHolds);
        Assert.assertEquals((long)2L, (long)jsonHolds.length());
        JSONObject hold1 = jsonHolds.getJSONObject(0);
        Assert.assertNotNull((Object)hold1);
        Assert.assertEquals((Object)"hold1", (Object)hold1.getString("name"));
        Assert.assertEquals((Object)this.hold1NodeRef.toString(), (Object)hold1.getString("nodeRef"));
        JSONObject hold2 = jsonHolds.getJSONObject(1);
        Assert.assertNotNull((Object)hold2);
        Assert.assertEquals((Object)"hold2", (Object)hold2.getString("name"));
        Assert.assertEquals((Object)this.hold2NodeRef.toString(), (Object)hold2.getString("nodeRef"));
    }
}

