/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.GUID;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.junit.Assert;
import org.springframework.dao.ConcurrencyFailureException;

public class ExtendedSecurityServiceImplTest
extends BaseRMTestCase {
    private NodeRef record;
    private NodeRef recordToo;
    private NodeRef moveRecordCategory;
    private NodeRef moveRecordFolder;

    @Override
    protected boolean isUserTest() {
        return true;
    }

    @Override
    protected void setupTestDataImpl() {
        super.setupTestDataImpl();
        this.record = this.utils.createRecord(this.rmFolder, "record.txt");
        this.recordToo = this.utils.createRecord(this.rmFolder, "recordToo.txt");
        this.moveRecordCategory = this.filePlanService.createRecordCategory(this.filePlan, "moveRecordCategory");
        this.moveRecordFolder = this.recordFolderService.createRecordFolder(this.moveRecordCategory, "moveRecordFolder");
    }

    private String createTestUser() {
        return (String)this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<String>(){

            public String run() {
                String userName = GUID.generate();
                ExtendedSecurityServiceImplTest.this.createPerson(userName);
                return userName;
            }
        }, AuthenticationUtil.getSystemUserName());
    }

    private String createTestGroup() {
        return (String)this.doTestInTransaction((RetryingTransactionHelperTestCase.Test)new RetryingTransactionHelperTestCase.Test<String>(){

            public String run() {
                String groupName = GUID.generate();
                return ExtendedSecurityServiceImplTest.this.authorityService.createAuthority(AuthorityType.GROUP, groupName);
            }
        }, AuthenticationUtil.getSystemUserName());
    }

    public void testExtendedSecurity() {
        final String monkey = this.createTestUser();
        final String elephant = this.createTestUser();
        final String snake = this.createTestUser();
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.filePlan));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.rmContainer));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.rmFolder));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.record));
                TestCase.assertTrue((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.getReaders(ExtendedSecurityServiceImplTest.this.record).isEmpty());
                TestCase.assertTrue((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.getWriters(ExtendedSecurityServiceImplTest.this.record).isEmpty());
                HashSet<String> extendedReaders = new HashSet<String>(2);
                extendedReaders.add(monkey);
                extendedReaders.add(elephant);
                ExtendedSecurityServiceImplTest.this.extendedSecurityService.set(ExtendedSecurityServiceImplTest.this.record, extendedReaders, null);
                ExtendedSecurityServiceImplTest.this.checkExtendedReaders(ExtendedSecurityServiceImplTest.this.record, extendedReaders);
                HashSet<String> extendedReadersToo = new HashSet<String>(2);
                extendedReadersToo.add(monkey);
                extendedReadersToo.add(snake);
                ExtendedSecurityServiceImplTest.this.extendedSecurityService.set(ExtendedSecurityServiceImplTest.this.recordToo, extendedReadersToo, null);
                ExtendedSecurityServiceImplTest.this.checkExtendedReaders(ExtendedSecurityServiceImplTest.this.recordToo, extendedReadersToo);
                ExtendedSecurityServiceImplTest.this.extendedSecurityService.remove(ExtendedSecurityServiceImplTest.this.recordToo);
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.recordToo));
                TestCase.assertTrue((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.getReaders(ExtendedSecurityServiceImplTest.this.recordToo).isEmpty());
                TestCase.assertTrue((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.getWriters(ExtendedSecurityServiceImplTest.this.recordToo).isEmpty());
                return null;
            }
        });
    }

    public void testMove() {
        final String monkey = this.createTestUser();
        final String elephant = this.createTestUser();
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){
            Set<String> extendedReaders;
            {
                super((RetryingTransactionHelperTestCase)ExtendedSecurityServiceImplTest.this);
                this.extendedReaders = new HashSet<String>(2);
            }

            public Void run() throws Exception {
                this.extendedReaders.add(monkey);
                this.extendedReaders.add(elephant);
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.filePlan));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.rmContainer));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.rmFolder));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.record));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.moveRecordCategory));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.moveRecordFolder));
                TestCase.assertTrue((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.getReaders(ExtendedSecurityServiceImplTest.this.record).isEmpty());
                ExtendedSecurityServiceImplTest.this.extendedSecurityService.set(ExtendedSecurityServiceImplTest.this.record, this.extendedReaders, null);
                ExtendedSecurityServiceImplTest.this.checkExtendedReaders(ExtendedSecurityServiceImplTest.this.record, this.extendedReaders);
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.moveRecordCategory));
                TestCase.assertFalse((boolean)ExtendedSecurityServiceImplTest.this.extendedSecurityService.hasExtendedSecurity(ExtendedSecurityServiceImplTest.this.moveRecordFolder));
                ExtendedSecurityServiceImplTest.this.fileFolderService.move(ExtendedSecurityServiceImplTest.this.record, ExtendedSecurityServiceImplTest.this.moveRecordFolder, "movedRecord");
                return null;
            }

            public void test(Void result) throws Exception {
                ExtendedSecurityServiceImplTest.this.checkExtendedReaders(ExtendedSecurityServiceImplTest.this.record, this.extendedReaders);
            }
        });
    }

    private void checkExtendedReaders(NodeRef nodeRef, Set<String> testReaders) {
        ExtendedSecurityServiceImplTest.assertTrue((boolean)this.extendedSecurityService.hasExtendedSecurity(nodeRef));
        Set readers = this.extendedSecurityService.getReaders(nodeRef);
        ExtendedSecurityServiceImplTest.assertNotNull((Object)readers);
        ExtendedSecurityServiceImplTest.assertEquals(testReaders, (Object)readers);
    }

    public void testDifferentUsersDifferentPermissions() {
        final String userNone = this.createTestUser();
        final String userRead = this.createTestUser();
        final String userWrite = this.createTestUser();
        final String siteShortName = GUID.generate();
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                ExtendedSecurityServiceImplTest.this.siteService.createSite(null, siteShortName, "test", "test", SiteVisibility.PRIVATE);
                return null;
            }
        });
        final NodeRef documentLibrary = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                ExtendedSecurityServiceImplTest.this.siteService.setMembership(siteShortName, userRead, "SiteConsumer");
                ExtendedSecurityServiceImplTest.this.siteService.setMembership(siteShortName, userWrite, "SiteCollaborator");
                return ExtendedSecurityServiceImplTest.this.siteService.createContainer(siteShortName, "documentLibrary", null, null);
            }
        });
        final NodeRef record = this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() throws Exception {
                NodeRef record = ExtendedSecurityServiceImplTest.this.fileFolderService.create(documentLibrary, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                ExtendedSecurityServiceImplTest.this.recordService.createRecord(ExtendedSecurityServiceImplTest.this.filePlan, record);
                return record;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "ReadRecords"));
                        TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "Filing"));
                        return null;
                    }
                }, (String)userNone);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "ReadRecords"));
                        TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "Filing"));
                        return null;
                    }
                }, (String)userRead);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "ReadRecords"));
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "Filing"));
                        return null;
                    }
                }, (String)userWrite);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "ReadRecords"));
                        TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "Filing"));
                        return null;
                    }
                }, (String)userNone);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "ReadRecords"));
                        TestCase.assertEquals((Object)AccessStatus.DENIED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "Filing"));
                        return null;
                    }
                }, (String)userRead);
                AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "ReadRecords"));
                        TestCase.assertEquals((Object)AccessStatus.ALLOWED, (Object)ExtendedSecurityServiceImplTest.this.permissionService.hasPermission(record, "Filing"));
                        return null;
                    }
                }, (String)userWrite);
                return null;
            }
        });
    }

    public void testConcurrentSetWithRetry() {
        HashSet<String> extendedReaders = new HashSet<String>(2);
        HashSet<String> extendedWriters = new HashSet<String>(2);
        Set<NodeRef> documents = this.setupConcurrentTestCase(10, extendedReaders, extendedWriters);
        this.fireParallelExecutionOfSetExtendedSecurity(documents, extendedReaders, extendedWriters, true);
        this.verifyCreatedGroups(documents, false);
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void testConcurrentSetWithoutRetry() {
        HashSet<String> extendedReaders = new HashSet<String>(2);
        HashSet<String> extendedWriters = new HashSet<String>(2);
        Set<NodeRef> documents = this.setupConcurrentTestCase(10, extendedReaders, extendedWriters);
        Assert.assertThrows(ConcurrencyFailureException.class, () -> this.fireParallelExecutionOfSetExtendedSecurity(documents, extendedReaders, extendedWriters, false));
        this.verifyCreatedGroups(documents, true);
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    public void testInexistentGroup() {
        HashSet<String> extendedReaders = new HashSet<String>(2);
        HashSet<String> extendedWriters = new HashSet<String>(2);
        String existingGroup = this.createTestGroup();
        String owner = this.createTestUser();
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        extendedReaders.add("GROUP_NON_EXISTENT");
        extendedReaders.add(existingGroup);
        extendedWriters.add("GROUP_NON_EXISTENT");
        extendedWriters.add(existingGroup);
        NodeRef documentLib = this.createSite(new HashSet<String>(), new HashSet<String>());
        Set<NodeRef> docs = this.createRecords(2, documentLib, owner);
        for (NodeRef doc : docs) {
            this.setPermissionsAndExtendedSecurity(doc, extendedReaders, extendedWriters);
        }
        this.verifyCreatedGroups(docs, false);
        AuthenticationUtil.clearCurrentSecurityContext();
    }

    private void setPermissionsAndExtendedSecurity(final NodeRef doc, final Set<String> extendedReaders, final Set<String> extendedWriters) {
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                for (String reader : extendedReaders) {
                    ExtendedSecurityServiceImplTest.this.permissionService.setPermission(doc, reader, "Consumer", true);
                }
                for (String writer : extendedWriters) {
                    ExtendedSecurityServiceImplTest.this.permissionService.setPermission(doc, writer, "Contributor", true);
                }
                ExtendedSecurityServiceImplTest.this.extendedSecurityService.set(doc, extendedReaders, extendedWriters);
                return null;
            }
        }, false, true);
    }

    private Set<NodeRef> setupConcurrentTestCase(int concurrentThreads, Set<String> extendedReaders, Set<String> extendedWriters) {
        String usera = this.createTestUser();
        String userb = this.createTestUser();
        String owner = this.createTestUser();
        extendedReaders.add(usera);
        extendedReaders.add(userb);
        extendedWriters.add(usera);
        extendedWriters.add(userb);
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        NodeRef documentLib = this.createSite(new HashSet<String>(), new HashSet<String>());
        return this.createRecords(concurrentThreads, documentLib, owner);
    }

    private NodeRef createSite(final Set<String> readers, final Set<String> writers) {
        return (NodeRef)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            public NodeRef execute() throws Throwable {
                String siteShortName = GUID.generate();
                ExtendedSecurityServiceImplTest.this.siteService.createSite(null, siteShortName, "test", "test", SiteVisibility.PRIVATE);
                readers.forEach(reader -> ExtendedSecurityServiceImplTest.this.siteService.setMembership(siteShortName, reader, "SiteConsumer"));
                writers.forEach(writer -> ExtendedSecurityServiceImplTest.this.siteService.setMembership(siteShortName, writer, "SiteCollaborator"));
                return ExtendedSecurityServiceImplTest.this.siteService.createContainer(siteShortName, "documentLibrary", null, null);
            }
        }, false, true);
    }

    private Set<NodeRef> createRecords(final int numRecords, final NodeRef parent, final String owner) {
        return (Set)this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Set<NodeRef>>(){

            public Set<NodeRef> execute() throws Throwable {
                HashSet<NodeRef> documents = new HashSet<NodeRef>();
                for (int createdRecords = 0; createdRecords < numRecords; ++createdRecords) {
                    NodeRef doc = ExtendedSecurityServiceImplTest.this.fileFolderService.create(parent, GUID.generate(), ContentModel.TYPE_CONTENT).getNodeRef();
                    ExtendedSecurityServiceImplTest.this.ownableService.setOwner(doc, owner);
                    ExtendedSecurityServiceImplTest.this.recordService.createRecord(ExtendedSecurityServiceImplTest.this.filePlan, doc, ExtendedSecurityServiceImplTest.this.rmFolder, true);
                    ExtendedSecurityServiceImplTest.this.recordService.file(doc);
                    ExtendedSecurityServiceImplTest.this.recordService.complete(doc);
                    documents.add(doc);
                }
                return documents;
            }
        }, false, true);
    }

    private void setExtendedSecurity(final NodeRef doc, final Set<String> readers, final Set<String> writers, boolean useRetry) {
        if (!useRetry) {
            this.setExtendedSecurity(doc, readers, writers);
            return;
        }
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ExtendedSecurityServiceImplTest.this.setExtendedSecurity(doc, readers, writers);
                return null;
            }
        }, false, true);
    }

    private void setExtendedSecurity(NodeRef doc, Set<String> readers, Set<String> writers) {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        this.extendedSecurityService.set(doc, readers, writers);
    }

    private void fireParallelExecutionOfSetExtendedSecurity(Set<NodeRef> documents, Set<String> extendedReaders, Set<String> extendedWriters, boolean useRetry) {
        CompletableFuture[] futures = (CompletableFuture[])documents.stream().map(doc -> CompletableFuture.runAsync(() -> this.setExtendedSecurity((NodeRef)doc, extendedReaders, extendedWriters, useRetry))).toArray(CompletableFuture[]::new);
        try {
            CompletableFuture.allOf(futures).join();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof ConcurrencyFailureException) {
                throw (ConcurrencyFailureException)cause;
            }
            throw new RuntimeException("Error during parallel execution", e);
        }
    }

    private void verifyCreatedGroups(final Set<NodeRef> documents, final boolean onlyDuplicatesValidation) {
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Set<String> expectedAuthorities = null;
                HashSet<Set<String>> errors = new HashSet<Set<String>>();
                for (NodeRef doc : documents) {
                    Set permissions = ExtendedSecurityServiceImplTest.this.permissionService.getAllSetPermissions(doc);
                    Set<String> authorities = ExtendedSecurityServiceImplTest.this.getDocumentAuthorities(permissions);
                    Set<String> authoritiesById = ExtendedSecurityServiceImplTest.this.getAuthorityIds(authorities);
                    ExtendedSecurityServiceImplTest.this.verifyIPRGroups(authorities, onlyDuplicatesValidation);
                    if (onlyDuplicatesValidation) continue;
                    if (expectedAuthorities == null) {
                        expectedAuthorities = authoritiesById;
                    }
                    if (expectedAuthorities.equals(authoritiesById)) continue;
                    errors.add(authoritiesById);
                }
                TestCase.assertTrue((String)"Unexpected authorities linked to document", (boolean)errors.isEmpty());
                return null;
            }
        }, false, true);
    }

    private Set<String> getDocumentAuthorities(Set<AccessPermission> permissions) {
        HashSet<String> authorities = new HashSet<String>();
        for (AccessPermission accessPermission : permissions) {
            String authority = accessPermission.getAuthority();
            String authName = this.authorityService.getName(AuthorityType.GROUP, authority);
            authorities.add(authName);
        }
        return authorities;
    }

    private Set<String> getAuthorityIds(Set<String> authorities) {
        HashSet<String> authorityIds = new HashSet<String>();
        for (String authority : authorities) {
            String authId = this.authorityService.getAuthorityNodeRef(authority) != null ? this.authorityService.getAuthorityNodeRef(authority).getId() : null;
            authorityIds.add(authId);
        }
        return authorityIds;
    }

    private void verifyIPRGroups(Set<String> authorities, boolean onlyDuplicatesValidation) {
        boolean hasGroupIPR = false;
        for (String authorityName : authorities) {
            String shortName = this.authorityService.getShortName(authorityName);
            if (!authorityName.startsWith("GROUP_IPR")) continue;
            hasGroupIPR = true;
            PagingResults results = this.authorityService.getAuthorities(AuthorityType.GROUP, null, shortName, false, false, new PagingRequest(0, 10));
            ExtendedSecurityServiceImplTest.assertEquals((String)"No duplicated IPR group expected", (int)1, (int)results.getPage().size());
        }
        if (!onlyDuplicatesValidation) {
            ExtendedSecurityServiceImplTest.assertTrue((String)"No IPR Groups created", (boolean)hasGroupIPR);
        }
    }
}

