/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.report.generator;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.report.generator.BaseReportGenerator;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.i18n.StaticMessageLookup;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.i18n.MessageLookup;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MimetypeService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.TemplateService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.UrlUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.extensions.surf.util.I18NUtil;

public class DeclarativeReportGenerator
extends BaseReportGenerator {
    protected static final String MSG_REPORT = "report.default";
    protected static final NodeRef TEMPLATE_ROOT = new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, "rm_report_templates");
    protected static final String KEY_NODE = "node";
    protected static final String KEY_CHILDREN = "children";
    protected Set<QName> applicableTypes;
    protected ContentService contentService;
    protected MimetypeService mimetypeService;
    protected FileFolderService fileFolderService;
    protected TemplateService templateService;
    protected Repository repository;
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected SysAdminParams sysAdminParams;

    public void setApplicableTypes(Set<QName> applicableTypes) {
        this.applicableTypes = applicableTypes;
    }

    public void setMimetypeService(MimetypeService mimetypeService) {
        this.mimetypeService = mimetypeService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setTemplateService(TemplateService templateService) {
        this.templateService = templateService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    @Override
    protected String generateReportName(NodeRef reportedUponNodeRef, String mimetype) {
        String extension = this.mimetypeService.getExtension(mimetype);
        String name = (String)((Object)this.nodeService.getProperty(reportedUponNodeRef, ContentModel.PROP_NAME));
        StringBuilder builder = new StringBuilder();
        builder.append(this.getReportDisplayLabel());
        if (StringUtils.isNotBlank((CharSequence)name)) {
            builder.append(" - ").append(name);
        }
        builder.append(".").append(extension);
        return builder.toString();
    }

    private String getReportDisplayLabel() {
        String result = I18NUtil.getMessage((String)MSG_REPORT);
        TypeDefinition typeDef = this.dictionaryService.getType(this.reportType);
        if (typeDef != null) {
            result = typeDef.getTitle((MessageLookup)new StaticMessageLookup());
        }
        return result;
    }

    @Override
    protected ContentReader generateReportContent(NodeRef reportedUponNodeRef, String mimetype, Map<String, Serializable> properties) {
        NodeRef reportTemplateNodeRef = this.getReportTemplate(mimetype);
        Map<String, Serializable> model = this.createTemplateModel(reportTemplateNodeRef, reportedUponNodeRef, properties);
        String result = this.templateService.processTemplate("freemarker", reportTemplateNodeRef.toString(), model);
        ContentWriter contentWriter = this.contentService.getTempWriter();
        contentWriter.setEncoding("UTF-8");
        contentWriter.setMimetype(mimetype);
        contentWriter.putContent(result);
        return contentWriter.getReader();
    }

    protected Map<String, Serializable> createTemplateModel(NodeRef templateNodeRef, NodeRef reportedUponNodeRef, Map<String, Serializable> properties) {
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        NodeRef person = this.repository.getPerson();
        this.templateService.buildDefaultModel(person, this.repository.getCompanyHome(), this.repository.getUserHome(person), templateNodeRef, null);
        model.put(KEY_NODE, (Serializable)reportedUponNodeRef);
        model.put("url", (Serializable)((Object)UrlUtil.getAlfrescoUrl((SysAdminParams)this.sysAdminParams)));
        model.put("shareUrl", (Serializable)((Object)UrlUtil.getShareUrl((SysAdminParams)this.sysAdminParams)));
        model.put("reportUser", (Serializable)((Object)AuthenticationUtil.getRunAsUser()));
        Calendar now = Calendar.getInstance(I18NUtil.getContentLocale());
        model.put("reportDate", (Serializable)((Object)SimpleDateFormat.getDateInstance(2).format(now.getTime())));
        model.put("properties", (Serializable)((Object)properties));
        return model;
    }

    private NodeRef getReportTemplate(String mimetype) {
        if (!this.fileFolderService.exists(TEMPLATE_ROOT)) {
            throw new AlfrescoRuntimeException("Unable to get report template, because the template root folder does not exist in the data dictionary.");
        }
        String reportTemplateName = this.getReportTemplateName(mimetype);
        NodeRef reportTemplateNodeRef = this.fileFolderService.searchSimple(TEMPLATE_ROOT, reportTemplateName);
        if (reportTemplateNodeRef == null) {
            throw new AlfrescoRuntimeException("Unable to get report template, because report template " + reportTemplateName + " does not exist.");
        }
        return this.fileFolderService.getLocalizedSibling(reportTemplateNodeRef);
    }

    private String getReportTemplateName(String mimetype) {
        String typePrefixName = this.reportType.getPrefixedQName((NamespacePrefixResolver)this.namespaceService).getPrefixString().replace(":", "_");
        String extension = this.mimetypeService.getExtension(mimetype);
        StringBuilder sb = new StringBuilder(128).append("report_").append(typePrefixName).append(".").append(extension).append(".ftl");
        return sb.toString();
    }

    @Override
    protected void checkReportApplicability(NodeRef reportedUponNodeRef) {
        if (this.applicableTypes != null && this.applicableTypes.size() != 0) {
            boolean isTypeApplicable = false;
            QName type = this.nodeService.getType(reportedUponNodeRef);
            for (QName applicableType : this.applicableTypes) {
                if (!this.dictionaryService.isSubClass(type, applicableType)) continue;
                isTypeApplicable = true;
                break;
            }
            if (!isTypeApplicable) {
                throw new AlfrescoRuntimeException("Can't generate report, because the provided reported upon node reference is type " + type.toString() + " which is not an applicable type for a " + this.reportType.toString() + " report.");
            }
        }
    }

    @Override
    protected Map<String, Serializable> generateReportTemplateContext(NodeRef reportedUponNodeRef) {
        return Collections.EMPTY_MAP;
    }

    @Override
    protected Map<QName, Serializable> generateReportMetadata(NodeRef reportedUponNodeRef) {
        return Collections.EMPTY_MAP;
    }
}

