/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.patch.v20;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.module.org_alfresco_module_rm.notification.RecordsManagementNotificationHelper;
import org.alfresco.module.org_alfresco_module_rm.patch.compatibility.ModulePatchComponent;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.QName;
import org.springframework.beans.factory.BeanNameAware;

public class NotificationTemplatePatch
extends ModulePatchComponent
implements BeanNameAware {
    private static final QName PROP_LAST_PATCH_UPDATE = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"lastPatchUpdate");
    private static final String PATH_DUE_FOR_REVIEW = "alfresco/module/org_alfresco_module_rm/bootstrap/content/notify-records-due-for-review-email.ftl";
    private static final String PATH_SUPERSEDED = "alfresco/module/org_alfresco_module_rm/bootstrap/content/record-superseded-email.ftl";
    private RecordsManagementNotificationHelper notificationHelper;
    private NodeService nodeService;
    private ContentService contentService;
    private VersionService versionService;
    private AuditService auditService;
    private String name;

    public void setNotificationHelper(RecordsManagementNotificationHelper notificationHelper) {
        this.notificationHelper = notificationHelper;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    @Override
    protected void executePatch() {
        NodeRef supersededTemplate = this.notificationHelper.getSupersededTemplate();
        this.updateTemplate(supersededTemplate, PATH_SUPERSEDED);
        NodeRef dueForReviewTemplate = this.notificationHelper.getDueForReviewTemplate();
        this.updateTemplate(dueForReviewTemplate, PATH_DUE_FOR_REVIEW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTemplate(NodeRef template, String templateUpdate) {
        if (template == null || !this.nodeService.exists(template)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Skipping template update, because template has not been bootstraped.");
            }
        } else {
            String lastPatchUpdate = (String)((Object)this.nodeService.getProperty(template, PROP_LAST_PATCH_UPDATE));
            if (lastPatchUpdate == null || !this.name.equals(lastPatchUpdate)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Applying update to template. (template=" + template.toString() + ", templateUpdate=" + templateUpdate + ")");
                }
                if (!this.nodeService.hasAspect(template, ContentModel.ASPECT_VERSIONABLE)) {
                    this.nodeService.addAspect(template, ContentModel.ASPECT_VERSIONABLE, null);
                    HashMap<String, String> versionProperties = new HashMap<String, String>(2);
                    versionProperties.put("description", "Initial version");
                    versionProperties.put("versionType", (String)VersionType.MINOR);
                    this.versionService.createVersion(template, versionProperties);
                }
                InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(templateUpdate);
                ContentWriter writer = this.contentService.getWriter(template, ContentModel.PROP_CONTENT, true);
                writer.putContent(is);
                boolean enabled = this.auditService.isAuditEnabled();
                this.auditService.setAuditEnabled(false);
                try {
                    this.nodeService.setProperty(template, PROP_LAST_PATCH_UPDATE, (Serializable)((Object)this.name));
                }
                finally {
                    this.auditService.setAuditEnabled(enabled);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Skipping template update, because template has already been patched. (template=" + template.toString() + ")");
            }
        }
    }
}

