/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.caveat;

import java.util.ArrayList;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.caveat.RMCaveatConfigService;
import org.alfresco.module.org_alfresco_module_rm.caveat.RMConstraintInfo;
import org.alfresco.module.org_alfresco_module_rm.caveat.ScriptConstraint;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.service.cmr.security.AuthorityService;

public class ScriptRMCaveatConfigService
extends BaseScopableProcessorExtension {
    private RMCaveatConfigService caveatConfigService;
    private AuthorityService authorityService;

    public void setCaveatConfigService(RMCaveatConfigService rmCaveatConfigService) {
        this.caveatConfigService = rmCaveatConfigService;
    }

    public RMCaveatConfigService getRmCaveatConfigService() {
        return this.caveatConfigService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public AuthorityService getAuthorityService() {
        return this.authorityService;
    }

    public ScriptConstraint getConstraint(String listName) {
        String xxx = listName.replace("_", ":");
        RMConstraintInfo info = this.caveatConfigService.getRMConstraint(xxx);
        if (info != null) {
            return new ScriptConstraint(info, this.caveatConfigService, this.getAuthorityService());
        }
        return null;
    }

    public ScriptConstraint[] getAllConstraints() {
        return this.getConstraints(true);
    }

    public ScriptConstraint[] getConstraintsWithoutEmptyList() {
        return this.getConstraints(false);
    }

    private ScriptConstraint[] getConstraints(boolean includeEmptyList) {
        Set<RMConstraintInfo> values = this.caveatConfigService.getAllRMConstraints();
        ArrayList<ScriptConstraint> vals = new ArrayList<ScriptConstraint>(values.size());
        for (RMConstraintInfo value : values) {
            ScriptConstraint c = new ScriptConstraint(value, this.caveatConfigService, this.getAuthorityService());
            if (includeEmptyList) {
                vals.add(c);
                continue;
            }
            if (c.getValues().length <= 0) continue;
            vals.add(c);
        }
        return vals.toArray(new ScriptConstraint[vals.size()]);
    }

    public void deleteConstraintList(String listName) {
        String xxx = listName.replace("_", ":");
        this.caveatConfigService.deleteRMConstraint(xxx);
    }

    public void updateConstraintValues(String listName, String authorityName, String[] values) {
        ArrayList<String> vals = new ArrayList<String>();
        this.caveatConfigService.updateRMConstraintListAuthority(listName, authorityName, vals);
    }

    public void deleteRMConstraintListAuthority(String listName, String authorityName) {
        String xxx = listName.replace("_", ":");
        this.caveatConfigService.removeRMConstraintListAuthority(xxx, authorityName);
    }

    public void deleteRMConstraintListValue(String listName, String valueName) {
        String xxx = listName.replace("_", ":");
        this.caveatConfigService.removeRMConstraintListValue(xxx, valueName);
    }

    public ScriptConstraint createConstraint(String listName, String title, String[] allowedValues) {
        if (listName != null) {
            listName = listName.replace("_", ":");
        }
        RMConstraintInfo info = this.caveatConfigService.addRMConstraint(listName, title, allowedValues);
        return new ScriptConstraint(info, this.caveatConfigService, this.getAuthorityService());
    }
}

