/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.webscript;

import java.io.IOException;
import java.text.MessageFormat;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMWebScriptTestCase;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.GUID;
import org.springframework.extensions.webscripts.TestWebScriptServer;

public class AuditRestApiTest
extends BaseRMWebScriptTestCase {
    protected static final String GET_NODE_AUDITLOG_URL_FORMAT = "/api/node/{0}/rmauditlog";
    private static final String USER_WITHOUT_AUDIT_CAPABILITY = GUID.generate();
    private NodeRef record;

    public void testAuditAccessCapability() throws IOException {
        String recordAuditUrl = MessageFormat.format(GET_NODE_AUDITLOG_URL_FORMAT, this.record.toString().replace("://", "/"));
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(recordAuditUrl), 200, AuthenticationUtil.getAdminUserName());
        this.sendRequest((TestWebScriptServer.Request)new TestWebScriptServer.GetRequest(recordAuditUrl), 403, USER_WITHOUT_AUDIT_CAPABILITY);
    }

    @Override
    protected void setupTestData() {
        super.setupTestData();
        this.retryingTransactionHelper.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            public Object execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getSystemUserName());
                AuditRestApiTest.this.createUser(USER_WITHOUT_AUDIT_CAPABILITY);
                AuditRestApiTest.this.record = AuditRestApiTest.this.utils.createRecord(AuditRestApiTest.this.recordFolder, GUID.generate());
                return null;
            }
        });
    }

    @Override
    protected void tearDownImpl() {
        super.tearDownImpl();
        this.deleteUser(USER_WITHOUT_AUDIT_CAPABILITY);
    }

    @Override
    protected String getRMSiteId() {
        return "rm";
    }
}

