/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.retentionschedule;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinitionImpl;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionServiceImpl;
import org.alfresco.module.org_alfresco_module_rm.disposition.property.DispositionProperty;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseUnitTest;
import org.alfresco.rest.framework.core.exceptions.InvalidArgumentException;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.RetentionScheduleActionDefinition;
import org.alfresco.rm.rest.api.model.RetentionSteps;
import org.alfresco.rm.rest.api.retentionschedule.RetentionScheduleActionRelation;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class RetentionScheduleActionRelationUnitTest
extends BaseUnitTest {
    @Mock
    private FilePlanComponentsApiUtils apiUtils;
    @Mock
    private ApiNodesModelFactory nodesModelFactory;
    @Mock
    private Parameters parameters;
    private RetentionScheduleActionRelation retentionScheduleActionRelation;
    private NodeRef rsRecordLevelNodeRef = new NodeRef("workspace://SpacesStore/recordLevel");
    private NodeRef rsRecordFolderLevelNodeRef = new NodeRef("workspace://SpacesStore/recordFolderLevel");

    @Before
    public void setUp() {
        DispositionServiceImpl dispositionService = new DispositionServiceImpl();
        DispositionProperty publicationDate = this.createDispositionProperty("dod:publicationDate", false, true, Set.of());
        DispositionProperty cutoffDate = this.createDispositionProperty("rma:cutOffDate", true, true, Set.of("cutoff"));
        DispositionProperty dispositionAsOf = this.createDispositionProperty("rma:dispositionAsOf", true, true, Set.of());
        DispositionProperty dateFiled = this.createDispositionProperty("rma:dateFiled", false, true, Set.of());
        DispositionProperty created = this.createDispositionProperty("cm:created", true, true, Set.of());
        dispositionService.registerDispositionProperty(publicationDate);
        dispositionService.registerDispositionProperty(cutoffDate);
        dispositionService.registerDispositionProperty(dispositionAsOf);
        dispositionService.registerDispositionProperty(dateFiled);
        dispositionService.registerDispositionProperty(created);
        this.retentionScheduleActionRelation = new RetentionScheduleActionRelation();
        this.retentionScheduleActionRelation.setApiUtils(this.apiUtils);
        this.retentionScheduleActionRelation.setNodeService(this.mockedNodeService);
        this.retentionScheduleActionRelation.setNodesModelFactory(this.nodesModelFactory);
        this.retentionScheduleActionRelation.setDispositionService((DispositionService)dispositionService);
    }

    @Test
    public void testCreate_RetentionScheduleRecordLevel_Cutoff_Valid() throws Exception {
        String retentionScheduleId = this.useRetentionScheduleWithRecordLevel(true, false);
        String actionName = RetentionSteps.CUTOFF.stepName;
        this.executeValidStep(retentionScheduleId, actionName, "dod:publicationDate");
        this.executeValidStep(retentionScheduleId, actionName, "rma:dispositionAsOf");
        this.executeValidStep(retentionScheduleId, actionName, "rma:dateFiled");
        this.executeValidStep(retentionScheduleId, actionName, "cm:created");
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)4))).createNode((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
    }

    @Test
    public void testCreate_RetentionScheduleRecordLevel_Cutoff_Invalid() throws Exception {
        String retentionScheduleId = this.useRetentionScheduleWithRecordLevel(true, false);
        String actionName = RetentionSteps.CUTOFF.stepName;
        this.executeInvalidStep(retentionScheduleId, actionName, "rma:cutOffDate");
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).createNode((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
    }

    @Test
    public void testCreate_RetentionScheduleRecordFolderLevel_Cutoff_Valid() throws Exception {
        String retentionScheduleId = this.useRetentionScheduleWithRecordLevel(false, false);
        String actionName = RetentionSteps.CUTOFF.stepName;
        this.executeValidStep(retentionScheduleId, actionName, "rma:dispositionAsOf");
        this.executeValidStep(retentionScheduleId, actionName, "cm:created");
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)2))).createNode((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
    }

    @Test
    public void testCreate_RetentionScheduleRecordFolderLevel_Cutoff_Invalid() throws Exception {
        String retentionScheduleId = this.useRetentionScheduleWithRecordLevel(false, false);
        String actionName = RetentionSteps.CUTOFF.stepName;
        this.executeInvalidStep(retentionScheduleId, actionName, "dod:publicationDate");
        this.executeInvalidStep(retentionScheduleId, actionName, "rma:cutOffDate");
        this.executeInvalidStep(retentionScheduleId, actionName, "rma:dateFiled");
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).createNode((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
    }

    @Test
    public void testCreate_RetentionScheduleRecordLevel_Transfer_Valid() throws Exception {
        String retentionScheduleId = this.useRetentionScheduleWithRecordLevel(true, true);
        String actionName = RetentionSteps.TRANSFER.stepName;
        this.executeValidStep(retentionScheduleId, actionName, "dod:publicationDate");
        this.executeValidStep(retentionScheduleId, actionName, "rma:cutOffDate");
        this.executeValidStep(retentionScheduleId, actionName, "rma:dispositionAsOf");
        this.executeValidStep(retentionScheduleId, actionName, "rma:dateFiled");
        this.executeValidStep(retentionScheduleId, actionName, "cm:created");
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)5))).createNode((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
    }

    @Test
    public void testCreate_RetentionScheduleRecordLevel_Transfer_Invalid() throws Exception {
        String retentionScheduleId = this.useRetentionScheduleWithRecordLevel(true, true);
        String actionName = RetentionSteps.TRANSFER.stepName;
        this.executeInvalidStep(retentionScheduleId, actionName, "bad:property");
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).createNode((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
    }

    @Test
    public void testCreate_RetentionScheduleRecordFolderLevel_Transfer_Valid() throws Exception {
        String retentionScheduleId = this.useRetentionScheduleWithRecordLevel(false, true);
        String actionName = RetentionSteps.TRANSFER.stepName;
        this.executeValidStep(retentionScheduleId, actionName, "rma:cutOffDate");
        this.executeValidStep(retentionScheduleId, actionName, "rma:dispositionAsOf");
        this.executeValidStep(retentionScheduleId, actionName, "cm:created");
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.times((int)3))).createNode((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
    }

    @Test
    public void testCreate_RetentionScheduleRecordFolderLevel_Transfer_Invalid() throws Exception {
        String retentionScheduleId = this.useRetentionScheduleWithRecordLevel(false, true);
        String actionName = RetentionSteps.TRANSFER.stepName;
        this.executeInvalidStep(retentionScheduleId, actionName, "dod:publicationDate");
        this.executeInvalidStep(retentionScheduleId, actionName, "rma:dateFiled");
        ((NodeService)Mockito.verify((Object)this.mockedNodeService, (VerificationMode)Mockito.never())).createNode((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
    }

    private void executeValidStep(String retentionScheduleId, String actionName, String periodProperty) {
        RetentionScheduleActionDefinition actionDef = this.createAction(actionName, periodProperty);
        this.retentionScheduleActionRelation.create(retentionScheduleId, Arrays.asList(actionDef), this.parameters);
    }

    private void executeInvalidStep(String retentionScheduleId, String actionName, String periodProperty) {
        RetentionScheduleActionDefinition actionDef = this.createAction(actionName, periodProperty);
        try {
            this.retentionScheduleActionRelation.create(retentionScheduleId, Arrays.asList(actionDef), this.parameters);
        }
        catch (InvalidArgumentException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("periodProperty value is invalid: " + periodProperty));
        }
    }

    private String useRetentionScheduleWithRecordLevel(Boolean withRecordLevel, boolean hasCompletedActions) {
        NodeRef retentionScheduleNodeRef = withRecordLevel != false ? this.rsRecordLevelNodeRef : this.rsRecordFolderLevelNodeRef;
        String retentionScheduleId = retentionScheduleNodeRef.getId();
        ChildAssociationRef retentionScheduleAssocRef = (ChildAssociationRef)Mockito.mock(ChildAssociationRef.class);
        NodeRef cutOffActionNodeRef = (NodeRef)Mockito.mock(NodeRef.class);
        DispositionActionDefinitionImpl cutoffAction = new DispositionActionDefinitionImpl(this.mockedRecordsManagementEventService, this.mockedRecordsManagementActionService, this.mockedNodeService, cutOffActionNodeRef, 0);
        List completedActions = hasCompletedActions ? Arrays.asList(cutoffAction) : Collections.emptyList();
        Mockito.when((Object)retentionScheduleAssocRef.getChildRef()).thenReturn((Object)new NodeRef("workspace://SpacesStore/123"));
        Mockito.when((Object)this.apiUtils.lookupAndValidateNodeType((String)ArgumentMatchers.eq((Object)retentionScheduleId), (QName)ArgumentMatchers.any(QName.class))).thenReturn((Object)retentionScheduleNodeRef);
        Mockito.when((Object)this.mockedNodeService.getProperty(retentionScheduleNodeRef, RecordsManagementModel.PROP_RECORD_LEVEL_DISPOSITION)).thenReturn((Object)withRecordLevel);
        Mockito.when((Object)this.nodesModelFactory.getRetentionActions(retentionScheduleNodeRef)).thenReturn(completedActions);
        Mockito.when((Object)this.mockedNodeService.createNode((NodeRef)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (QName)ArgumentMatchers.any(), (Map)ArgumentMatchers.any())).thenReturn((Object)retentionScheduleAssocRef);
        return retentionScheduleId;
    }

    private RetentionScheduleActionDefinition createAction(String name, String periodProperty) {
        RetentionScheduleActionDefinition actionDef = (RetentionScheduleActionDefinition)Mockito.mock(RetentionScheduleActionDefinition.class);
        Mockito.when((Object)actionDef.getName()).thenReturn((Object)name);
        Mockito.when((Object)actionDef.getPeriodProperty()).thenReturn((Object)periodProperty);
        Mockito.when((Object)actionDef.getPeriodAmount()).thenReturn((Object)2);
        Mockito.when((Object)actionDef.getPeriod()).thenReturn((Object)"day");
        Mockito.when((Object)actionDef.getEvents()).thenReturn(Collections.singletonList("versioned"));
        Mockito.when((Object)actionDef.isCombineRetentionStepConditions()).thenReturn((Object)false);
        return actionDef;
    }

    private DispositionProperty createDispositionProperty(String name, Boolean appliesToFolderLevel, Boolean appliesToRecordLevel, Set<String> excludedActions) {
        Mockito.when((Object)this.mockedNamespaceService.getNamespaceURI((String)ArgumentMatchers.any())).thenReturn((Object)name.split(":")[0]);
        DispositionProperty dp = new DispositionProperty();
        dp.setNamespaceService(this.mockedNamespaceService);
        dp.setName(name);
        dp.setAppliesToRecordLevel(appliesToRecordLevel.booleanValue());
        dp.setAppliesToFolderLevel(appliesToFolderLevel.booleanValue());
        dp.setExcludedDispositionActions(excludedActions);
        return dp;
    }
}

