/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.action.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.action.RMActionExecuterAbstractBase;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class ApplyCustomTypeAction
extends RMActionExecuterAbstractBase {
    private static final String MSG_ACTIONED_UPON_NOT_RECORD = "rm.action.actioned-upon-not-record";
    private static final String MSG_CUSTOM_ASPECT_NOT_RECOGNISED = "rm.action.custom-aspect-not-recognised";
    private static Log logger = LogFactory.getLog(ApplyCustomTypeAction.class);
    private QName customTypeAspect;
    private List<ParameterDefinition> parameterDefinitions;

    public void setCustomTypeAspect(String customTypeAspect) {
        this.customTypeAspect = QName.createQName((String)customTypeAspect, (NamespacePrefixResolver)this.getNamespaceService());
    }

    protected void executeImpl(Action action, NodeRef actionedUponNodeRef) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing action [" + action.getActionDefinitionName() + "] on " + String.valueOf(actionedUponNodeRef)));
        }
        if (this.getRecordService().isRecord(actionedUponNodeRef)) {
            Map<QName, Serializable> aspectProps = this.getPropertyValues(action);
            this.getNodeService().addAspect(actionedUponNodeRef, this.customTypeAspect, aspectProps);
        } else if (logger.isWarnEnabled()) {
            logger.warn((Object)I18NUtil.getMessage((String)MSG_ACTIONED_UPON_NOT_RECORD, (Object[])new Object[]{this.getClass().getSimpleName(), actionedUponNodeRef.toString()}));
        }
    }

    @Override
    protected final void addParameterDefinitions(List<ParameterDefinition> paramList) {
        AspectDefinition aspectDef = this.getDictionaryService().getAspect(this.customTypeAspect);
        for (PropertyDefinition propDef : aspectDef.getProperties().values()) {
            QName propName = propDef.getName();
            QName propType = propDef.getDataType().getName();
            paramList.add((ParameterDefinition)new ParameterDefinitionImpl(propName.toPrefixString(), propType, propDef.isMandatory(), null));
        }
    }

    private Map<QName, Serializable> getPropertyValues(Action action) {
        Map paramValues = action.getParameterValues();
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>(paramValues.size());
        for (Map.Entry entry : paramValues.entrySet()) {
            QName propQName = QName.createQName((String)((String)entry.getKey()), (NamespacePrefixResolver)this.getNamespaceService());
            result.put(propQName, (Serializable)entry.getValue());
        }
        return result;
    }

    protected synchronized List<ParameterDefinition> getParameterDefintions() {
        if (this.parameterDefinitions == null) {
            AspectDefinition aspectDefinition = this.getDictionaryService().getAspect(this.customTypeAspect);
            if (aspectDefinition == null) {
                throw new AlfrescoRuntimeException(I18NUtil.getMessage((String)MSG_CUSTOM_ASPECT_NOT_RECOGNISED, (Object[])new Object[]{this.customTypeAspect}));
            }
            Map props = aspectDefinition.getProperties();
            this.parameterDefinitions = new ArrayList<ParameterDefinition>(props.size());
            for (Map.Entry entry : props.entrySet()) {
                String paramName = ((QName)entry.getKey()).toPrefixString((NamespacePrefixResolver)this.getNamespaceService());
                PropertyDefinition value = (PropertyDefinition)entry.getValue();
                QName paramType = value.getDataType().getName();
                boolean paramIsMandatory = value.isMandatory();
                this.parameterDefinitions.add((ParameterDefinition)new ParameterDefinitionImpl(paramName, paramType, paramIsMandatory, null));
            }
        }
        return this.parameterDefinitions;
    }
}

