/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.util;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.alfresco.module.org_alfresco_module_rm.test.util.ExceptionUtils;
import org.alfresco.module.org_alfresco_module_rm.util.RMCollectionUtils;
import org.junit.Assert;
import org.junit.Test;

public class RMCollectionUtilsUnitTest {
    @Test
    public void getDuplicateElements() {
        List<String> l = Arrays.asList("A", "B", "C", "B", "A");
        Assert.assertEquals((String)"Failed to identify duplicate elements", Arrays.asList("B", "A"), (Object)RMCollectionUtils.getDuplicateElements(l));
        Assert.assertEquals(Collections.emptyList(), (Object)RMCollectionUtils.getDuplicateElements(Arrays.asList("A", "B", "C")));
    }

    @Test
    public void compareMaps() {
        HashMap<Integer, Integer> mapA = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> mapB = new HashMap<Integer, Integer>();
        for (int i : Arrays.asList(1, 2, 3, 4, 5)) {
            mapA.put(i, i * i);
        }
        mapB.putAll(mapA);
        mapB.put(6, 36);
        mapB.remove(1);
        mapB.put(3, 100);
        Assert.assertEquals((Object)RMCollectionUtils.Difference.REMOVED, (Object)RMCollectionUtils.diffKey(mapA, mapB, (Object)1));
        Assert.assertEquals((Object)RMCollectionUtils.Difference.ADDED, (Object)RMCollectionUtils.diffKey(mapA, mapB, (Object)6));
        Assert.assertEquals((Object)RMCollectionUtils.Difference.UNCHANGED, (Object)RMCollectionUtils.diffKey(mapA, mapB, (Object)2));
        Assert.assertEquals((Object)RMCollectionUtils.Difference.UNCHANGED, (Object)RMCollectionUtils.diffKey(mapA, mapB, (Object)-1));
        Assert.assertEquals((Object)RMCollectionUtils.Difference.CHANGED, (Object)RMCollectionUtils.diffKey(mapA, mapB, (Object)3));
    }

    @Test
    public void tailsOfLists() {
        Assert.assertEquals(Arrays.asList(2), (Object)RMCollectionUtils.tail(Arrays.asList(1, 2)));
        Assert.assertEquals(Collections.emptyList(), (Object)RMCollectionUtils.tail(Arrays.asList(1)));
        ExceptionUtils.expectedException(UnsupportedOperationException.class, () -> RMCollectionUtils.tail(Collections.emptyList()));
    }

    @Test
    public void headsOfLists() {
        Assert.assertEquals((Object)"a", (Object)RMCollectionUtils.head(Arrays.asList("a", "b")));
        Assert.assertEquals((Object)"a", (Object)RMCollectionUtils.head(Arrays.asList("a")));
        Assert.assertNull((Object)RMCollectionUtils.head(Collections.emptyList()));
    }

    @Test
    public void elementsAsSet() {
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"hello", "world"}), (Object)RMCollectionUtils.asSet((Object[])new String[]{"hello", "world"}));
        Assert.assertEquals((Object)Sets.newHashSet((Object[])new Integer[]{3, 7, 31, 127}), (Object)RMCollectionUtils.asSet((Object[])new Integer[]{3, 7, 31, 127}));
    }

    @Test
    public void elementsAsSerializableList() {
        Serializable s = RMCollectionUtils.asSerializableList((Serializable[])new String[]{"one", "two", "three"});
        List l = (List)((Object)RMCollectionUtils.asSerializableList((Serializable[])new String[]{"one", "two", "three"}));
        Assert.assertEquals((Object)s, (Object)l);
    }

    @Test
    public void toImmutableSet_nullInput() {
        ImmutableSet output = RMCollectionUtils.toImmutableSet(null);
        Assert.assertNull((String)"toImmutableSet should pass through with null.", (Object)output);
    }

    @Test
    public void toImmutableSet_nullElement() {
        HashSet input = Sets.newHashSet((Object[])new String[]{"One", null, "Three"});
        ImmutableSet output = RMCollectionUtils.toImmutableSet((Collection)input);
        Assert.assertEquals((String)"Unexpected handling of null input element", (Object)output, (Object)Sets.newHashSet((Object[])new String[]{"One", "Three"}));
        Assert.assertEquals((String)"Input should not have been changed.", (Object)input, (Object)Sets.newHashSet((Object[])new String[]{"One", null, "Three"}));
    }
}

