/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.integration.disposition;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.GUID;

public class DispositionScheduleInheritanceTest
extends BaseRMTestCase {
    public void testRetentionScheduleInheritance_RM7065() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef category1;
            NodeRef subcategory2;
            NodeRef record;

            @Override
            public void given() {
                this.category1 = DispositionScheduleInheritanceTest.this.filePlanService.createRecordCategory(DispositionScheduleInheritanceTest.this.filePlan, GUID.generate());
                DispositionScheduleInheritanceTest.this.createDispositionScheduleCutOffAndRetainImmediately(this.category1);
                NodeRef subcategory1 = DispositionScheduleInheritanceTest.this.filePlanService.createRecordCategory(this.category1, GUID.generate());
                NodeRef category2 = DispositionScheduleInheritanceTest.this.filePlanService.createRecordCategory(DispositionScheduleInheritanceTest.this.filePlan, GUID.generate());
                this.subcategory2 = DispositionScheduleInheritanceTest.this.filePlanService.createRecordCategory(category2, GUID.generate());
                DispositionScheduleInheritanceTest.this.folder = DispositionScheduleInheritanceTest.this.recordFolderService.createRecordFolder(this.subcategory2, GUID.generate());
                this.record = DispositionScheduleInheritanceTest.this.utils.createRecord(DispositionScheduleInheritanceTest.this.folder, GUID.generate(), GUID.generate());
                DispositionScheduleInheritanceTest.this.utils.completeRecord(this.record);
            }

            @Override
            public void when() throws Exception {
                DispositionScheduleInheritanceTest.this.fileFolderService.move(this.subcategory2, this.category1, null);
            }

            @Override
            public void then() throws Exception {
                DispositionScheduleInheritanceTest.this.dispositionService.getDispositionSchedule(this.record);
                TestCase.assertTrue((String)("Record " + String.valueOf(this.record) + " doesn't have the disposition lifecycle aspect."), (boolean)DispositionScheduleInheritanceTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_DISPOSITION_LIFECYCLE));
            }
        });
    }

    public void testRetentionScheduleInheritance_APPS7103() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef category1;
            NodeRef subcategory2;
            NodeRef record;
            Date asOfDateBeforeMove;

            @Override
            public void given() {
                this.category1 = DispositionScheduleInheritanceTest.this.filePlanService.createRecordCategory(DispositionScheduleInheritanceTest.this.filePlan, GUID.generate());
                DispositionScheduleInheritanceTest.this.createDispositionScheduleCutOff(this.category1, "cutoff", "day|10");
                NodeRef category2 = DispositionScheduleInheritanceTest.this.filePlanService.createRecordCategory(DispositionScheduleInheritanceTest.this.filePlan, GUID.generate());
                DispositionScheduleInheritanceTest.this.createDispositionScheduleCutOff(category2, "cutoff", "day|5");
                this.subcategory2 = DispositionScheduleInheritanceTest.this.filePlanService.createRecordCategory(category2, GUID.generate());
                DispositionScheduleInheritanceTest.this.folder = DispositionScheduleInheritanceTest.this.recordFolderService.createRecordFolder(this.subcategory2, GUID.generate());
                this.record = DispositionScheduleInheritanceTest.this.utils.createRecord(DispositionScheduleInheritanceTest.this.folder, GUID.generate(), GUID.generate());
                DispositionScheduleInheritanceTest.this.utils.completeRecord(this.record);
                this.asOfDateBeforeMove = DispositionScheduleInheritanceTest.this.dispositionService.getNextDispositionAction(this.record).getAsOfDate();
            }

            @Override
            public void when() throws Exception {
                DispositionScheduleInheritanceTest.this.fileFolderService.move(this.subcategory2, this.category1, null);
            }

            @Override
            public void then() throws Exception {
                DispositionScheduleInheritanceTest.this.dispositionService.getDispositionSchedule(this.record);
                DispositionAction dispositionActionAfterMove = DispositionScheduleInheritanceTest.this.dispositionService.getNextDispositionAction(this.record);
                TestCase.assertNotNull((Object)dispositionActionAfterMove);
                TestCase.assertEquals((String)"cutoff", (String)dispositionActionAfterMove.getName());
                TestCase.assertNotNull((Object)dispositionActionAfterMove.getAsOfDate());
                TestCase.assertTrue((boolean)dispositionActionAfterMove.getAsOfDate().after(this.asOfDateBeforeMove));
                TestCase.assertTrue((boolean)DispositionScheduleInheritanceTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_RM_SEARCH));
                TestCase.assertEquals((Object)"cutoff", (Object)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_NAME));
                TestCase.assertNotNull((Object)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_AS_OF));
                TestCase.assertNull((Object)((List)((Object)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_EVENTS))));
                TestCase.assertNotNull((Object)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOITION_INSTRUCTIONS));
                TestCase.assertNotNull((Object)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOITION_AUTHORITY));
                TestCase.assertTrue((boolean)((Boolean)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_HAS_DISPOITION_SCHEDULE)));
            }
        });
    }

    public void testRetentionScheduleInheritance_APPS_1004() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef category1;
            NodeRef subcategory2;
            NodeRef record;
            Date asOfDateBeforeMove;

            @Override
            public void given() {
                this.category1 = DispositionScheduleInheritanceTest.this.filePlanService.createRecordCategory(DispositionScheduleInheritanceTest.this.filePlan, GUID.generate());
                DispositionScheduleInheritanceTest.this.createDispositionScheduleRetainAndCutOffOneDay(this.category1);
                NodeRef category2 = DispositionScheduleInheritanceTest.this.filePlanService.createRecordCategory(DispositionScheduleInheritanceTest.this.filePlan, GUID.generate());
                DispositionScheduleInheritanceTest.this.createDispositionScheduleCutOffAndDestroyOneDay(category2);
                this.subcategory2 = DispositionScheduleInheritanceTest.this.filePlanService.createRecordCategory(category2, GUID.generate());
                DispositionScheduleInheritanceTest.this.folder = DispositionScheduleInheritanceTest.this.recordFolderService.createRecordFolder(this.subcategory2, GUID.generate());
                this.record = DispositionScheduleInheritanceTest.this.utils.createRecord(DispositionScheduleInheritanceTest.this.folder, GUID.generate(), GUID.generate());
                DispositionScheduleInheritanceTest.this.utils.completeRecord(this.record);
                this.asOfDateBeforeMove = DispositionScheduleInheritanceTest.this.dispositionService.getNextDispositionAction(this.record).getAsOfDate();
            }

            @Override
            public void when() throws Exception {
                DispositionScheduleInheritanceTest.this.fileFolderService.move(this.subcategory2, this.category1, null);
            }

            @Override
            public void then() throws Exception {
                DispositionScheduleInheritanceTest.this.dispositionService.getDispositionSchedule(this.record);
                DispositionAction dispositionActionAfterMove = DispositionScheduleInheritanceTest.this.dispositionService.getNextDispositionAction(this.record);
                TestCase.assertNotNull((Object)dispositionActionAfterMove);
                TestCase.assertEquals((String)"retain", (String)dispositionActionAfterMove.getName());
                TestCase.assertNotNull((Object)dispositionActionAfterMove.getAsOfDate());
                TestCase.assertTrue((boolean)dispositionActionAfterMove.getAsOfDate().after(this.asOfDateBeforeMove));
                TestCase.assertTrue((boolean)DispositionScheduleInheritanceTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_RM_SEARCH));
                TestCase.assertEquals((Object)"retain", (Object)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_NAME));
                TestCase.assertNotNull((Object)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_AS_OF));
                TestCase.assertNull((Object)((List)((Object)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_EVENTS))));
                TestCase.assertNotNull((Object)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOITION_INSTRUCTIONS));
                TestCase.assertNotNull((Object)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOITION_AUTHORITY));
                TestCase.assertTrue((boolean)((Boolean)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_HAS_DISPOITION_SCHEDULE)));
            }
        });
    }

    public void testRetentionScheduleInheritance_APPS_1005() {
        this.doBehaviourDrivenTest(new BaseRMTestCase.BehaviourDrivenTest(){
            NodeRef category1;
            NodeRef subcategory2;
            NodeRef record;
            Date asOfDateBeforeMove;

            @Override
            public void given() {
                this.category1 = DispositionScheduleInheritanceTest.this.filePlanService.createRecordCategory(DispositionScheduleInheritanceTest.this.filePlan, GUID.generate());
                DispositionScheduleInheritanceTest.this.utils.createDispositionSchedule(this.category1, "disposition instructions", "disposition action description", true, true, false, "case_closed");
                NodeRef category2 = DispositionScheduleInheritanceTest.this.filePlanService.createRecordCategory(DispositionScheduleInheritanceTest.this.filePlan, GUID.generate());
                DispositionScheduleInheritanceTest.this.utils.createDispositionSchedule(category2, "disposition instructions", "disposition action description", true, true, false, "separation");
                this.subcategory2 = DispositionScheduleInheritanceTest.this.filePlanService.createRecordCategory(category2, GUID.generate());
                DispositionScheduleInheritanceTest.this.folder = DispositionScheduleInheritanceTest.this.recordFolderService.createRecordFolder(this.subcategory2, GUID.generate());
                this.record = DispositionScheduleInheritanceTest.this.utils.createRecord(DispositionScheduleInheritanceTest.this.folder, GUID.generate(), GUID.generate());
                DispositionScheduleInheritanceTest.this.utils.completeRecord(this.record);
                this.asOfDateBeforeMove = DispositionScheduleInheritanceTest.this.dispositionService.getNextDispositionAction(this.record).getAsOfDate();
            }

            @Override
            public void when() throws Exception {
                DispositionScheduleInheritanceTest.this.fileFolderService.move(this.subcategory2, this.category1, null);
            }

            @Override
            public void then() throws Exception {
                DispositionAction dispositionActionAfterMove = DispositionScheduleInheritanceTest.this.dispositionService.getNextDispositionAction(this.record);
                TestCase.assertNotNull((Object)dispositionActionAfterMove);
                TestCase.assertEquals((String)"cutoff", (String)dispositionActionAfterMove.getName());
                TestCase.assertTrue((boolean)DispositionScheduleInheritanceTest.this.nodeService.hasAspect(this.record, RecordsManagementModel.ASPECT_RM_SEARCH));
                TestCase.assertEquals((Object)"cutoff", (Object)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_NAME));
                TestCase.assertNotNull((Object)((List)((Object)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_EVENTS))));
                TestCase.assertEquals((int)((List)((Object)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_EVENTS))).size(), (int)1);
                TestCase.assertEquals((String)"case_closed", (String)((String)((List)((Object)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOSITION_EVENTS))).get(0)));
                TestCase.assertNotNull((Object)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOITION_INSTRUCTIONS));
                TestCase.assertNotNull((Object)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_DISPOITION_AUTHORITY));
                TestCase.assertTrue((boolean)((Boolean)DispositionScheduleInheritanceTest.this.nodeService.getProperty(this.record, RecordsManagementModel.PROP_RS_HAS_DISPOITION_SCHEDULE)));
            }
        });
    }

    private void createDispositionScheduleCutOff(NodeRef category, String action, String period) {
        DispositionSchedule ds = this.utils.createDispositionSchedule(category, "disposition instructions", "disposition action description", true, false, false);
        this.createDispositionScheduleStep(ds, action, period);
    }

    private void createDispositionScheduleCutOffAndRetainImmediately(NodeRef category) {
        DispositionSchedule ds = this.utils.createDispositionSchedule(category, "disposition instructions", "disposition action description", true, false, false);
        this.createDispositionScheduleStep(ds, "cutoff", "immediately|0");
        this.createDispositionScheduleStep(ds, "retain", "immediately|0");
    }

    private void createDispositionScheduleRetainAndCutOffOneDay(NodeRef category) {
        DispositionSchedule ds = this.utils.createDispositionSchedule(category, "disposition instructions", "disposition action description", true, false, false);
        this.createDispositionScheduleStep(ds, "retain", "day|1");
        this.createDispositionScheduleStep(ds, "destroy", "day|1");
    }

    private void createDispositionScheduleCutOffAndDestroyOneDay(NodeRef category) {
        DispositionSchedule ds = this.utils.createDispositionSchedule(category, "disposition instructions", "disposition action description", true, false, false);
        this.createDispositionScheduleStep(ds, "cutoff", "day|1");
        this.createDispositionScheduleStep(ds, "destroy", "day|1");
    }

    private void createDispositionScheduleStep(DispositionSchedule ds, String action, String period) {
        HashMap<QName, String> step = new HashMap<QName, String>(3);
        step.put(PROP_DISPOSITION_ACTION_NAME, action);
        step.put(PROP_DISPOSITION_DESCRIPTION, GUID.generate());
        step.put(PROP_DISPOSITION_PERIOD, period);
        this.dispositionService.addDispositionActionDefinition(ds, step);
    }
}

