/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.jscript.app;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.module.org_alfresco_module_rm.capability.Capability;
import org.alfresco.module.org_alfresco_module_rm.capability.CapabilityService;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionService;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanComponentKind;
import org.alfresco.module.org_alfresco_module_rm.fileplan.FilePlanService;
import org.alfresco.module.org_alfresco_module_rm.jscript.app.JSONConversionComponent;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.record.RecordService;
import org.alfresco.module.org_alfresco_module_rm.recordfolder.RecordFolderService;
import org.alfresco.module.org_alfresco_module_rm.util.TransactionalResourceHelper;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.NamespaceService;
import org.springframework.beans.factory.BeanNameAware;

public abstract class BaseEvaluator
implements RecordsManagementModel,
BeanNameAware {
    protected String name;
    protected String beanName;
    protected JSONConversionComponent jsonConversionComponent;
    protected RecordService recordService;
    protected NodeService nodeService;
    protected NamespaceService namespaceService;
    protected CapabilityService capabilityService;
    protected Set<FilePlanComponentKind> kinds;
    protected List<String> capabilities;
    protected FilePlanService filePlanService;
    protected DispositionService dispositionService;
    protected RecordFolderService recordFolderService;
    protected TransactionalResourceHelper transactionalResourceHelper;

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setJsonConversionComponent(JSONConversionComponent jsonConversionComponent) {
        this.jsonConversionComponent = jsonConversionComponent;
    }

    public void setRecordService(RecordService recordService) {
        this.recordService = recordService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public void setFilePlanService(FilePlanService filePlanService) {
        this.filePlanService = filePlanService;
    }

    public void setDispositionService(DispositionService dispositionService) {
        this.dispositionService = dispositionService;
    }

    public void setRecordFolderService(RecordFolderService recordFolderService) {
        this.recordFolderService = recordFolderService;
    }

    public void setTransactionalResourceHelper(TransactionalResourceHelper transactionalResourceHelper) {
        this.transactionalResourceHelper = transactionalResourceHelper;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setKinds(Set<FilePlanComponentKind> kinds) {
        this.kinds = kinds;
    }

    public void setCapabilities(List<String> capabilties) {
        this.capabilities = capabilties;
    }

    public void setCapability(String capability) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(capability);
        this.capabilities = list;
    }

    public void registerIndicator() {
        this.jsonConversionComponent.registerIndicator(this);
    }

    public void registerAction() {
        this.jsonConversionComponent.registerAction(this);
    }

    public boolean evaluate(NodeRef nodeRef) {
        String key;
        Map<String, Boolean> results = this.transactionalResourceHelper.getMap("BaseEvaluator.evaluate");
        if (!results.containsKey(key = new StringBuffer(nodeRef.toString()).append(AuthenticationUtil.getRunAsUser()).append(this.beanName).toString())) {
            boolean result = false;
            if ((this.kinds == null || this.checkKinds(nodeRef)) && (this.capabilities == null || this.checkCapabilities(nodeRef))) {
                result = this.evaluateImpl(nodeRef);
            }
            results.put(key, result);
        }
        return (Boolean)results.get(key);
    }

    private boolean checkKinds(NodeRef nodeRef) {
        FilePlanComponentKind kind = this.filePlanService.getFilePlanComponentKind(nodeRef);
        return this.kinds.contains((Object)kind);
    }

    private boolean checkCapabilities(NodeRef nodeRef) {
        boolean result = true;
        if (this.capabilities != null && !this.capabilities.isEmpty()) {
            Map<Capability, AccessStatus> accessStatus = this.capabilityService.getCapabilitiesAccessState(nodeRef, this.capabilities);
            for (AccessStatus value : accessStatus.values()) {
                if (!AccessStatus.DENIED.equals((Object)value)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    protected abstract boolean evaluateImpl(NodeRef var1);
}

