/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.test.legacy.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionAction;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionActionDefinition;
import org.alfresco.module.org_alfresco_module_rm.disposition.DispositionSchedule;
import org.alfresco.module.org_alfresco_module_rm.disposition.property.DispositionProperty;
import org.alfresco.module.org_alfresco_module_rm.dod5015.DOD5015Model;
import org.alfresco.module.org_alfresco_module_rm.event.EventCompletionDetails;
import org.alfresco.module.org_alfresco_module_rm.job.PublishUpdatesJobExecuter;
import org.alfresco.module.org_alfresco_module_rm.job.publish.PublishExecutor;
import org.alfresco.module.org_alfresco_module_rm.job.publish.PublishExecutorRegistry;
import org.alfresco.module.org_alfresco_module_rm.model.RecordsManagementModel;
import org.alfresco.module.org_alfresco_module_rm.test.util.BaseRMTestCase;
import org.alfresco.rest.framework.core.exceptions.ConstraintViolatedException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.RetryingTransactionHelperTestCase;
import org.junit.Assert;

public class DispositionServiceImplTest
extends BaseRMTestCase {
    private NodeRef record43;
    private NodeRef record45;
    private NodeRef testRM263RecordCategory;
    private DispositionSchedule testRM263DispositionSchedule;
    private NodeRef testRM263Record;
    private NodeRef testRM386RecordCategory;
    private DispositionSchedule testRM386DispositionSchedule;
    private NodeRef testRM386Record;

    @Override
    protected boolean isMultiHierarchyTest() {
        return true;
    }

    public void testGetDispositionProperties() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                Collection properties = DispositionServiceImplTest.this.dispositionService.getDispositionProperties();
                TestCase.assertNotNull((Object)properties);
                TestCase.assertEquals((int)5, (int)properties.size());
                for (DispositionProperty property : properties) {
                    TestCase.assertNotNull((Object)property.getQName());
                    TestCase.assertNotNull((Object)property.getPropertyDefinition());
                }
                return null;
            }
        });
    }

    public void testGetDispositionSchedule() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertNull((Object)DispositionServiceImplTest.this.dispositionService.getDispositionSchedule(DispositionServiceImplTest.this.filePlan));
                DispositionSchedule ds = DispositionServiceImplTest.this.dispositionService.getDispositionSchedule(DispositionServiceImplTest.this.rmContainer);
                TestCase.assertNotNull((Object)ds);
                DispositionServiceImplTest.this.checkDispositionSchedule(ds, false);
                ds = DispositionServiceImplTest.this.dispositionService.getDispositionSchedule(DispositionServiceImplTest.this.rmContainer);
                TestCase.assertNotNull((Object)ds);
                DispositionServiceImplTest.this.checkDispositionSchedule(ds, false);
                return null;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest("Should not be able to get adisposition schedule for the root node", AlfrescoRuntimeException.class){

            public void run() {
                DispositionServiceImplTest.this.dispositionService.getDispositionSchedule(DispositionServiceImplTest.this.rootNodeRef);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                DispositionServiceImplTest.this.dispositionService.getDispositionSchedule(DispositionServiceImplTest.this.folder);
            }
        });
    }

    public void testGetDispositionScheduleMultiHier() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertNull((Object)DispositionServiceImplTest.this.dispositionService.getDispositionSchedule(DispositionServiceImplTest.this.mhContainer));
                this.doCheck(DispositionServiceImplTest.this.mhContainer11, "ds11", false);
                this.doCheck(DispositionServiceImplTest.this.mhContainer12, "ds12", false);
                this.doCheck(DispositionServiceImplTest.this.mhContainer21, "ds11", false);
                this.doCheck(DispositionServiceImplTest.this.mhContainer22, "ds12", false);
                this.doCheck(DispositionServiceImplTest.this.mhContainer23, "ds23", false);
                this.doCheck(DispositionServiceImplTest.this.mhContainer31, "ds11", false);
                this.doCheck(DispositionServiceImplTest.this.mhContainer32, "ds12", false);
                this.doCheck(DispositionServiceImplTest.this.mhContainer33, "ds33", true);
                this.doCheck(DispositionServiceImplTest.this.mhContainer34, "ds23", false);
                this.doCheck(DispositionServiceImplTest.this.mhContainer35, "ds35", true);
                this.doCheckFolder(DispositionServiceImplTest.this.mhRecordFolder41, "ds11", false);
                this.doCheckFolder(DispositionServiceImplTest.this.mhRecordFolder42, "ds12", false);
                this.doCheckFolder(DispositionServiceImplTest.this.mhRecordFolder43, "ds33", true);
                this.doCheckFolder(DispositionServiceImplTest.this.mhRecordFolder44, "ds23", false);
                this.doCheckFolder(DispositionServiceImplTest.this.mhRecordFolder45, "ds35", true);
                return null;
            }

            private void doCheck(NodeRef container, String dispositionInstructions, boolean isRecordLevel) {
                DispositionSchedule ds = DispositionServiceImplTest.this.dispositionService.getDispositionSchedule(container);
                TestCase.assertNotNull((Object)ds);
                DispositionServiceImplTest.this.checkDispositionSchedule(ds, dispositionInstructions, "disposition authority", isRecordLevel);
            }

            private void doCheckFolder(NodeRef container, String dispositionInstructions, boolean isRecordLevel) {
                this.doCheck(container, dispositionInstructions, isRecordLevel);
                if (!isRecordLevel) {
                    TestCase.assertNotNull((Object)DispositionServiceImplTest.this.dispositionService.getNextDispositionAction(container));
                }
            }
        });
    }

    private void checkDispositionSchedule(DispositionSchedule ds, String dispositionInstructions, String dispositionAuthority, boolean isRecordLevel) {
        DispositionServiceImplTest.assertEquals((String)dispositionAuthority, (String)ds.getDispositionAuthority());
        DispositionServiceImplTest.assertEquals((String)dispositionInstructions, (String)ds.getDispositionInstructions());
        DispositionServiceImplTest.assertEquals((boolean)isRecordLevel, (boolean)ds.isRecordLevelDisposition());
        List defs = ds.getDispositionActionDefinitions();
        DispositionServiceImplTest.assertNotNull((Object)defs);
        DispositionServiceImplTest.assertEquals((int)2, (int)defs.size());
        DispositionActionDefinition defCutoff = ds.getDispositionActionDefinitionByName("cutoff");
        DispositionServiceImplTest.assertNotNull((Object)defCutoff);
        DispositionServiceImplTest.assertEquals((String)"cutoff", (String)defCutoff.getName());
        DispositionActionDefinition defDestroy = ds.getDispositionActionDefinitionByName("destroy");
        DispositionServiceImplTest.assertNotNull((Object)defDestroy);
        DispositionServiceImplTest.assertEquals((String)"destroy", (String)defDestroy.getName());
    }

    private void checkDispositionSchedule(DispositionSchedule ds, boolean isRecordLevel) {
        this.checkDispositionSchedule(ds, "disposition instructions", "disposition authority", isRecordLevel);
    }

    public void testGetAssociatedDispositionSchedule() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                DispositionSchedule ds = DispositionServiceImplTest.this.dispositionService.getAssociatedDispositionSchedule(DispositionServiceImplTest.this.rmContainer);
                TestCase.assertNotNull((Object)ds);
                DispositionServiceImplTest.this.checkDispositionSchedule(ds, false);
                TestCase.assertNull((Object)DispositionServiceImplTest.this.dispositionService.getAssociatedDispositionSchedule(DispositionServiceImplTest.this.filePlan));
                TestCase.assertNull((Object)DispositionServiceImplTest.this.dispositionService.getAssociatedDispositionSchedule(DispositionServiceImplTest.this.rmFolder));
                return null;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest(){

            public void run() {
                DispositionServiceImplTest.this.dispositionService.getAssociatedDispositionSchedule(DispositionServiceImplTest.this.folder);
            }
        });
    }

    public void testGetAssociatedDispositionScheduleMultiHier() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertNull((Object)DispositionServiceImplTest.this.dispositionService.getAssociatedDispositionSchedule(DispositionServiceImplTest.this.mhContainer));
                this.doCheck(DispositionServiceImplTest.this.mhContainer11, "ds11", false);
                this.doCheck(DispositionServiceImplTest.this.mhContainer12, "ds12", false);
                TestCase.assertNull((Object)DispositionServiceImplTest.this.dispositionService.getAssociatedDispositionSchedule(DispositionServiceImplTest.this.mhContainer21));
                TestCase.assertNull((Object)DispositionServiceImplTest.this.dispositionService.getAssociatedDispositionSchedule(DispositionServiceImplTest.this.mhContainer22));
                this.doCheck(DispositionServiceImplTest.this.mhContainer23, "ds23", false);
                TestCase.assertNull((Object)DispositionServiceImplTest.this.dispositionService.getAssociatedDispositionSchedule(DispositionServiceImplTest.this.mhContainer31));
                TestCase.assertNull((Object)DispositionServiceImplTest.this.dispositionService.getAssociatedDispositionSchedule(DispositionServiceImplTest.this.mhContainer32));
                this.doCheck(DispositionServiceImplTest.this.mhContainer33, "ds33", true);
                TestCase.assertNull((Object)DispositionServiceImplTest.this.dispositionService.getAssociatedDispositionSchedule(DispositionServiceImplTest.this.mhContainer34));
                this.doCheck(DispositionServiceImplTest.this.mhContainer35, "ds35", true);
                return null;
            }

            private void doCheck(NodeRef container, String dispositionInstructions, boolean isRecordLevel) {
                DispositionSchedule ds = DispositionServiceImplTest.this.dispositionService.getAssociatedDispositionSchedule(container);
                TestCase.assertNotNull((Object)ds);
                DispositionServiceImplTest.this.checkDispositionSchedule(ds, dispositionInstructions, "disposition authority", isRecordLevel);
            }
        });
    }

    public void testHasDisposableItems() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef container = DispositionServiceImplTest.this.filePlanService.createRecordCategory(DispositionServiceImplTest.this.rmContainer, "hasDisposableTest");
                DispositionSchedule ds = DispositionServiceImplTest.this.utils.createBasicDispositionSchedule(container);
                TestCase.assertTrue((boolean)DispositionServiceImplTest.this.dispositionService.hasDisposableItems(DispositionServiceImplTest.this.dispositionSchedule));
                TestCase.assertFalse((boolean)DispositionServiceImplTest.this.dispositionService.hasDisposableItems(ds));
                return null;
            }
        });
    }

    public void testHasDisposableItemsMultiHier() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                TestCase.assertTrue((boolean)DispositionServiceImplTest.this.dispositionService.hasDisposableItems(DispositionServiceImplTest.this.mhDispositionSchedule11));
                TestCase.assertTrue((boolean)DispositionServiceImplTest.this.dispositionService.hasDisposableItems(DispositionServiceImplTest.this.mhDispositionSchedule12));
                TestCase.assertTrue((boolean)DispositionServiceImplTest.this.dispositionService.hasDisposableItems(DispositionServiceImplTest.this.mhDispositionSchedule23));
                TestCase.assertFalse((boolean)DispositionServiceImplTest.this.dispositionService.hasDisposableItems(DispositionServiceImplTest.this.mhDispositionSchedule33));
                TestCase.assertFalse((boolean)DispositionServiceImplTest.this.dispositionService.hasDisposableItems(DispositionServiceImplTest.this.mhDispositionSchedule35));
                return null;
            }
        });
    }

    public void testGetDisposableItems() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                List nodeRefs = DispositionServiceImplTest.this.dispositionService.getDisposableItems(DispositionServiceImplTest.this.dispositionSchedule);
                TestCase.assertNotNull((Object)nodeRefs);
                TestCase.assertEquals((int)1, (int)nodeRefs.size());
                TestCase.assertTrue((boolean)nodeRefs.contains(DispositionServiceImplTest.this.rmFolder));
                return null;
            }
        });
    }

    public void testGetDisposableItemsMultiHier() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                List nodeRefs = DispositionServiceImplTest.this.dispositionService.getDisposableItems(DispositionServiceImplTest.this.mhDispositionSchedule11);
                TestCase.assertNotNull((Object)nodeRefs);
                TestCase.assertEquals((int)1, (int)nodeRefs.size());
                TestCase.assertTrue((boolean)nodeRefs.contains(DispositionServiceImplTest.this.mhRecordFolder41));
                nodeRefs = DispositionServiceImplTest.this.dispositionService.getDisposableItems(DispositionServiceImplTest.this.mhDispositionSchedule12);
                TestCase.assertNotNull((Object)nodeRefs);
                TestCase.assertEquals((int)1, (int)nodeRefs.size());
                TestCase.assertTrue((boolean)nodeRefs.contains(DispositionServiceImplTest.this.mhRecordFolder42));
                nodeRefs = DispositionServiceImplTest.this.dispositionService.getDisposableItems(DispositionServiceImplTest.this.mhDispositionSchedule23);
                TestCase.assertNotNull((Object)nodeRefs);
                TestCase.assertEquals((int)1, (int)nodeRefs.size());
                TestCase.assertTrue((boolean)nodeRefs.contains(DispositionServiceImplTest.this.mhRecordFolder44));
                nodeRefs = DispositionServiceImplTest.this.dispositionService.getDisposableItems(DispositionServiceImplTest.this.mhDispositionSchedule33);
                TestCase.assertNotNull((Object)nodeRefs);
                TestCase.assertEquals((int)0, (int)nodeRefs.size());
                nodeRefs = DispositionServiceImplTest.this.dispositionService.getDisposableItems(DispositionServiceImplTest.this.mhDispositionSchedule35);
                TestCase.assertNotNull((Object)nodeRefs);
                TestCase.assertEquals((int)0, (int)nodeRefs.size());
                return null;
            }
        });
    }

    public void testCreateDispositionSchedule() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<NodeRef>(){

            public NodeRef run() {
                NodeRef container = DispositionServiceImplTest.this.filePlanService.createRecordCategory(DispositionServiceImplTest.this.filePlan, "testCreateDispositionSchedule");
                DispositionServiceImplTest.this.utils.createBasicDispositionSchedule(container, "testCreateDispositionSchedule", "testCreateDispositionSchedule", false, true);
                return container;
            }

            public void test(NodeRef result) throws Exception {
                DispositionSchedule ds = DispositionServiceImplTest.this.dispositionService.getAssociatedDispositionSchedule(result);
                TestCase.assertNotNull((Object)ds);
                DispositionServiceImplTest.this.checkDispositionSchedule(ds, "testCreateDispositionSchedule", "testCreateDispositionSchedule", false);
                Assert.assertThrows(ConstraintViolatedException.class, () -> DispositionServiceImplTest.this.utils.createBasicDispositionSchedule(DispositionServiceImplTest.this.rmContainer));
            }
        });
    }

    public void testCreateDispositionScheduleMultiHier() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef testA = DispositionServiceImplTest.this.filePlanService.createRecordCategory(DispositionServiceImplTest.this.mhContainer, "testA");
                NodeRef testB = DispositionServiceImplTest.this.filePlanService.createRecordCategory(testA, "testB");
                DispositionServiceImplTest.this.utils.createBasicDispositionSchedule(testA, "testA", "testA", false, true);
                DispositionServiceImplTest.this.utils.createBasicDispositionSchedule(testB, "testB", "testB", false, true);
                this.setNodeRef("testA", testA);
                this.setNodeRef("testB", testB);
                return null;
            }

            public void test(Void result) throws Exception {
                DispositionSchedule testA = DispositionServiceImplTest.this.dispositionService.getAssociatedDispositionSchedule(this.getNodeRef("testA"));
                TestCase.assertNotNull((Object)testA);
                DispositionSchedule testB = DispositionServiceImplTest.this.dispositionService.getAssociatedDispositionSchedule(this.getNodeRef("testB"));
                TestCase.assertNotNull((Object)testB);
                DispositionServiceImplTest.this.checkDispositionSchedule(testA, "testA", "testA", false);
                DispositionServiceImplTest.this.checkDispositionSchedule(testB, "testB", "testB", false);
                Assert.assertThrows(ConstraintViolatedException.class, () -> DispositionServiceImplTest.this.utils.createBasicDispositionSchedule(DispositionServiceImplTest.this.rmContainer));
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.FailureTest("Can not create a disposition schedule on a container where there are already disposable items under management"){

            public void run() {
                DispositionServiceImplTest.this.utils.createBasicDispositionSchedule(DispositionServiceImplTest.this.mhContainer21);
            }
        });
    }

    public void testGetAssociatedRecordsManagementContainer() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef nodeRef = DispositionServiceImplTest.this.dispositionService.getAssociatedRecordsManagementContainer(DispositionServiceImplTest.this.dispositionSchedule);
                TestCase.assertNotNull((Object)nodeRef);
                TestCase.assertEquals((Object)DispositionServiceImplTest.this.rmContainer, (Object)nodeRef);
                return null;
            }
        });
    }

    public void testGetAssociatedRecordsManagementContainerMultiHier() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() {
                NodeRef nodeRef = DispositionServiceImplTest.this.dispositionService.getAssociatedRecordsManagementContainer(DispositionServiceImplTest.this.mhDispositionSchedule11);
                TestCase.assertNotNull((Object)nodeRef);
                TestCase.assertEquals((Object)DispositionServiceImplTest.this.mhContainer11, (Object)nodeRef);
                nodeRef = DispositionServiceImplTest.this.dispositionService.getAssociatedRecordsManagementContainer(DispositionServiceImplTest.this.mhDispositionSchedule12);
                TestCase.assertNotNull((Object)nodeRef);
                TestCase.assertEquals((Object)DispositionServiceImplTest.this.mhContainer12, (Object)nodeRef);
                nodeRef = DispositionServiceImplTest.this.dispositionService.getAssociatedRecordsManagementContainer(DispositionServiceImplTest.this.mhDispositionSchedule23);
                TestCase.assertNotNull((Object)nodeRef);
                TestCase.assertEquals((Object)DispositionServiceImplTest.this.mhContainer23, (Object)nodeRef);
                nodeRef = DispositionServiceImplTest.this.dispositionService.getAssociatedRecordsManagementContainer(DispositionServiceImplTest.this.mhDispositionSchedule33);
                TestCase.assertNotNull((Object)nodeRef);
                TestCase.assertEquals((Object)DispositionServiceImplTest.this.mhContainer33, (Object)nodeRef);
                nodeRef = DispositionServiceImplTest.this.dispositionService.getAssociatedRecordsManagementContainer(DispositionServiceImplTest.this.mhDispositionSchedule35);
                TestCase.assertNotNull((Object)nodeRef);
                TestCase.assertEquals((Object)DispositionServiceImplTest.this.mhContainer35, (Object)nodeRef);
                return null;
            }
        });
    }

    public void testUpdateDispositionActionDefinitionMultiHier() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                DispositionServiceImplTest.this.record43 = DispositionServiceImplTest.this.utils.createRecord(DispositionServiceImplTest.this.mhRecordFolder43, "record1.txt");
                DispositionServiceImplTest.this.record45 = DispositionServiceImplTest.this.utils.createRecord(DispositionServiceImplTest.this.mhRecordFolder45, "record2.txt");
                return null;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                DispositionServiceImplTest.this.checkDisposableItemUnchanged(DispositionServiceImplTest.this.mhRecordFolder41);
                DispositionServiceImplTest.this.checkDisposableItemUnchanged(DispositionServiceImplTest.this.mhRecordFolder42);
                DispositionServiceImplTest.this.checkDisposableItemUnchanged(DispositionServiceImplTest.this.record43);
                DispositionServiceImplTest.this.checkDisposableItemUnchanged(DispositionServiceImplTest.this.mhRecordFolder44);
                DispositionServiceImplTest.this.checkDisposableItemUnchanged(DispositionServiceImplTest.this.record45);
                DispositionServiceImplTest.this.updateDispositionScheduleOnContainer(DispositionServiceImplTest.this.mhContainer11);
                return null;
            }

            public void test(Void result) throws Exception {
                DispositionServiceImplTest.this.checkDisposableItemChanged(DispositionServiceImplTest.this.mhRecordFolder41);
                DispositionServiceImplTest.this.checkDisposableItemUnchanged(DispositionServiceImplTest.this.mhRecordFolder42);
                DispositionServiceImplTest.this.checkDisposableItemUnchanged(DispositionServiceImplTest.this.record43);
                DispositionServiceImplTest.this.checkDisposableItemUnchanged(DispositionServiceImplTest.this.mhRecordFolder44);
                DispositionServiceImplTest.this.checkDisposableItemUnchanged(DispositionServiceImplTest.this.record45);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                DispositionServiceImplTest.this.updateDispositionScheduleOnContainer(DispositionServiceImplTest.this.mhContainer12);
                return null;
            }

            public void test(Void result) throws Exception {
                DispositionServiceImplTest.this.checkDisposableItemChanged(DispositionServiceImplTest.this.mhRecordFolder41);
                DispositionServiceImplTest.this.checkDisposableItemChanged(DispositionServiceImplTest.this.mhRecordFolder42);
                DispositionServiceImplTest.this.checkDisposableItemUnchanged(DispositionServiceImplTest.this.record43);
                DispositionServiceImplTest.this.checkDisposableItemUnchanged(DispositionServiceImplTest.this.mhRecordFolder44);
                DispositionServiceImplTest.this.checkDisposableItemUnchanged(DispositionServiceImplTest.this.record45);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                DispositionServiceImplTest.this.updateDispositionScheduleOnContainer(DispositionServiceImplTest.this.mhContainer33);
                return null;
            }

            public void test(Void result) throws Exception {
                DispositionServiceImplTest.this.checkDisposableItemChanged(DispositionServiceImplTest.this.mhRecordFolder41);
                DispositionServiceImplTest.this.checkDisposableItemChanged(DispositionServiceImplTest.this.mhRecordFolder42);
                DispositionServiceImplTest.this.checkDisposableItemChanged(DispositionServiceImplTest.this.record43);
                DispositionServiceImplTest.this.checkDisposableItemUnchanged(DispositionServiceImplTest.this.mhRecordFolder44);
                DispositionServiceImplTest.this.checkDisposableItemUnchanged(DispositionServiceImplTest.this.record45);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                DispositionServiceImplTest.this.updateDispositionScheduleOnContainer(DispositionServiceImplTest.this.mhContainer23);
                return null;
            }

            public void test(Void result) throws Exception {
                DispositionServiceImplTest.this.checkDisposableItemChanged(DispositionServiceImplTest.this.mhRecordFolder41);
                DispositionServiceImplTest.this.checkDisposableItemChanged(DispositionServiceImplTest.this.mhRecordFolder42);
                DispositionServiceImplTest.this.checkDisposableItemChanged(DispositionServiceImplTest.this.record43);
                DispositionServiceImplTest.this.checkDisposableItemChanged(DispositionServiceImplTest.this.mhRecordFolder44);
                DispositionServiceImplTest.this.checkDisposableItemUnchanged(DispositionServiceImplTest.this.record45);
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                DispositionServiceImplTest.this.updateDispositionScheduleOnContainer(DispositionServiceImplTest.this.mhContainer35);
                return null;
            }

            public void test(Void result) throws Exception {
                DispositionServiceImplTest.this.checkDisposableItemChanged(DispositionServiceImplTest.this.mhRecordFolder41);
                DispositionServiceImplTest.this.checkDisposableItemChanged(DispositionServiceImplTest.this.mhRecordFolder42);
                DispositionServiceImplTest.this.checkDisposableItemChanged(DispositionServiceImplTest.this.record43);
                DispositionServiceImplTest.this.checkDisposableItemChanged(DispositionServiceImplTest.this.mhRecordFolder44);
                DispositionServiceImplTest.this.checkDisposableItemChanged(DispositionServiceImplTest.this.record45);
            }
        });
    }

    private void publishDispositionActionDefinitionChange(DispositionActionDefinition dad) {
        PublishExecutorRegistry reg = (PublishExecutorRegistry)this.applicationContext.getBean("publishExecutorRegistry");
        PublishExecutor pub = reg.get("dispositionActionDefinition");
        DispositionServiceImplTest.assertNotNull((Object)pub);
        pub.publish(dad.getNodeRef());
    }

    private void checkDisposableItemUnchanged(NodeRef recordFolder) {
        this.checkDispositionAction(this.dispositionService.getNextDispositionAction(recordFolder), "cutoff", new String[]{"case_closed"}, "none|0");
    }

    private void checkDisposableItemChanged(NodeRef recordFolder) throws Exception {
        this.checkDispositionAction(this.dispositionService.getNextDispositionAction(recordFolder), "cutoff", new String[]{"case_closed", "abolished"}, "week|1");
    }

    private void updateDispositionScheduleOnContainer(NodeRef nodeRef) {
        HashMap<QName, Object> updateProps = new HashMap<QName, Object>(3);
        updateProps.put(PROP_DISPOSITION_PERIOD, "week|1");
        updateProps.put(PROP_DISPOSITION_EVENT, (Serializable)((Object)Arrays.asList("case_closed", "abolished")));
        DispositionSchedule ds = this.dispositionService.getDispositionSchedule(nodeRef);
        DispositionActionDefinition dad = ds.getDispositionActionDefinitionByName("cutoff");
        this.dispositionService.updateDispositionActionDefinition(dad, updateProps);
        this.publishDispositionActionDefinitionChange(dad);
    }

    private void checkDispositionAction(DispositionAction da, String name, String[] arrEventNames, String strPeriod) {
        DispositionServiceImplTest.assertNotNull((Object)da);
        DispositionServiceImplTest.assertEquals((String)name, (String)da.getName());
        List events = da.getEventCompletionDetails();
        DispositionServiceImplTest.assertNotNull((Object)events);
        DispositionServiceImplTest.assertEquals((int)arrEventNames.length, (int)events.size());
        ArrayList<String> origEvents = new ArrayList<String>(events.size());
        for (EventCompletionDetails event : events) {
            origEvents.add(event.getEventName());
        }
        List<String> expectedEvents = Arrays.asList(arrEventNames);
        ArrayList copy = new ArrayList(origEvents);
        Iterator i = origEvents.iterator();
        while (i.hasNext()) {
            String origEvent = (String)i.next();
            if (!expectedEvents.contains(origEvent)) continue;
            i.remove();
            copy.remove(origEvent);
        }
        if (copy.size() != 0 && expectedEvents.size() != 0) {
            StringBuffer buff = new StringBuffer(255);
            if (copy.size() != 0) {
                buff.append("The following events where found, but not expected: (");
                for (String eventName : copy) {
                    buff.append(eventName).append(", ");
                }
                buff.append(").  ");
            }
            if (expectedEvents.size() != 0) {
                buff.append("The following events where not found, but expected: (");
                for (String eventName : expectedEvents) {
                    buff.append(eventName).append(", ");
                }
                buff.append(").");
            }
            DispositionServiceImplTest.fail((String)buff.toString());
        }
        if ("none|0".equals(strPeriod)) {
            DispositionServiceImplTest.assertNull((Object)da.getAsOfDate());
        } else {
            DispositionServiceImplTest.assertNotNull((Object)da.getAsOfDate());
        }
    }

    public void testRM_263() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                DispositionServiceImplTest.this.testRM263RecordCategory = DispositionServiceImplTest.this.filePlanService.createRecordCategory(DispositionServiceImplTest.this.rmContainer, "rm263");
                DispositionServiceImplTest.this.testRM263DispositionSchedule = DispositionServiceImplTest.this.utils.createBasicDispositionSchedule(DispositionServiceImplTest.this.testRM263RecordCategory, "test", "test", true, false);
                HashMap<QName, String> adParams = new HashMap<QName, String>(3);
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_ACTION_NAME, "cutoff");
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_DESCRIPTION, "test");
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_PERIOD, "week|1");
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_PERIOD_PROPERTY, DOD5015Model.PROP_PUBLICATION_DATE.toString());
                DispositionServiceImplTest.this.dispositionService.addDispositionActionDefinition(DispositionServiceImplTest.this.testRM263DispositionSchedule, adParams);
                NodeRef recordFolder = DispositionServiceImplTest.this.recordFolderService.createRecordFolder(DispositionServiceImplTest.this.testRM263RecordCategory, "testRM263RecordFolder");
                DispositionServiceImplTest.this.testRM263Record = DispositionServiceImplTest.this.utils.createRecord(recordFolder, "testRM263Record", "testRM263Record");
                return null;
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){
            private final QName PROP_SEARCH_ASOF;
            {
                this.PROP_SEARCH_ASOF = QName.createQName((String)"http://www.alfresco.org/model/recordsmanagement/1.0", (String)"recordSearchDispositionActionAsOf");
            }

            public Void run() throws Exception {
                Date pubDate = (Date)DispositionServiceImplTest.this.nodeService.getProperty(DispositionServiceImplTest.this.testRM263Record, DOD5015Model.PROP_PUBLICATION_DATE);
                TestCase.assertNull((Object)pubDate);
                Date asOfDate = (Date)DispositionServiceImplTest.this.nodeService.getProperty(DispositionServiceImplTest.this.testRM263Record, this.PROP_SEARCH_ASOF);
                TestCase.assertNull((Object)asOfDate);
                DispositionAction da = DispositionServiceImplTest.this.dispositionService.getNextDispositionAction(DispositionServiceImplTest.this.testRM263Record);
                TestCase.assertNotNull((Object)da);
                TestCase.assertNull((Object)da.getAsOfDate());
                DispositionServiceImplTest.this.nodeService.setProperty(DispositionServiceImplTest.this.testRM263Record, DOD5015Model.PROP_PUBLICATION_DATE, (Serializable)new Date());
                return null;
            }

            public void test(Void result) throws Exception {
                Date pubDate = (Date)DispositionServiceImplTest.this.nodeService.getProperty(DispositionServiceImplTest.this.testRM263Record, DOD5015Model.PROP_PUBLICATION_DATE);
                TestCase.assertNotNull((Object)pubDate);
                Date asOfDate = (Date)DispositionServiceImplTest.this.nodeService.getProperty(DispositionServiceImplTest.this.testRM263Record, this.PROP_SEARCH_ASOF);
                TestCase.assertNotNull((Object)asOfDate);
                DispositionAction da = DispositionServiceImplTest.this.dispositionService.getNextDispositionAction(DispositionServiceImplTest.this.testRM263Record);
                TestCase.assertNotNull((Object)da);
                TestCase.assertNotNull((Object)da.getAsOfDate());
            }
        });
    }

    public void testRM386() throws Exception {
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<Void>(){

            public Void run() throws Exception {
                DispositionServiceImplTest.this.testRM386RecordCategory = DispositionServiceImplTest.this.filePlanService.createRecordCategory(DispositionServiceImplTest.this.rmContainer, "RM386");
                DispositionServiceImplTest.this.testRM386DispositionSchedule = DispositionServiceImplTest.this.utils.createBasicDispositionSchedule(DispositionServiceImplTest.this.testRM386RecordCategory, "disposition instructions", "disposition authority", true, true);
                NodeRef recordFolder = DispositionServiceImplTest.this.recordFolderService.createRecordFolder(DispositionServiceImplTest.this.testRM386RecordCategory, "testRM386RecordFolder");
                DispositionServiceImplTest.this.testRM386Record = DispositionServiceImplTest.this.utils.createRecord(recordFolder, "testRM386Record", "testRM386Record");
                return null;
            }

            public void test(Void result) throws Exception {
                Map properties = DispositionServiceImplTest.this.nodeService.getProperties(DispositionServiceImplTest.this.testRM386Record);
                TestCase.assertEquals((Object)Boolean.TRUE, properties.get(RecordsManagementModel.PROP_RS_HAS_DISPOITION_SCHEDULE));
                TestCase.assertEquals((Object)"disposition authority", properties.get(RecordsManagementModel.PROP_RS_DISPOITION_AUTHORITY));
                TestCase.assertEquals((Object)"disposition instructions", properties.get(RecordsManagementModel.PROP_RS_DISPOITION_INSTRUCTIONS));
                TestCase.assertEquals((Object)"none", properties.get(RecordsManagementModel.PROP_RS_DISPOSITION_PERIOD));
                TestCase.assertEquals((Object)"0", properties.get(RecordsManagementModel.PROP_RS_DISPOSITION_PERIOD_EXPRESSION));
                List events = (List)properties.get(RecordsManagementModel.PROP_RS_DISPOSITION_EVENTS);
                TestCase.assertNotNull((Object)events);
                TestCase.assertEquals((int)1, (int)events.size());
                TestCase.assertEquals((String)"case_closed", (String)((String)events.get(0)));
                TestCase.assertEquals((Object)Boolean.FALSE, properties.get(RecordsManagementModel.PROP_RS_DISPOSITION_EVENTS_ELIGIBLE));
                TestCase.assertEquals((Object)"cutoff", properties.get(RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_NAME));
                TestCase.assertNull(properties.get(RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_AS_OF));
            }
        });
        this.doTestInTransaction(new RetryingTransactionHelperTestCase.Test<DispositionActionDefinition>(){

            public DispositionActionDefinition run() throws Exception {
                DispositionActionDefinition actionDefinition = DispositionServiceImplTest.this.testRM386DispositionSchedule.getDispositionActionDefinitionByName("cutoff");
                TestCase.assertNotNull((String)"Expected an action definition", (Object)actionDefinition);
                HashMap<QName, Object> adParams = new HashMap<QName, Object>(3);
                ArrayList<String> events = new ArrayList<String>(1);
                events.add("case_closed");
                events.add("obsolete");
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_EVENT, events);
                adParams.put(RecordsManagementModel.PROP_DISPOSITION_PERIOD, "week|1");
                DispositionServiceImplTest.this.dispositionService.updateDispositionActionDefinition(actionDefinition, adParams);
                return actionDefinition;
            }

            public void test(DispositionActionDefinition result) throws Exception {
                DispositionActionDefinition actionDefinition = DispositionServiceImplTest.this.testRM386DispositionSchedule.getDispositionActionDefinitionByName("cutoff");
                TestCase.assertNotNull((Object)actionDefinition);
                TestCase.assertTrue((boolean)DispositionServiceImplTest.this.nodeService.hasAspect(actionDefinition.getNodeRef(), RecordsManagementModel.ASPECT_UNPUBLISHED_UPDATE));
                PublishUpdatesJobExecuter updater = (PublishUpdatesJobExecuter)DispositionServiceImplTest.this.applicationContext.getBean("publishUpdatesJobExecuter");
                updater.executeImpl();
                TestCase.assertFalse((boolean)DispositionServiceImplTest.this.nodeService.hasAspect(actionDefinition.getNodeRef(), RecordsManagementModel.ASPECT_UNPUBLISHED_UPDATE));
                DispositionAction dispositionAction = DispositionServiceImplTest.this.dispositionService.getNextDispositionAction(DispositionServiceImplTest.this.testRM386Record);
                TestCase.assertNotNull((Object)dispositionAction);
                TestCase.assertEquals((String)"cutoff", (String)dispositionAction.getName());
                TestCase.assertNotNull((Object)dispositionAction.getAsOfDate());
                TestCase.assertEquals((int)2, (int)dispositionAction.getEventCompletionDetails().size());
                Map properties = DispositionServiceImplTest.this.nodeService.getProperties(DispositionServiceImplTest.this.testRM386Record);
                TestCase.assertEquals((Object)Boolean.TRUE, properties.get(RecordsManagementModel.PROP_RS_HAS_DISPOITION_SCHEDULE));
                TestCase.assertEquals((Object)"disposition authority", properties.get(RecordsManagementModel.PROP_RS_DISPOITION_AUTHORITY));
                TestCase.assertEquals((Object)"disposition instructions", properties.get(RecordsManagementModel.PROP_RS_DISPOITION_INSTRUCTIONS));
                TestCase.assertEquals((Object)"week", properties.get(RecordsManagementModel.PROP_RS_DISPOSITION_PERIOD));
                TestCase.assertEquals((Object)"1", properties.get(RecordsManagementModel.PROP_RS_DISPOSITION_PERIOD_EXPRESSION));
                List events = (List)properties.get(RecordsManagementModel.PROP_RS_DISPOSITION_EVENTS);
                TestCase.assertNotNull((Object)events);
                TestCase.assertEquals((int)2, (int)events.size());
                TestCase.assertEquals((Object)Boolean.FALSE, properties.get(RecordsManagementModel.PROP_RS_DISPOSITION_EVENTS_ELIGIBLE));
                TestCase.assertEquals((Object)"cutoff", properties.get(RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_NAME));
                TestCase.assertNotNull(properties.get(RecordsManagementModel.PROP_RS_DISPOSITION_ACTION_AS_OF));
            }
        });
    }
}

