/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.module.org_alfresco_module_rm.bulk;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import org.alfresco.module.org_alfresco_module_rm.bulk.BulkOperation;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.DefaultHoldBulkMonitor;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkProcessDetails;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkStatus;
import org.alfresco.module.org_alfresco_module_rm.bulk.hold.HoldBulkStatusAndProcessDetails;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.Pair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class DefaultHoldBulkMonitorUnitTest {
    @Mock
    private SimpleCache<String, HoldBulkStatus> holdProgressCache;
    @Mock
    private SimpleCache<Pair<String, String>, HoldBulkProcessDetails> holdProcessRegistry;
    private DefaultHoldBulkMonitor holdBulkMonitor;

    @Before
    public void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        this.holdBulkMonitor = new DefaultHoldBulkMonitor();
        this.holdBulkMonitor.setHoldProgressCache(this.holdProgressCache);
        this.holdBulkMonitor.setHoldProcessRegistry(this.holdProcessRegistry);
    }

    @Test
    public void testUpdateBulkStatus() {
        HoldBulkStatus status = new HoldBulkStatus("bulkStatusId", null, null, 0L, 0L, 0L, null, false, null);
        this.holdBulkMonitor.updateBulkStatus(status);
        ((SimpleCache)Mockito.verify(this.holdProgressCache)).put((Serializable)((Object)"bulkStatusId"), (Object)status);
    }

    @Test
    public void testRegisterProcess() {
        NodeRef holdRef = new NodeRef("workspace://SpacesStore/holdId");
        String processId = "processId";
        Mockito.when((Object)((HoldBulkProcessDetails)this.holdProcessRegistry.get((Serializable)new Pair((Object)holdRef.getId(), (Object)processId)))).thenReturn(null);
        this.holdBulkMonitor.registerProcess(holdRef, processId, null);
        ((SimpleCache)Mockito.verify(this.holdProcessRegistry)).put((Serializable)new Pair((Object)holdRef.getId(), (Object)processId), (Object)new HoldBulkProcessDetails(processId, null, null));
    }

    @Test
    public void testGetBulkStatusesWithProcessDetailsReturnsEmptyListWhenNoProcessesWithProcessDetails() {
        Mockito.when((Object)this.holdProcessRegistry.getKeys()).thenReturn(Collections.emptyList());
        Assert.assertEquals(Collections.emptyList(), (Object)this.holdBulkMonitor.getBulkStatusesWithProcessDetails("holdId"));
    }

    @Test
    public void testGetBulkStatus() {
        BulkOperation bulkOperation = (BulkOperation)Mockito.mock(BulkOperation.class);
        HoldBulkStatus status1 = new HoldBulkStatus("process1", new Date(1000L), new Date(2000L), 0L, 0L, 0L, null, false, null);
        Mockito.when((Object)((HoldBulkProcessDetails)this.holdProcessRegistry.get((Serializable)new Pair((Object)"holdId", (Object)"process1")))).thenReturn((Object)new HoldBulkProcessDetails("process1", null, bulkOperation));
        Mockito.when((Object)((HoldBulkStatus)this.holdProgressCache.get((Serializable)((Object)"process1")))).thenReturn((Object)status1);
        Assert.assertEquals((Object)new HoldBulkStatusAndProcessDetails(status1, new HoldBulkProcessDetails(status1.bulkStatusId(), null, bulkOperation)), (Object)this.holdBulkMonitor.getBulkStatusWithProcessDetails("holdId", "process1"));
    }

    @Test
    public void testGetNonExistingBulkStatus() {
        BulkOperation bulkOperation = (BulkOperation)Mockito.mock(BulkOperation.class);
        Mockito.when((Object)((HoldBulkProcessDetails)this.holdProcessRegistry.get((Serializable)new Pair((Object)"holdId", (Object)"process1")))).thenReturn((Object)new HoldBulkProcessDetails("process1", null, bulkOperation));
        Mockito.when((Object)((HoldBulkStatus)this.holdProgressCache.get((Serializable)((Object)"process1")))).thenReturn(null);
        Assert.assertNull((Object)this.holdBulkMonitor.getBulkStatusWithProcessDetails("holdId", "process1"));
    }

    @Test
    public void testGetBulkStatusesForHoldReturnsSortedStatusesWithProcessDetails() {
        BulkOperation bulkOperation = (BulkOperation)Mockito.mock(BulkOperation.class);
        HoldBulkStatus status1 = new HoldBulkStatus("process1", new Date(1000L), new Date(2000L), 0L, 0L, 0L, null, false, null);
        HoldBulkStatus status2 = new HoldBulkStatus("process2", new Date(3000L), null, 0L, 0L, 0L, null, false, null);
        HoldBulkStatus status3 = new HoldBulkStatus("process3", new Date(4000L), null, 0L, 0L, 0L, null, false, null);
        HoldBulkStatus status4 = new HoldBulkStatus("process4", new Date(500L), new Date(800L), 0L, 0L, 0L, null, false, null);
        HoldBulkStatus status5 = new HoldBulkStatus("process5", null, null, 0L, 0L, 0L, null, false, null);
        Mockito.when((Object)this.holdProcessRegistry.getKeys()).thenReturn(Arrays.asList(new Pair((Object)"holdId", (Object)"process1"), new Pair((Object)"holdId", (Object)"process2"), new Pair((Object)"holdId", (Object)"process3"), new Pair((Object)"holdId", (Object)"process4"), new Pair((Object)"holdId", (Object)"process5")));
        Mockito.when((Object)((HoldBulkProcessDetails)this.holdProcessRegistry.get((Serializable)new Pair((Object)"holdId", (Object)"process1")))).thenReturn((Object)new HoldBulkProcessDetails("process1", null, bulkOperation));
        Mockito.when((Object)((HoldBulkProcessDetails)this.holdProcessRegistry.get((Serializable)new Pair((Object)"holdId", (Object)"process2")))).thenReturn((Object)new HoldBulkProcessDetails("process2", null, bulkOperation));
        Mockito.when((Object)((HoldBulkProcessDetails)this.holdProcessRegistry.get((Serializable)new Pair((Object)"holdId", (Object)"process3")))).thenReturn((Object)new HoldBulkProcessDetails("process3", null, bulkOperation));
        Mockito.when((Object)((HoldBulkProcessDetails)this.holdProcessRegistry.get((Serializable)new Pair((Object)"holdId", (Object)"process4")))).thenReturn((Object)new HoldBulkProcessDetails("process4", null, bulkOperation));
        Mockito.when((Object)((HoldBulkProcessDetails)this.holdProcessRegistry.get((Serializable)new Pair((Object)"holdId", (Object)"process5")))).thenReturn((Object)new HoldBulkProcessDetails("process5", null, bulkOperation));
        Mockito.when((Object)((HoldBulkStatus)this.holdProgressCache.get((Serializable)((Object)"process1")))).thenReturn((Object)status1);
        Mockito.when((Object)((HoldBulkStatus)this.holdProgressCache.get((Serializable)((Object)"process2")))).thenReturn((Object)status2);
        Mockito.when((Object)((HoldBulkStatus)this.holdProgressCache.get((Serializable)((Object)"process3")))).thenReturn((Object)status3);
        Mockito.when((Object)((HoldBulkStatus)this.holdProgressCache.get((Serializable)((Object)"process4")))).thenReturn((Object)status4);
        Mockito.when((Object)((HoldBulkStatus)this.holdProgressCache.get((Serializable)((Object)"process5")))).thenReturn((Object)status5);
        Assert.assertEquals(Arrays.asList(status5, status3, status2, status1, status4).stream().map(status -> new HoldBulkStatusAndProcessDetails(status, new HoldBulkProcessDetails(status.bulkStatusId(), null, bulkOperation))).toList(), (Object)this.holdBulkMonitor.getBulkStatusesWithProcessDetails("holdId"));
    }
}

