/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rm.rest.api.fileplans;

import org.alfresco.module.org_alfresco_module_rm.util.RMParameterCheck;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.rest.framework.WebApiDescription;
import org.alfresco.rest.framework.WebApiParam;
import org.alfresco.rest.framework.core.exceptions.EntityNotFoundException;
import org.alfresco.rest.framework.resource.EntityResource;
import org.alfresco.rest.framework.resource.actions.interfaces.EntityResourceAction;
import org.alfresco.rest.framework.resource.parameters.Parameters;
import org.alfresco.rm.rest.api.impl.ApiNodesModelFactory;
import org.alfresco.rm.rest.api.impl.FilePlanComponentsApiUtils;
import org.alfresco.rm.rest.api.model.FilePlan;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ParameterCheck;
import org.springframework.beans.factory.InitializingBean;

@EntityResource(name="file-plans", title="File plans")
public class FilePlanEntityResource
implements EntityResourceAction.ReadById<FilePlan>,
EntityResourceAction.Update<FilePlan>,
InitializingBean {
    private FilePlanComponentsApiUtils apiUtils;
    private FileFolderService fileFolderService;
    private ApiNodesModelFactory nodesModelFactory;
    private TransactionService transactionService;

    public void setApiUtils(FilePlanComponentsApiUtils apiUtils) {
        this.apiUtils = apiUtils;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodesModelFactory(ApiNodesModelFactory nodesModelFactory) {
        this.nodesModelFactory = nodesModelFactory;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void afterPropertiesSet() throws Exception {
        ParameterCheck.mandatory((String)"apiUtils", (Object)this.apiUtils);
        ParameterCheck.mandatory((String)"fileFolderService", (Object)this.fileFolderService);
        ParameterCheck.mandatory((String)"nodesModelFactory", (Object)this.nodesModelFactory);
    }

    @WebApiDescription(title="Get file plan information", description="Get information for a file plan with id 'filePlanId'")
    @WebApiParam(name="filePlanId", title="The file plan id")
    public FilePlan readById(String filePlanId, Parameters parameters) {
        RMParameterCheck.checkNotBlank("filePlanId", filePlanId);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        QName filePlanType = this.apiUtils.getFilePlanType();
        if (filePlanType == null) {
            throw new EntityNotFoundException(filePlanId);
        }
        NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(filePlanId, filePlanType);
        FileInfo info = this.fileFolderService.getFileInfo(nodeRef);
        return this.nodesModelFactory.createFilePlan(info, parameters, null, false);
    }

    @WebApiDescription(title="Update file plan", description="Updates a filePlan with id 'filePlanId'")
    public FilePlan update(String filePlanId, final FilePlan filePlanInfo, final Parameters parameters) {
        RMParameterCheck.checkNotBlank("filePlanId", filePlanId);
        ParameterCheck.mandatory((String)"filePlanInfo", (Object)filePlanInfo);
        ParameterCheck.mandatory((String)"parameters", (Object)parameters);
        QName filePlanType = this.apiUtils.getFilePlanType();
        if (filePlanType == null) {
            throw new EntityNotFoundException(filePlanId);
        }
        final NodeRef nodeRef = this.apiUtils.lookupAndValidateNodeType(filePlanId, filePlanType);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> updateCallback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() {
                FilePlanEntityResource.this.apiUtils.updateNode(nodeRef, filePlanInfo, parameters);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)updateCallback, false, true);
        RetryingTransactionHelper.RetryingTransactionCallback<FileInfo> readCallback = new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

            public FileInfo execute() {
                return FilePlanEntityResource.this.fileFolderService.getFileInfo(nodeRef);
            }
        };
        FileInfo info = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)readCallback, false, true);
        return this.nodesModelFactory.createFilePlan(info, parameters, null, false);
    }
}

